/*
 * Decompiled with CFR 0.152.
 */
package kafka.client;

import java.io.IOException;
import java.io.Serializable;
import java.util.Properties;
import kafka.api.GroupCoordinatorRequest;
import kafka.api.GroupCoordinatorRequest$;
import kafka.api.GroupCoordinatorResponse;
import kafka.api.GroupCoordinatorResponse$;
import kafka.api.TopicMetadataRequest;
import kafka.api.TopicMetadataRequest$;
import kafka.api.TopicMetadataResponse;
import kafka.cluster.Broker;
import kafka.cluster.BrokerEndPoint;
import kafka.cluster.BrokerEndPoint$;
import kafka.cluster.EndPoint;
import kafka.common.BrokerEndPointNotAvailableException;
import kafka.common.KafkaException;
import kafka.network.BlockingChannel;
import kafka.network.BlockingChannel$;
import kafka.producer.ProducerConfig;
import kafka.producer.ProducerPool$;
import kafka.producer.SyncProducer;
import kafka.utils.CoreUtils$;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.ZkUtils;
import org.apache.kafka.common.network.NetworkReceive;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.StringOps;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ObjectRef;
import scala.util.Random$;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public final class ClientUtils$
implements Logging {
    public static ClientUtils$ MODULE$;
    private final String loggerName;
    private Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    private volatile boolean bitmap$0;

    static {
        new ClientUtils$();
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public Object trace(Function0<Throwable> e) {
        return Logging.trace$(this, e);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public void swallowTrace(Function0<BoxedUnit> action) {
        Logging.swallowTrace$(this, action);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public Object debug(Function0<Throwable> e) {
        return Logging.debug$(this, e);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void swallowDebug(Function0<BoxedUnit> action) {
        Logging.swallowDebug$(this, action);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public Object info(Function0<Throwable> e) {
        return Logging.info$(this, e);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void swallowInfo(Function0<BoxedUnit> action) {
        Logging.swallowInfo$(this, action);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public Object warn(Function0<Throwable> e) {
        return Logging.warn$(this, e);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void swallowWarn(Function0<BoxedUnit> action) {
        Logging.swallowWarn$(this, action);
    }

    @Override
    public void swallow(Function0<BoxedUnit> action) {
        Logging.swallow$(this, action);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public Object error(Function0<Throwable> e) {
        return Logging.error$(this, e);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void swallowError(Function0<BoxedUnit> action) {
        Logging.swallowError$(this, action);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public Object fatal(Function0<Throwable> e) {
        return Logging.fatal$(this, e);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    private Logger logger$lzycompute() {
        ClientUtils$ clientUtils$ = this;
        synchronized (clientUtils$) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String x$1) {
        this.loggerName = x$1;
    }

    @Override
    public final void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ x$1) {
        this.kafka$utils$Logging$$log4jController = x$1;
    }

    public TopicMetadataResponse fetchTopicMetadata(Set<String> topics, Seq<BrokerEndPoint> brokers, ProducerConfig producerConfig, int correlationId) {
        boolean fetchMetaDataSucceeded = false;
        IntRef i = IntRef.create((int)0);
        TopicMetadataRequest topicMetadataRequest = new TopicMetadataRequest(TopicMetadataRequest$.MODULE$.CurrentVersion(), correlationId, producerConfig.clientId(), (Seq<String>)topics.toSeq());
        TopicMetadataResponse topicMetadataResponse = null;
        Throwable t = null;
        Seq shuffledBrokers = (Seq)Random$.MODULE$.shuffle(brokers, Seq$.MODULE$.canBuildFrom());
        while (i.elem < shuffledBrokers.size() && !fetchMetaDataSucceeded) {
            SyncProducer producer = ProducerPool$.MODULE$.createSyncProducer(producerConfig, (BrokerEndPoint)shuffledBrokers.apply(i.elem));
            this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Fetching metadata from broker %s with correlation id %d for %d topic(s) %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{shuffledBrokers.apply(i$1.elem), BoxesRunTime.boxToInteger((int)correlationId), BoxesRunTime.boxToInteger((int)topics.size()), topics})));
            try {
                try {
                    topicMetadataResponse = producer.send(topicMetadataRequest);
                    fetchMetaDataSucceeded = true;
                }
                catch (Throwable e) {
                    this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Fetching topic metadata with correlation id %d for topics [%s] from broker [%s] failed")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)correlationId), topics, shuffledBrokers.apply(i$1.elem).toString()})), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
                    t = e;
                }
            }
            finally {
                ++i.elem;
                producer.close();
            }
        }
        if (!fetchMetaDataSucceeded) {
            throw new KafkaException(new StringOps(Predef$.MODULE$.augmentString("fetching topic metadata for topics [%s] from broker [%s] failed")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topics, shuffledBrokers})), t);
        }
        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Successfully fetched metadata for %d topic(s) %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)topics.size()), topics})));
        return topicMetadataResponse;
    }

    public TopicMetadataResponse fetchTopicMetadata(Set<String> topics, Seq<BrokerEndPoint> brokers, String clientId, int timeoutMs, int correlationId) {
        Properties props = new Properties();
        props.put("metadata.broker.list", ((TraversableOnce)brokers.map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.connectionString(), Seq$.MODULE$.canBuildFrom())).mkString(","));
        props.put("client.id", clientId);
        props.put("request.timeout.ms", ((Object)BoxesRunTime.boxToInteger((int)timeoutMs)).toString());
        ProducerConfig producerConfig = new ProducerConfig(props);
        return this.fetchTopicMetadata(topics, brokers, producerConfig, correlationId);
    }

    public int fetchTopicMetadata$default$5() {
        return 0;
    }

    public Seq<BrokerEndPoint> parseBrokerList(String brokerListStr) {
        Seq<String> brokersStr = CoreUtils$.MODULE$.parseCsvList(brokerListStr);
        return (Seq)((TraversableLike)brokersStr.zipWithIndex(Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String address = (String)tuple2._1();
            int brokerId = tuple2._2$mcI$sp();
            BrokerEndPoint brokerEndPoint = BrokerEndPoint$.MODULE$.createBrokerEndPoint(brokerId, address);
            return brokerEndPoint;
        }, Seq$.MODULE$.canBuildFrom());
    }

    public BlockingChannel channelToAnyBroker(ZkUtils zkUtils, int socketTimeoutMs) {
        ObjectRef channel = ObjectRef.create(null);
        boolean connected = false;
        while (!connected) {
            Seq<BrokerEndPoint> allBrokers = this.getPlaintextBrokerEndPoints(zkUtils);
            ((IterableLike)Random$.MODULE$.shuffle(allBrokers, Seq$.MODULE$.canBuildFrom())).find((Function1 & Serializable & scala.Serializable)broker -> BoxesRunTime.boxToBoolean((boolean)ClientUtils$.$anonfun$channelToAnyBroker$1(socketTimeoutMs, channel, broker)));
            connected = (BlockingChannel)channel.elem != null;
        }
        return (BlockingChannel)channel.elem;
    }

    public int channelToAnyBroker$default$2() {
        return 3000;
    }

    public Seq<BrokerEndPoint> getPlaintextBrokerEndPoints(ZkUtils zkUtils) {
        return (Seq)zkUtils.getAllBrokersInCluster().map((Function1 & Serializable & scala.Serializable)broker -> (BrokerEndPoint)broker.endPoints().collectFirst((PartialFunction)new scala.Serializable((Broker)broker){
            public static final long serialVersionUID = 0L;
            private final Broker broker$2;

            public final <A1 extends EndPoint, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                SecurityProtocol securityProtocol = A1.securityProtocol();
                SecurityProtocol securityProtocol2 = SecurityProtocol.PLAINTEXT;
                Object object = !(securityProtocol != null ? !securityProtocol.equals(securityProtocol2) : securityProtocol2 != null) ? new BrokerEndPoint(this.broker$2.id(), A1.host(), A1.port()) : function1.apply(x1);
                return (B1)object;
            }

            public final boolean isDefinedAt(EndPoint x1) {
                EndPoint endPoint = x1;
                SecurityProtocol securityProtocol = endPoint.securityProtocol();
                SecurityProtocol securityProtocol2 = SecurityProtocol.PLAINTEXT;
                boolean bl = !(securityProtocol != null ? !securityProtocol.equals(securityProtocol2) : securityProtocol2 != null);
                return bl;
            }
            {
                this.broker$2 = broker$2;
            }
        }).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new BrokerEndPointNotAvailableException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"End point with security protocol PLAINTEXT not found for broker ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)broker.id())})));
        }), Seq$.MODULE$.canBuildFrom());
    }

    public BlockingChannel channelToOffsetManager(String group, ZkUtils zkUtils, int socketTimeoutMs, int retryBackOffMs) {
        ObjectRef queryChannel = ObjectRef.create((Object)this.channelToAnyBroker(zkUtils, this.channelToAnyBroker$default$2()));
        None$ offsetManagerChannelOpt = None$.MODULE$;
        while (offsetManagerChannelOpt.isEmpty()) {
            Option<BrokerEndPoint> coordinatorOpt = None$.MODULE$;
            while (coordinatorOpt.isEmpty()) {
                try {
                    if (!((BlockingChannel)queryChannel.elem).isConnected()) {
                        queryChannel.elem = this.channelToAnyBroker(zkUtils, this.channelToAnyBroker$default$2());
                    }
                    this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Querying %s:%d to locate offset manager for %s.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((BlockingChannel)queryChannel$1.elem).host(), BoxesRunTime.boxToInteger((int)((BlockingChannel)queryChannel$1.elem).port()), group})));
                    ((BlockingChannel)queryChannel.elem).send(new GroupCoordinatorRequest(group, GroupCoordinatorRequest$.MODULE$.apply$default$2(), GroupCoordinatorRequest$.MODULE$.apply$default$3(), GroupCoordinatorRequest$.MODULE$.apply$default$4()));
                    NetworkReceive response = ((BlockingChannel)queryChannel.elem).receive();
                    GroupCoordinatorResponse consumerMetadataResponse = GroupCoordinatorResponse$.MODULE$.readFrom(response.payload());
                    this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Consumer metadata response: " + consumerMetadataResponse.toString());
                    Errors errors = consumerMetadataResponse.error();
                    Errors errors2 = Errors.NONE;
                    if (!(errors != null ? !errors.equals(errors2) : errors2 != null)) {
                        coordinatorOpt = consumerMetadataResponse.coordinatorOpt();
                        continue;
                    }
                    this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Query to %s:%d to locate offset manager for %s failed - will retry in %d milliseconds.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((BlockingChannel)queryChannel$1.elem).host(), BoxesRunTime.boxToInteger((int)((BlockingChannel)queryChannel$1.elem).port()), group, BoxesRunTime.boxToInteger((int)retryBackOffMs)})));
                    Thread.sleep(retryBackOffMs);
                }
                catch (IOException iOException) {
                    this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Failed to fetch consumer metadata from %s:%d.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((BlockingChannel)queryChannel$1.elem).host(), BoxesRunTime.boxToInteger((int)((BlockingChannel)queryChannel$1.elem).port())})));
                    ((BlockingChannel)queryChannel.elem).disconnect();
                }
            }
            BrokerEndPoint coordinator = (BrokerEndPoint)coordinatorOpt.get();
            String string = coordinator.host();
            String string2 = ((BlockingChannel)queryChannel.elem).host();
            if (!(string != null ? !string.equals(string2) : string2 != null) && coordinator.port() == ((BlockingChannel)queryChannel.elem).port()) {
                offsetManagerChannelOpt = new Some((Object)((BlockingChannel)queryChannel.elem));
                continue;
            }
            String connectString = new StringOps(Predef$.MODULE$.augmentString("%s:%d")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{coordinator.host(), BoxesRunTime.boxToInteger((int)coordinator.port())}));
            BlockingChannel offsetManagerChannel = null;
            try {
                this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Connecting to offset manager %s.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{connectString})));
                offsetManagerChannel = new BlockingChannel(coordinator.host(), coordinator.port(), BlockingChannel$.MODULE$.UseDefaultBufferSize(), BlockingChannel$.MODULE$.UseDefaultBufferSize(), socketTimeoutMs);
                offsetManagerChannel.connect();
                offsetManagerChannelOpt = new Some((Object)offsetManagerChannel);
                ((BlockingChannel)queryChannel.elem).disconnect();
            }
            catch (IOException iOException) {
                this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Error while connecting to %s.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{connectString})));
                if (offsetManagerChannel != null) {
                    offsetManagerChannel.disconnect();
                }
                Thread.sleep(retryBackOffMs);
                offsetManagerChannelOpt = None$.MODULE$;
            }
        }
        return (BlockingChannel)offsetManagerChannelOpt.get();
    }

    public int channelToOffsetManager$default$3() {
        return 3000;
    }

    public int channelToOffsetManager$default$4() {
        return 1000;
    }

    public static final /* synthetic */ boolean $anonfun$channelToAnyBroker$1(int socketTimeoutMs$1, ObjectRef channel$1, BrokerEndPoint broker) {
        boolean bl;
        MODULE$.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Connecting to broker %s:%d.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{broker.host(), BoxesRunTime.boxToInteger((int)broker.port())})));
        try {
            channel$1.elem = new BlockingChannel(broker.host(), broker.port(), BlockingChannel$.MODULE$.UseDefaultBufferSize(), BlockingChannel$.MODULE$.UseDefaultBufferSize(), socketTimeoutMs$1);
            ((BlockingChannel)channel$1.elem).connect();
            MODULE$.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Created channel to broker %s:%d.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((BlockingChannel)channel$1.elem).host(), BoxesRunTime.boxToInteger((int)((BlockingChannel)channel$1.elem).port())})));
            bl = true;
        }
        catch (Exception exception) {
            if ((BlockingChannel)channel$1.elem != null) {
                ((BlockingChannel)channel$1.elem).disconnect();
            }
            channel$1.elem = null;
            MODULE$.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Error while creating channel to %s:%d.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{broker.host(), BoxesRunTime.boxToInteger((int)broker.port())})));
            bl = false;
        }
        return bl;
    }

    private ClientUtils$() {
        MODULE$ = this;
        Logging.$init$(this);
    }
}

