/*
 * Decompiled with CFR 0.152.
 */
package kafka.controller;

import java.io.Serializable;
import kafka.common.StateChangeFailedException;
import kafka.common.TopicAndPartition;
import kafka.controller.Callbacks;
import kafka.controller.ControllerBrokerRequestBatch;
import kafka.controller.ControllerContext;
import kafka.controller.KafkaController;
import kafka.controller.LeaderIsrAndControllerEpoch;
import kafka.controller.NewReplica$;
import kafka.controller.NonExistentReplica$;
import kafka.controller.OfflineReplica$;
import kafka.controller.OnlineReplica$;
import kafka.controller.PartitionAndReplica;
import kafka.controller.ReplicaDeletionIneligible$;
import kafka.controller.ReplicaDeletionStarted$;
import kafka.controller.ReplicaDeletionSuccessful$;
import kafka.controller.ReplicaState;
import kafka.controller.StateChangeLogger;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.ReplicationUtils$;
import kafka.utils.ZkUtils;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.Set;
import scala.collection.Set$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction1;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001\u0005\re\u0001B\u0001\u0003\u0001\u001d\u00111CU3qY&\u001c\u0017m\u0015;bi\u0016l\u0015m\u00195j]\u0016T!a\u0001\u0003\u0002\u0015\r|g\u000e\u001e:pY2,'OC\u0001\u0006\u0003\u0015Y\u0017MZ6b\u0007\u0001\u00192\u0001\u0001\u0005\u000f!\tIA\"D\u0001\u000b\u0015\u0005Y\u0011!B:dC2\f\u0017BA\u0007\u000b\u0005\u0019\te.\u001f*fMB\u0011qBE\u0007\u0002!)\u0011\u0011\u0003B\u0001\u0006kRLGn]\u0005\u0003'A\u0011q\u0001T8hO&tw\r\u0003\u0005\u0004\u0001\t\u0005\t\u0015!\u0003\u0016!\t1r#D\u0001\u0003\u0013\tA\"AA\bLC\u001a\\\u0017mQ8oiJ|G\u000e\\3s\u0011!Q\u0002A!A!\u0002\u0013Y\u0012!E:uCR,7\t[1oO\u0016dunZ4feB\u0011a\u0003H\u0005\u0003;\t\u0011\u0011c\u0015;bi\u0016\u001c\u0005.\u00198hK2{wmZ3s\u0011\u0015y\u0002\u0001\"\u0001!\u0003\u0019a\u0014N\\5u}Q\u0019\u0011EI\u0012\u0011\u0005Y\u0001\u0001\"B\u0002\u001f\u0001\u0004)\u0002\"\u0002\u000e\u001f\u0001\u0004Y\u0002bB\u0013\u0001\u0005\u0004%IAJ\u0001\u0012G>tGO]8mY\u0016\u00148i\u001c8uKb$X#A\u0014\u0011\u0005YA\u0013BA\u0015\u0003\u0005E\u0019uN\u001c;s_2dWM]\"p]R,\u0007\u0010\u001e\u0005\u0007W\u0001\u0001\u000b\u0011B\u0014\u0002%\r|g\u000e\u001e:pY2,'oQ8oi\u0016DH\u000f\t\u0005\b[\u0001\u0011\r\u0011\"\u0003/\u00031\u0019wN\u001c;s_2dWM]%e+\u0005y\u0003CA\u00051\u0013\t\t$BA\u0002J]RDaa\r\u0001!\u0002\u0013y\u0013!D2p]R\u0014x\u000e\u001c7fe&#\u0007\u0005C\u00046\u0001\t\u0007I\u0011\u0002\u001c\u0002\u000fi\\W\u000b^5mgV\tq\u0007\u0005\u0002\u0010q%\u0011\u0011\b\u0005\u0002\b5.,F/\u001b7t\u0011\u0019Y\u0004\u0001)A\u0005o\u0005A!p[+uS2\u001c\b\u0005C\u0004>\u0001\t\u0007I\u0011\u0002 \u0002\u0019I,\u0007\u000f\\5dCN#\u0018\r^3\u0016\u0003}\u0002B\u0001Q#H\u00156\t\u0011I\u0003\u0002C\u0007\u00069Q.\u001e;bE2,'B\u0001#\u000b\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0003\r\u0006\u00131!T1q!\t1\u0002*\u0003\u0002J\u0005\t\u0019\u0002+\u0019:uSRLwN\\!oIJ+\u0007\u000f\\5dCB\u0011acS\u0005\u0003\u0019\n\u0011ABU3qY&\u001c\u0017m\u0015;bi\u0016DaA\u0014\u0001!\u0002\u0013y\u0014!\u0004:fa2L7-Y*uCR,\u0007\u0005C\u0004Q\u0001\t\u0007I\u0011B)\u0002%\t\u0014xn[3s%\u0016\fX/Z:u\u0005\u0006$8\r[\u000b\u0002%B\u0011acU\u0005\u0003)\n\u0011AdQ8oiJ|G\u000e\\3s\u0005J|7.\u001a:SKF,Xm\u001d;CCR\u001c\u0007\u000e\u0003\u0004W\u0001\u0001\u0006IAU\u0001\u0014EJ|7.\u001a:SKF,Xm\u001d;CCR\u001c\u0007\u000e\t\u0005\u00061\u0002!\t!W\u0001\bgR\f'\u000f^;q)\u0005Q\u0006CA\u0005\\\u0013\ta&B\u0001\u0003V]&$\b\"\u00020\u0001\t\u0003I\u0016\u0001C:ikR$wn\u001e8\t\u000b\u0001\u0004A\u0011A1\u0002%!\fg\u000e\u001a7f'R\fG/Z\"iC:<Wm\u001d\u000b\u00055\nD'\u000eC\u0003d?\u0002\u0007A-\u0001\u0005sKBd\u0017nY1t!\r)gmR\u0007\u0002\u0007&\u0011qm\u0011\u0002\u0004'\u0016$\b\"B5`\u0001\u0004Q\u0015a\u0003;be\u001e,Go\u0015;bi\u0016Dqa[0\u0011\u0002\u0003\u0007A.A\u0005dC2d'-Y2lgB\u0011a#\\\u0005\u0003]\n\u0011\u0011bQ1mY\n\f7m[:\t\u000bA\u0004A\u0011A9\u0002#!\fg\u000e\u001a7f'R\fG/Z\"iC:<W\r\u0006\u0003[eR,\b\"B:p\u0001\u00049\u0015a\u00059beRLG/[8o\u0003:$'+\u001a9mS\u000e\f\u0007\"B5p\u0001\u0004Q\u0005\"B6p\u0001\u0004a\u0007\"B<\u0001\t\u0003A\u0018!H1sK\u0006cGNU3qY&\u001c\u0017m\u001d$peR{\u0007/[2EK2,G/\u001a3\u0015\u0005ed\bCA\u0005{\u0013\tY(BA\u0004C_>dW-\u00198\t\u000bu4\b\u0019\u0001@\u0002\u000bQ|\u0007/[2\u0011\u0007}\fiA\u0004\u0003\u0002\u0002\u0005%\u0001cAA\u0002\u00155\u0011\u0011Q\u0001\u0006\u0004\u0003\u000f1\u0011A\u0002\u001fs_>$h(C\u0002\u0002\f)\ta\u0001\u0015:fI\u00164\u0017\u0002BA\b\u0003#\u0011aa\u0015;sS:<'bAA\u0006\u0015!9\u0011Q\u0003\u0001\u0005\u0002\u0005]\u0011!K5t\u0003RdU-Y:u\u001f:,'+\u001a9mS\u000e\f\u0017J\u001c#fY\u0016$\u0018n\u001c8Ti\u0006\u0014H/\u001a3Ti\u0006$X\rF\u0002z\u00033Aa!`A\n\u0001\u0004q\bbBA\u000f\u0001\u0011\u0005\u0011qD\u0001\u0010e\u0016\u0004H.[2bg&s7\u000b^1uKR)A-!\t\u0002$!1Q0a\u0007A\u0002yDq!!\n\u0002\u001c\u0001\u0007!*A\u0003ti\u0006$X\rC\u0004\u0002*\u0001!\t!a\u000b\u0002'%\u001c\u0018I\\=SKBd\u0017nY1J]N#\u0018\r^3\u0015\u000be\fi#a\f\t\ru\f9\u00031\u0001\u007f\u0011\u001d\t)#a\nA\u0002)Cq!a\r\u0001\t\u0003\t)$\u0001\rsKBd\u0017nY1t\u0013:$U\r\\3uS>t7\u000b^1uKN$2\u0001ZA\u001c\u0011\u0019i\u0018\u0011\u0007a\u0001}\"9\u00111\b\u0001\u0005\n\u0005u\u0012!F1tg\u0016\u0014HOV1mS\u0012$&/\u00198tSRLwN\u001c\u000b\u00065\u0006}\u0012\u0011\t\u0005\u0007g\u0006e\u0002\u0019A$\t\r%\fI\u00041\u0001K\u0011\u0019\t)\u0005\u0001C\u00053\u00061\u0012N\\5uS\u0006d\u0017N_3SKBd\u0017nY1Ti\u0006$X\rC\u0004\u0002J\u0001!\t!a\u0013\u00025A\f'\u000f^5uS>t7/Q:tS\u001etW\r\u001a+p\u0005J|7.\u001a:\u0015\r\u00055\u0013qLA3!\u0015)\u0017qJA*\u0013\r\t\tf\u0011\u0002\u0004'\u0016\f\b\u0003BA+\u00037j!!a\u0016\u000b\u0007\u0005eC!\u0001\u0004d_6lwN\\\u0005\u0005\u0003;\n9FA\tU_BL7-\u00118e!\u0006\u0014H/\u001b;j_:D\u0001\"!\u0019\u0002H\u0001\u0007\u00111M\u0001\u0007i>\u0004\u0018nY:\u0011\t\u0015\fyE \u0005\b\u0003O\n9\u00051\u00010\u0003!\u0011'o\\6fe&#\u0007\"CA6\u0001E\u0005I\u0011AA7\u0003qA\u0017M\u001c3mKN#\u0018\r^3DQ\u0006tw-Z:%I\u00164\u0017-\u001e7uIM*\"!a\u001c+\u00071\f\th\u000b\u0002\u0002tA!\u0011QOA@\u001b\t\t9H\u0003\u0003\u0002z\u0005m\u0014!C;oG\",7m[3e\u0015\r\tiHC\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BAA\u0003o\u0012\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0001")
public class ReplicaStateMachine
implements Logging {
    private final KafkaController controller;
    private final StateChangeLogger stateChangeLogger;
    private final ControllerContext controllerContext;
    private final int controllerId;
    private final ZkUtils zkUtils;
    private final Map<PartitionAndReplica, ReplicaState> replicaState;
    private final ControllerBrokerRequestBatch brokerRequestBatch;
    private final String loggerName;
    private Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    private volatile boolean bitmap$0;

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public Object trace(Function0<Throwable> e) {
        return Logging.trace$(this, e);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public void swallowTrace(Function0<BoxedUnit> action) {
        Logging.swallowTrace$(this, action);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public Object debug(Function0<Throwable> e) {
        return Logging.debug$(this, e);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void swallowDebug(Function0<BoxedUnit> action) {
        Logging.swallowDebug$(this, action);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public Object info(Function0<Throwable> e) {
        return Logging.info$(this, e);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void swallowInfo(Function0<BoxedUnit> action) {
        Logging.swallowInfo$(this, action);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public Object warn(Function0<Throwable> e) {
        return Logging.warn$(this, e);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void swallowWarn(Function0<BoxedUnit> action) {
        Logging.swallowWarn$(this, action);
    }

    @Override
    public void swallow(Function0<BoxedUnit> action) {
        Logging.swallow$(this, action);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public Object error(Function0<Throwable> e) {
        return Logging.error$(this, e);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void swallowError(Function0<BoxedUnit> action) {
        Logging.swallowError$(this, action);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public Object fatal(Function0<Throwable> e) {
        return Logging.fatal$(this, e);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    private Logger logger$lzycompute() {
        ReplicaStateMachine replicaStateMachine = this;
        synchronized (replicaStateMachine) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String x$1) {
        this.loggerName = x$1;
    }

    @Override
    public final void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ x$1) {
        this.kafka$utils$Logging$$log4jController = x$1;
    }

    private ControllerContext controllerContext() {
        return this.controllerContext;
    }

    private int controllerId() {
        return this.controllerId;
    }

    private ZkUtils zkUtils() {
        return this.zkUtils;
    }

    private Map<PartitionAndReplica, ReplicaState> replicaState() {
        return this.replicaState;
    }

    private ControllerBrokerRequestBatch brokerRequestBatch() {
        return this.brokerRequestBatch;
    }

    public void startup() {
        this.initializeReplicaState();
        this.handleStateChanges(this.controllerContext().allLiveReplicas(), OnlineReplica$.MODULE$, this.handleStateChanges$default$3());
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Started replica state machine with initial state -> " + this.replicaState().toString());
    }

    public void shutdown() {
        this.replicaState().clear();
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Stopped replica state machine");
    }

    public void handleStateChanges(Set<PartitionAndReplica> replicas, ReplicaState targetState, Callbacks callbacks) {
        block2: {
            if (!replicas.nonEmpty()) break block2;
            this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Invoking state change to %s for replicas %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{targetState, replicas.mkString(",")})));
            try {
                this.brokerRequestBatch().newBatch();
                replicas.foreach((Function1 & Serializable & scala.Serializable)r -> {
                    this.handleStateChange(r, targetState, callbacks);
                    return BoxedUnit.UNIT;
                });
                this.brokerRequestBatch().sendRequestsToBrokers(this.controller.epoch());
            }
            catch (Throwable e) {
                this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Error while moving some replicas to %s state")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{targetState})), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
            }
        }
    }

    public void handleStateChange(PartitionAndReplica partitionAndReplica, ReplicaState targetState, Callbacks callbacks) {
        block30: {
            String topic = partitionAndReplica.topic();
            int partition = partitionAndReplica.partition();
            int replicaId = partitionAndReplica.replica();
            TopicAndPartition topicAndPartition = new TopicAndPartition(topic, partition);
            ReplicaState currState = (ReplicaState)this.replicaState().getOrElseUpdate((Object)partitionAndReplica, (Function0 & Serializable & scala.Serializable)() -> NonExistentReplica$.MODULE$);
            StateChangeLogger stateChangeLog = this.stateChangeLogger.withControllerEpoch(this.controller.epoch());
            try {
                Seq replicaAssignment = (Seq)this.controllerContext().partitionReplicaAssignment().apply((Object)topicAndPartition);
                this.assertValidTransition(partitionAndReplica, targetState);
                ReplicaState replicaState = targetState;
                if (NewReplica$.MODULE$.equals(replicaState)) {
                    Option<LeaderIsrAndControllerEpoch> leaderIsrAndControllerEpochOpt = ReplicationUtils$.MODULE$.getLeaderIsrAndEpochForPartition(this.zkUtils(), topic, partition);
                    Option<LeaderIsrAndControllerEpoch> option = leaderIsrAndControllerEpochOpt;
                    if (option instanceof Some) {
                        Some some = (Some)option;
                        LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = (LeaderIsrAndControllerEpoch)some.value();
                        if (leaderIsrAndControllerEpoch.leaderAndIsr().leader() == replicaId) {
                            throw new StateChangeFailedException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Replica ", " for partition ", " cannot "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)replicaId), topicAndPartition})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"be moved to NewReplica state as it is being requested to become leader"})).s((Seq)Nil$.MODULE$));
                        }
                        this.brokerRequestBatch().addLeaderAndIsrRequestForBrokers((Seq<Object>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{replicaId})), topic, partition, leaderIsrAndControllerEpoch, (Seq<Object>)replicaAssignment, true);
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    } else if (None$.MODULE$.equals(option)) {
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    } else {
                        throw new MatchError(option);
                    }
                    this.replicaState().put((Object)partitionAndReplica, (Object)NewReplica$.MODULE$);
                    ReplicaStateMachine.logStateChange$1(targetState, replicaId, topicAndPartition, currState, stateChangeLog);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block30;
                }
                if (ReplicaDeletionStarted$.MODULE$.equals(replicaState)) {
                    this.replicaState().put((Object)partitionAndReplica, (Object)ReplicaDeletionStarted$.MODULE$);
                    this.brokerRequestBatch().addStopReplicaRequestForBrokers((Seq<Object>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{replicaId})), topic, partition, true, callbacks.stopReplicaResponseCallback());
                    ReplicaStateMachine.logStateChange$1(targetState, replicaId, topicAndPartition, currState, stateChangeLog);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block30;
                }
                if (ReplicaDeletionIneligible$.MODULE$.equals(replicaState)) {
                    this.replicaState().put((Object)partitionAndReplica, (Object)ReplicaDeletionIneligible$.MODULE$);
                    ReplicaStateMachine.logStateChange$1(targetState, replicaId, topicAndPartition, currState, stateChangeLog);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block30;
                }
                if (ReplicaDeletionSuccessful$.MODULE$.equals(replicaState)) {
                    this.replicaState().put((Object)partitionAndReplica, (Object)ReplicaDeletionSuccessful$.MODULE$);
                    ReplicaStateMachine.logStateChange$1(targetState, replicaId, topicAndPartition, currState, stateChangeLog);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block30;
                }
                if (NonExistentReplica$.MODULE$.equals(replicaState)) {
                    Seq currentAssignedReplicas = (Seq)this.controllerContext().partitionReplicaAssignment().apply((Object)topicAndPartition);
                    this.controllerContext().partitionReplicaAssignment().put((Object)topicAndPartition, currentAssignedReplicas.filterNot((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)x$1 -> x$1 == replicaId));
                    this.replicaState().remove((Object)partitionAndReplica);
                    ReplicaStateMachine.logStateChange$1(targetState, replicaId, topicAndPartition, currState, stateChangeLog);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block30;
                }
                if (OnlineReplica$.MODULE$.equals(replicaState)) {
                    ReplicaState replicaState2 = (ReplicaState)this.replicaState().apply((Object)partitionAndReplica);
                    if (NewReplica$.MODULE$.equals(replicaState2)) {
                        Seq currentAssignedReplicas = (Seq)this.controllerContext().partitionReplicaAssignment().apply((Object)topicAndPartition);
                        Object object = !currentAssignedReplicas.contains((Object)BoxesRunTime.boxToInteger((int)replicaId)) ? this.controllerContext().partitionReplicaAssignment().put((Object)topicAndPartition, currentAssignedReplicas.$colon$plus((Object)BoxesRunTime.boxToInteger((int)replicaId), Seq$.MODULE$.canBuildFrom())) : BoxedUnit.UNIT;
                        ReplicaStateMachine.logStateChange$1(targetState, replicaId, topicAndPartition, currState, stateChangeLog);
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    } else {
                        Option option = this.controllerContext().partitionLeadershipInfo().get((Object)topicAndPartition);
                        if (option instanceof Some) {
                            Some some = (Some)option;
                            LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = (LeaderIsrAndControllerEpoch)some.value();
                            this.brokerRequestBatch().addLeaderAndIsrRequestForBrokers((Seq<Object>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{replicaId})), topic, partition, leaderIsrAndControllerEpoch, (Seq<Object>)replicaAssignment, this.brokerRequestBatch().addLeaderAndIsrRequestForBrokers$default$6());
                            this.replicaState().put((Object)partitionAndReplica, (Object)OnlineReplica$.MODULE$);
                            ReplicaStateMachine.logStateChange$1(targetState, replicaId, topicAndPartition, currState, stateChangeLog);
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        } else if (None$.MODULE$.equals(option)) {
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        } else {
                            throw new MatchError((Object)option);
                        }
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    }
                    this.replicaState().put((Object)partitionAndReplica, (Object)OnlineReplica$.MODULE$);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block30;
                }
                if (OfflineReplica$.MODULE$.equals(replicaState)) {
                    boolean bl;
                    this.brokerRequestBatch().addStopReplicaRequestForBrokers((Seq<Object>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{replicaId})), topic, partition, false, this.brokerRequestBatch().addStopReplicaRequestForBrokers$default$5());
                    Option option = this.controllerContext().partitionLeadershipInfo().get((Object)topicAndPartition);
                    if (option instanceof Some) {
                        boolean bl2;
                        Option<LeaderIsrAndControllerEpoch> option2 = this.controller.removeReplicaFromIsr(topic, partition, replicaId);
                        if (option2 instanceof Some) {
                            Some some = (Some)option2;
                            LeaderIsrAndControllerEpoch updatedLeaderIsrAndControllerEpoch = (LeaderIsrAndControllerEpoch)some.value();
                            Seq currentAssignedReplicas = (Seq)this.controllerContext().partitionReplicaAssignment().apply((Object)topicAndPartition);
                            if (!this.controller.topicDeletionManager().isPartitionToBeDeleted(topicAndPartition)) {
                                this.brokerRequestBatch().addLeaderAndIsrRequestForBrokers((Seq<Object>)((Seq)currentAssignedReplicas.filterNot((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)x$2 -> x$2 == replicaId)), topic, partition, updatedLeaderIsrAndControllerEpoch, (Seq<Object>)replicaAssignment, this.brokerRequestBatch().addLeaderAndIsrRequestForBrokers$default$6());
                            }
                            this.replicaState().put((Object)partitionAndReplica, (Object)OfflineReplica$.MODULE$);
                            ReplicaStateMachine.logStateChange$1(targetState, replicaId, topicAndPartition, currState, stateChangeLog);
                            bl2 = false;
                        } else if (None$.MODULE$.equals(option2)) {
                            bl2 = true;
                        } else {
                            throw new MatchError(option2);
                        }
                        bl = bl2;
                    } else if (None$.MODULE$.equals(option)) {
                        bl = true;
                    } else {
                        throw new MatchError((Object)option);
                    }
                    boolean leaderAndIsrIsEmpty = bl;
                    if (leaderAndIsrIsEmpty && !this.controller.topicDeletionManager().isPartitionToBeDeleted(topicAndPartition)) {
                        throw new StateChangeFailedException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to change state of replica ", " for partition ", " since the leader "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)replicaId), topicAndPartition})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"and isr path in zookeeper is empty"})).s((Seq)Nil$.MODULE$));
                    }
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block30;
                }
                throw new MatchError((Object)replicaState);
            }
            catch (Throwable t) {
                stateChangeLog.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Initiated state change of replica ", " for partition ", " from "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)replicaId), topicAndPartition})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " to ", " failed"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{currState, targetState})), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> t);
            }
        }
    }

    public Callbacks handleStateChanges$default$3() {
        return new Callbacks.CallbackBuilder().build();
    }

    public boolean areAllReplicasForTopicDeleted(String topic) {
        Set<PartitionAndReplica> replicasForTopic = this.controller.controllerContext().replicasForTopic(topic);
        scala.collection.immutable.Map replicaStatesForTopic = ((TraversableOnce)replicasForTopic.map((Function1 & Serializable & scala.Serializable)r -> new Tuple2(r, this.replicaState().apply(r)), Set$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Are all replicas for topic ", " deleted ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topic, replicaStatesForTopic})));
        return replicaStatesForTopic.forall((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)ReplicaStateMachine.$anonfun$areAllReplicasForTopicDeleted$3(x$3)));
    }

    public boolean isAtLeastOneReplicaInDeletionStartedState(String topic) {
        Set<PartitionAndReplica> replicasForTopic = this.controller.controllerContext().replicasForTopic(topic);
        scala.collection.immutable.Map replicaStatesForTopic = ((TraversableOnce)replicasForTopic.map((Function1 & Serializable & scala.Serializable)r -> new Tuple2(r, this.replicaState().apply(r)), Set$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        return BoxesRunTime.unboxToBoolean((Object)replicaStatesForTopic.foldLeft((Object)BoxesRunTime.boxToBoolean((boolean)false), (Function2 & Serializable & scala.Serializable)(deletionState, r) -> BoxesRunTime.boxToBoolean((boolean)ReplicaStateMachine.$anonfun$isAtLeastOneReplicaInDeletionStartedState$2(BoxesRunTime.unboxToBoolean((Object)deletionState), r))));
    }

    public Set<PartitionAndReplica> replicasInState(String topic, ReplicaState state) {
        return ((MapLike)this.replicaState().filter((Function1 & Serializable & scala.Serializable)r -> BoxesRunTime.boxToBoolean((boolean)ReplicaStateMachine.$anonfun$replicasInState$1(topic, state, r)))).keySet();
    }

    public boolean isAnyReplicaInState(String topic, ReplicaState state) {
        return this.replicaState().exists((Function1 & Serializable & scala.Serializable)r -> BoxesRunTime.boxToBoolean((boolean)ReplicaStateMachine.$anonfun$isAnyReplicaInState$1(topic, state, r)));
    }

    public Set<PartitionAndReplica> replicasInDeletionStates(String topic) {
        Set deletionStates = (Set)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReplicaState[]{ReplicaDeletionStarted$.MODULE$, ReplicaDeletionSuccessful$.MODULE$, ReplicaDeletionIneligible$.MODULE$}));
        return ((MapLike)this.replicaState().filter((Function1 & Serializable & scala.Serializable)r -> BoxesRunTime.boxToBoolean((boolean)ReplicaStateMachine.$anonfun$replicasInDeletionStates$1(topic, deletionStates, r)))).keySet();
    }

    private void assertValidTransition(PartitionAndReplica partitionAndReplica, ReplicaState targetState) {
        Predef$.MODULE$.assert(targetState.validPreviousStates().contains(this.replicaState().apply((Object)partitionAndReplica)), (Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Replica %s should be in the %s states before moving to %s state")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{partitionAndReplica, targetState.validPreviousStates().mkString(","), targetState})) + new StringOps(Predef$.MODULE$.augmentString(". Instead it is in %s state")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.replicaState().apply((Object)partitionAndReplica)})));
    }

    private void initializeReplicaState() {
        this.controllerContext().partitionReplicaAssignment().withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)ReplicaStateMachine.$anonfun$initializeReplicaState$1(check$ifrefutable$1))).foreach((Function1 & Serializable & scala.Serializable)x$4 -> {
            ReplicaStateMachine.$anonfun$initializeReplicaState$2(this, x$4);
            return BoxedUnit.UNIT;
        });
    }

    public Seq<TopicAndPartition> partitionsAssignedToBroker(Seq<String> topics, int brokerId) {
        return ((MapLike)this.controllerContext().partitionReplicaAssignment().filter((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)ReplicaStateMachine.$anonfun$partitionsAssignedToBroker$1(brokerId, x$5)))).keySet().toSeq();
    }

    private static final void logStateChange$1(ReplicaState targetState$2, int replicaId$1, TopicAndPartition topicAndPartition$1, ReplicaState currState$1, StateChangeLogger stateChangeLog$1) {
        stateChangeLog$1.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Changed state of replica ", " for partition ", " from "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)replicaId$1), topicAndPartition$1})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " to ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{currState$1, targetState$2})));
    }

    public static final /* synthetic */ boolean $anonfun$areAllReplicasForTopicDeleted$3(Tuple2 x$3) {
        Object object = x$3._2();
        ReplicaDeletionSuccessful$ replicaDeletionSuccessful$ = ReplicaDeletionSuccessful$.MODULE$;
        return !(object != null ? !object.equals(replicaDeletionSuccessful$) : replicaDeletionSuccessful$ != null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$isAtLeastOneReplicaInDeletionStartedState$2(boolean deletionState, Tuple2 r) {
        if (deletionState) return true;
        Object object = r._2();
        ReplicaDeletionStarted$ replicaDeletionStarted$ = ReplicaDeletionStarted$.MODULE$;
        if (object != null) {
            if (!object.equals(replicaDeletionStarted$)) return false;
            return true;
        }
        if (replicaDeletionStarted$ == null) return true;
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$replicasInState$1(String topic$2, ReplicaState state$1, Tuple2 r) {
        if (!((PartitionAndReplica)r._1()).topic().equals(topic$2)) return false;
        Object object = r._2();
        ReplicaState replicaState = state$1;
        if (object != null) {
            if (!object.equals(replicaState)) return false;
            return true;
        }
        if (replicaState == null) return true;
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$isAnyReplicaInState$1(String topic$3, ReplicaState state$2, Tuple2 r) {
        if (!((PartitionAndReplica)r._1()).topic().equals(topic$3)) return false;
        Object object = r._2();
        ReplicaState replicaState = state$2;
        if (object != null) {
            if (!object.equals(replicaState)) return false;
            return true;
        }
        if (replicaState == null) return true;
        return false;
    }

    public static final /* synthetic */ boolean $anonfun$replicasInDeletionStates$1(String topic$4, Set deletionStates$1, Tuple2 r) {
        return ((PartitionAndReplica)r._1()).topic().equals(topic$4) && deletionStates$1.contains(r._2());
    }

    public static final /* synthetic */ boolean $anonfun$initializeReplicaState$1(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static final /* synthetic */ Option $anonfun$initializeReplicaState$3(ReplicaStateMachine $this, TopicAndPartition topicPartition$1, String topic$5, int partition$1, int replicaId) {
        PartitionAndReplica partitionAndReplica = new PartitionAndReplica(topic$5, partition$1, replicaId);
        return $this.controllerContext().isReplicaOnline(replicaId, topicPartition$1, $this.controllerContext().isReplicaOnline$default$3()) ? $this.replicaState().put((Object)partitionAndReplica, (Object)OnlineReplica$.MODULE$) : $this.replicaState().put((Object)partitionAndReplica, (Object)ReplicaDeletionIneligible$.MODULE$);
    }

    public static final /* synthetic */ void $anonfun$initializeReplicaState$2(ReplicaStateMachine $this, Tuple2 x$4) {
        Tuple2 tuple2 = x$4;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        TopicAndPartition topicPartition = (TopicAndPartition)tuple2._1();
        Seq assignedReplicas = (Seq)tuple2._2();
        String topic = topicPartition.topic();
        int partition = topicPartition.partition();
        assignedReplicas.foreach((Function1 & Serializable & scala.Serializable)replicaId -> ReplicaStateMachine.$anonfun$initializeReplicaState$3($this, topicPartition, topic, partition, BoxesRunTime.unboxToInt((Object)replicaId)));
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ boolean $anonfun$partitionsAssignedToBroker$1(int brokerId$1, Tuple2 x$5) {
        return ((SeqLike)x$5._2()).contains((Object)BoxesRunTime.boxToInteger((int)brokerId$1));
    }

    public ReplicaStateMachine(KafkaController controller, StateChangeLogger stateChangeLogger) {
        this.controller = controller;
        this.stateChangeLogger = stateChangeLogger;
        Logging.$init$(this);
        this.controllerContext = controller.controllerContext();
        this.controllerId = controller.config().brokerId();
        this.zkUtils = this.controllerContext().zkUtils();
        this.replicaState = Map$.MODULE$.empty();
        this.brokerRequestBatch = new ControllerBrokerRequestBatch(controller, stateChangeLogger);
        this.logIdent_$eq(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"[ReplicaStateMachine controllerId=", "] "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.controllerId())})));
    }
}

