/*
 * Decompiled with CFR 0.152.
 */
package kafka.controller;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import kafka.controller.AsyncRequest;
import kafka.controller.AsyncResponse;
import kafka.controller.CreateRequest;
import kafka.controller.CreateResponse;
import kafka.controller.DeleteRequest;
import kafka.controller.DeleteResponse;
import kafka.controller.ExistsRequest;
import kafka.controller.ExistsResponse;
import kafka.controller.GetACLRequest;
import kafka.controller.GetACLResponse;
import kafka.controller.GetChildrenRequest;
import kafka.controller.GetChildrenResponse;
import kafka.controller.GetDataRequest;
import kafka.controller.GetDataResponse;
import kafka.controller.SetACLRequest;
import kafka.controller.SetACLResponse;
import kafka.controller.SetDataRequest;
import kafka.controller.SetDataResponse;
import kafka.controller.StateChangeHandler;
import kafka.controller.ZNodeChangeHandler;
import kafka.controller.ZNodeChildChangeHandler;
import kafka.controller.ZookeeperClient$ZookeeperClientWatcher$;
import kafka.controller.ZookeeperClientAuthFailedException;
import kafka.controller.ZookeeperClientExpiredException;
import kafka.controller.ZookeeperClientTimeoutException;
import kafka.utils.CoreUtils$;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import org.apache.log4j.Logger;
import org.apache.zookeeper.AsyncCallback;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.data.ACL;
import org.apache.zookeeper.data.Stat;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option$;
import scala.Predef$;
import scala.StringContext;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.mutable.Buffer;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.LambdaDeserialize;
import scala.runtime.LongRef;
import scala.runtime.java8.JFunction0;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001\u0005\u001dh\u0001B\u0001\u0003\u0001\u001d\u0011qBW8pW\u0016,\u0007/\u001a:DY&,g\u000e\u001e\u0006\u0003\u0007\u0011\t!bY8oiJ|G\u000e\\3s\u0015\u0005)\u0011!B6bM.\f7\u0001A\n\u0004\u0001!q\u0001CA\u0005\r\u001b\u0005Q!\"A\u0006\u0002\u000bM\u001c\u0017\r\\1\n\u00055Q!AB!osJ+g\r\u0005\u0002\u0010%5\t\u0001C\u0003\u0002\u0012\t\u0005)Q\u000f^5mg&\u00111\u0003\u0005\u0002\b\u0019><w-\u001b8h\u0011!)\u0002A!A!\u0002\u00131\u0012!D2p]:,7\r^*ue&tw\r\u0005\u0002\u0018=9\u0011\u0001\u0004\b\t\u00033)i\u0011A\u0007\u0006\u00037\u0019\ta\u0001\u0010:p_Rt\u0014BA\u000f\u000b\u0003\u0019\u0001&/\u001a3fM&\u0011q\u0004\t\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005uQ\u0001\u0002\u0003\u0012\u0001\u0005\u0003\u0005\u000b\u0011B\u0012\u0002!M,7o]5p]RKW.Z8vi6\u001b\bCA\u0005%\u0013\t)#BA\u0002J]RD\u0001b\n\u0001\u0003\u0002\u0003\u0006IaI\u0001\u0014G>tg.Z2uS>tG+[7f_V$Xj\u001d\u0005\tS\u0001\u0011\t\u0011)A\u0005U\u0005\u00112\u000f^1uK\u000eC\u0017M\\4f\u0011\u0006tG\r\\3s!\tYC&D\u0001\u0003\u0013\ti#A\u0001\nTi\u0006$Xm\u00115b]\u001e,\u0007*\u00198eY\u0016\u0014\b\"B\u0018\u0001\t\u0003\u0001\u0014A\u0002\u001fj]&$h\bF\u00032eM\"T\u0007\u0005\u0002,\u0001!)QC\fa\u0001-!)!E\fa\u0001G!)qE\fa\u0001G!)\u0011F\fa\u0001U!9q\u0007\u0001b\u0001\n\u0013A\u0014AE5oSRL\u0017\r\\5{CRLwN\u001c'pG.,\u0012!\u000f\t\u0003u\rk\u0011a\u000f\u0006\u0003yu\nQ\u0001\\8dWNT!AP \u0002\u0015\r|gnY;se\u0016tGO\u0003\u0002A\u0003\u0006!Q\u000f^5m\u0015\u0005\u0011\u0015\u0001\u00026bm\u0006L!\u0001R\u001e\u0003-I+WM\u001c;sC:$(+Z1e/JLG/\u001a'pG.DaA\u0012\u0001!\u0002\u0013I\u0014aE5oSRL\u0017\r\\5{CRLwN\u001c'pG.\u0004\u0003b\u0002%\u0001\u0005\u0004%I!S\u0001\u0019SN\u001cuN\u001c8fGR,Gm\u0014:FqBL'/\u001a3M_\u000e\\W#\u0001&\u0011\u0005iZ\u0015B\u0001'<\u00055\u0011V-\u001a8ue\u0006tG\u000fT8dW\"1a\n\u0001Q\u0001\n)\u000b\u0011$[:D_:tWm\u0019;fI>\u0013X\t\u001f9je\u0016$Gj\\2lA!9\u0001\u000b\u0001b\u0001\n\u0013\t\u0016!H5t\u0007>tg.Z2uK\u0012|%/\u0012=qSJ,GmQ8oI&$\u0018n\u001c8\u0016\u0003I\u0003\"AO*\n\u0005Q[$!C\"p]\u0012LG/[8o\u0011\u00191\u0006\u0001)A\u0005%\u0006q\u0012n]\"p]:,7\r^3e\u001fJ,\u0005\u0010]5sK\u0012\u001cuN\u001c3ji&|g\u000e\t\u0005\b1\u0002\u0011\r\u0011\"\u0003Z\u0003MQhj\u001c3f\u0007\"\fgnZ3IC:$G.\u001a:t+\u0005Q\u0006\u0003B.]-yk\u0011!P\u0005\u0003;v\u0012\u0011cQ8oGV\u0014(/\u001a8u\u0011\u0006\u001c\b.T1q!\tYs,\u0003\u0002a\u0005\t\u0011\"LT8eK\u000eC\u0017M\\4f\u0011\u0006tG\r\\3s\u0011\u0019\u0011\u0007\u0001)A\u00055\u0006!\"PT8eK\u000eC\u0017M\\4f\u0011\u0006tG\r\\3sg\u0002Bq\u0001\u001a\u0001C\u0002\u0013%Q-\u0001\r{\u001d>$Wm\u00115jY\u0012\u001c\u0005.\u00198hK\"\u000bg\u000e\u001a7feN,\u0012A\u001a\t\u00057r3r\r\u0005\u0002,Q&\u0011\u0011N\u0001\u0002\u00185:{G-Z\"iS2$7\t[1oO\u0016D\u0015M\u001c3mKJDaa\u001b\u0001!\u0002\u00131\u0017!\u0007>O_\u0012,7\t[5mI\u000eC\u0017M\\4f\u0011\u0006tG\r\\3sg\u0002Bq!\u001c\u0001A\u0002\u0013%a.A\u0005{_>\\U-\u001a9feV\tq\u000e\u0005\u0002qo6\t\u0011O\u0003\u0002sg\u0006I!p\\8lK\u0016\u0004XM\u001d\u0006\u0003iV\fa!\u00199bG\",'\"\u0001<\u0002\u0007=\u0014x-\u0003\u0002yc\nI!l\\8LK\u0016\u0004XM\u001d\u0005\bu\u0002\u0001\r\u0011\"\u0003|\u00035Qxn\\&fKB,'o\u0018\u0013fcR\u0011Ap \t\u0003\u0013uL!A \u0006\u0003\tUs\u0017\u000e\u001e\u0005\t\u0003\u0003I\u0018\u0011!a\u0001_\u0006\u0019\u0001\u0010J\u0019\t\u000f\u0005\u0015\u0001\u0001)Q\u0005_\u0006Q!p\\8LK\u0016\u0004XM\u001d\u0011)\t\u0005\r\u0011\u0011\u0002\t\u0004\u0013\u0005-\u0011bAA\u0007\u0015\tAao\u001c7bi&dW\rC\u0004\u0002\u0012\u0001!\t!a\u0005\u0002\r!\fg\u000e\u001a7f)\u0011\t)\"a\u0007\u0011\u0007-\n9\"C\u0002\u0002\u001a\t\u0011Q\"Q:z]\u000e\u0014Vm\u001d9p]N,\u0007\u0002CA\u000f\u0003\u001f\u0001\r!a\b\u0002\u000fI,\u0017/^3tiB\u00191&!\t\n\u0007\u0005\r\"A\u0001\u0007Bgft7MU3rk\u0016\u001cH\u000fC\u0004\u0002\u0012\u0001!\t!a\n\u0015\t\u0005%\u00121\b\t\u0007\u0003W\t)$!\u0006\u000f\t\u00055\u0012\u0011\u0007\b\u00043\u0005=\u0012\"A\u0006\n\u0007\u0005M\"\"A\u0004qC\u000e\\\u0017mZ3\n\t\u0005]\u0012\u0011\b\u0002\u0004'\u0016\f(bAA\u001a\u0015!A\u0011QHA\u0013\u0001\u0004\ty$\u0001\u0005sKF,Xm\u001d;t!\u0019\tY#!\u000e\u0002 !9\u00111\t\u0001\u0005\u0002\u0005\u0015\u0013AE<bSR,f\u000e^5m\u0007>tg.Z2uK\u0012$\u0012\u0001 \u0005\b\u0003\u0007\u0002A\u0011BA%)\u0015a\u00181JA+\u0011!\ti%a\u0012A\u0002\u0005=\u0013a\u0002;j[\u0016|W\u000f\u001e\t\u0004\u0013\u0005E\u0013bAA*\u0015\t!Aj\u001c8h\u0011!\t9&a\u0012A\u0002\u0005e\u0013\u0001\u0003;j[\u0016,f.\u001b;\u0011\u0007m\u000bY&C\u0002\u0002^u\u0012\u0001\u0002V5nKVs\u0017\u000e\u001e\u0005\b\u0003C\u0002A\u0011AA2\u0003i\u0011XmZ5ti\u0016\u0014(LT8eK\u000eC\u0017M\\4f\u0011\u0006tG\r\\3s)\u0011\t)'a\u001b\u0011\u0007-\n9'C\u0002\u0002j\t\u0011a\"\u0012=jgR\u001c(+Z:q_:\u001cX\rC\u0004\u0002n\u0005}\u0003\u0019\u00010\u0002%itu\u000eZ3DQ\u0006tw-\u001a%b]\u0012dWM\u001d\u0005\b\u0003c\u0002A\u0011AA:\u0003m\u0011XmZ5ti\u0016\u0014(LT8eK\u000eC\u0017M\\4f\u0011\u0006tG\r\\3sgR!\u0011QOA<!\u0019\tY#!\u000e\u0002f!A\u0011\u0011PA8\u0001\u0004\tY(\u0001\u0005iC:$G.\u001a:t!\u0015\tY#!\u000e_\u0011\u001d\ty\b\u0001C\u0001\u0003\u0003\u000bA$\u001e8sK\u001eL7\u000f^3s5:{G-Z\"iC:<W\rS1oI2,'\u000fF\u0002}\u0003\u0007Cq!!\"\u0002~\u0001\u0007a#\u0001\u0003qCRD\u0007bBAE\u0001\u0011\u0005\u00111R\u0001 e\u0016<\u0017n\u001d;fejsu\u000eZ3DQ&dGm\u00115b]\u001e,\u0007*\u00198eY\u0016\u0014H\u0003BAG\u0003'\u00032aKAH\u0013\r\t\tJ\u0001\u0002\u0014\u000f\u0016$8\t[5mIJ,gNU3ta>t7/\u001a\u0005\b\u0003+\u000b9\t1\u0001h\u0003]Qhj\u001c3f\u0007\"LG\u000eZ\"iC:<W\rS1oI2,'\u000fC\u0004\u0002\u001a\u0002!\t!a'\u0002AI,w-[:uKJTfj\u001c3f\u0007\"LG\u000eZ\"iC:<W\rS1oI2,'o\u001d\u000b\u0005\u0003;\u000by\n\u0005\u0004\u0002,\u0005U\u0012Q\u0012\u0005\t\u0003s\n9\n1\u0001\u0002\"B)\u00111FA\u001bO\"9\u0011Q\u0015\u0001\u0005\u0002\u0005\u001d\u0016!I;oe\u0016<\u0017n\u001d;fejsu\u000eZ3DQ&dGm\u00115b]\u001e,\u0007*\u00198eY\u0016\u0014Hc\u0001?\u0002*\"9\u0011QQAR\u0001\u00041\u0002bBAW\u0001\u0011\u0005\u0011QI\u0001\u0006G2|7/\u001a\u0005\b\u0003c\u0003A\u0011BA#\u0003)Ig.\u001b;jC2L'0Z\u0004\b\u0003k\u0003\u0001\u0012BA\\\u0003YQvn\\6fKB,'o\u00117jK:$x+\u0019;dQ\u0016\u0014\b\u0003BA]\u0003wk\u0011\u0001\u0001\u0004\b\u0003{\u0003\u0001\u0012BA`\u0005YQvn\\6fKB,'o\u00117jK:$x+\u0019;dQ\u0016\u00148CBA^\u0003\u0003\fi\r\u0005\u0003\u0002D\u0006%WBAAc\u0015\r\t9-Q\u0001\u0005Y\u0006tw-\u0003\u0003\u0002L\u0006\u0015'AB(cU\u0016\u001cG\u000fE\u0002q\u0003\u001fL1!!5r\u0005\u001d9\u0016\r^2iKJDqaLA^\t\u0003\t)\u000e\u0006\u0002\u00028\"A\u0011\u0011\\A^\t\u0003\nY.A\u0004qe>\u001cWm]:\u0015\u0007q\fi\u000e\u0003\u0005\u0002`\u0006]\u0007\u0019AAq\u0003\u0015)g/\u001a8u!\r\u0001\u00181]\u0005\u0004\u0003K\f(\u0001D,bi\u000eDW\rZ#wK:$\b")
public class ZookeeperClient
implements Logging {
    private volatile ZookeeperClient$ZookeeperClientWatcher$ ZookeeperClientWatcher$module;
    private final String connectString;
    private final int sessionTimeoutMs;
    private final int connectionTimeoutMs;
    public final StateChangeHandler kafka$controller$ZookeeperClient$$stateChangeHandler;
    private final ReentrantReadWriteLock kafka$controller$ZookeeperClient$$initializationLock;
    private final ReentrantLock kafka$controller$ZookeeperClient$$isConnectedOrExpiredLock;
    private final Condition kafka$controller$ZookeeperClient$$isConnectedOrExpiredCondition;
    private final ConcurrentHashMap<String, ZNodeChangeHandler> kafka$controller$ZookeeperClient$$zNodeChangeHandlers;
    private final ConcurrentHashMap<String, ZNodeChildChangeHandler> kafka$controller$ZookeeperClient$$zNodeChildChangeHandlers;
    private volatile ZooKeeper zooKeeper;
    private final String loggerName;
    private Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    private volatile boolean bitmap$0;

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public Object trace(Function0<Throwable> e) {
        return Logging.trace$(this, e);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public void swallowTrace(Function0<BoxedUnit> action) {
        Logging.swallowTrace$(this, action);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public Object debug(Function0<Throwable> e) {
        return Logging.debug$(this, e);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void swallowDebug(Function0<BoxedUnit> action) {
        Logging.swallowDebug$(this, action);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public Object info(Function0<Throwable> e) {
        return Logging.info$(this, e);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void swallowInfo(Function0<BoxedUnit> action) {
        Logging.swallowInfo$(this, action);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public Object warn(Function0<Throwable> e) {
        return Logging.warn$(this, e);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void swallowWarn(Function0<BoxedUnit> action) {
        Logging.swallowWarn$(this, action);
    }

    @Override
    public void swallow(Function0<BoxedUnit> action) {
        Logging.swallow$(this, action);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public Object error(Function0<Throwable> e) {
        return Logging.error$(this, e);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void swallowError(Function0<BoxedUnit> action) {
        Logging.swallowError$(this, action);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public Object fatal(Function0<Throwable> e) {
        return Logging.fatal$(this, e);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private ZookeeperClient$ZookeeperClientWatcher$ ZookeeperClientWatcher() {
        if (this.ZookeeperClientWatcher$module == null) {
            this.ZookeeperClientWatcher$lzycompute$1();
        }
        return this.ZookeeperClientWatcher$module;
    }

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    private Logger logger$lzycompute() {
        ZookeeperClient zookeeperClient = this;
        synchronized (zookeeperClient) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String x$1) {
        this.loggerName = x$1;
    }

    @Override
    public final void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ x$1) {
        this.kafka$utils$Logging$$log4jController = x$1;
    }

    public ReentrantReadWriteLock kafka$controller$ZookeeperClient$$initializationLock() {
        return this.kafka$controller$ZookeeperClient$$initializationLock;
    }

    public ReentrantLock kafka$controller$ZookeeperClient$$isConnectedOrExpiredLock() {
        return this.kafka$controller$ZookeeperClient$$isConnectedOrExpiredLock;
    }

    public Condition kafka$controller$ZookeeperClient$$isConnectedOrExpiredCondition() {
        return this.kafka$controller$ZookeeperClient$$isConnectedOrExpiredCondition;
    }

    public ConcurrentHashMap<String, ZNodeChangeHandler> kafka$controller$ZookeeperClient$$zNodeChangeHandlers() {
        return this.kafka$controller$ZookeeperClient$$zNodeChangeHandlers;
    }

    public ConcurrentHashMap<String, ZNodeChildChangeHandler> kafka$controller$ZookeeperClient$$zNodeChildChangeHandlers() {
        return this.kafka$controller$ZookeeperClient$$zNodeChildChangeHandlers;
    }

    private ZooKeeper zooKeeper() {
        return this.zooKeeper;
    }

    private void zooKeeper_$eq(ZooKeeper x$1) {
        this.zooKeeper = x$1;
    }

    public AsyncResponse handle(AsyncRequest request) {
        return (AsyncResponse)this.handle((Seq<AsyncRequest>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AsyncRequest[]{request})))).head();
    }

    public Seq<AsyncResponse> handle(Seq<AsyncRequest> requests) {
        return (Seq)CoreUtils$.MODULE$.inReadLock(this.kafka$controller$ZookeeperClient$$initializationLock(), (Function0 & Serializable & scala.Serializable)() -> {
            CountDownLatch countDownLatch = new CountDownLatch(requests.size());
            ArrayBlockingQueue responseQueue = new ArrayBlockingQueue(requests.size());
            requests.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                ZookeeperClient.$anonfun$handle$2(this, countDownLatch, responseQueue, x0$1);
                return BoxedUnit.UNIT;
            });
            countDownLatch.await();
            return ((TraversableOnce)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(responseQueue).asScala()).toSeq();
        });
    }

    public void waitUntilConnected() {
        CoreUtils$.MODULE$.inLock(this.kafka$controller$ZookeeperClient$$isConnectedOrExpiredLock(), (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.waitUntilConnected(Long.MAX_VALUE, TimeUnit.MILLISECONDS));
    }

    private void waitUntilConnected(long timeout, TimeUnit timeUnit) {
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Waiting until connected.");
        LongRef nanos = LongRef.create((long)timeUnit.toNanos(timeout));
        CoreUtils$.MODULE$.inLock(this.kafka$controller$ZookeeperClient$$isConnectedOrExpiredLock(), (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            ZooKeeper.States state = this.zooKeeper().getState();
            while (!state.isConnected() && state.isAlive()) {
                if (nanos$1.elem <= 0L) {
                    throw new ZookeeperClientTimeoutException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Timed out waiting for connection while in state: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{state})));
                }
                nanos$1.elem = this.kafka$controller$ZookeeperClient$$isConnectedOrExpiredCondition().awaitNanos(nanos$1.elem);
                state = this.zooKeeper().getState();
            }
            ZooKeeper.States states = state;
            ZooKeeper.States states2 = ZooKeeper.States.AUTH_FAILED;
            if (!(states != null ? !states.equals(states2) : states2 != null)) {
                throw new ZookeeperClientAuthFailedException("Auth failed either before or while waiting for connection");
            }
            ZooKeeper.States states3 = state;
            ZooKeeper.States states4 = ZooKeeper.States.CLOSED;
            if (!(states3 != null ? !states3.equals(states4) : states4 != null)) {
                throw new ZookeeperClientExpiredException("Session expired either before or while waiting for connection");
            }
        });
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Connected.");
    }

    public ExistsResponse registerZNodeChangeHandler(ZNodeChangeHandler zNodeChangeHandler) {
        return (ExistsResponse)this.registerZNodeChangeHandlers((Seq<ZNodeChangeHandler>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ZNodeChangeHandler[]{zNodeChangeHandler})))).head();
    }

    public Seq<ExistsResponse> registerZNodeChangeHandlers(Seq<ZNodeChangeHandler> handlers) {
        handlers.foreach((Function1 & Serializable & scala.Serializable)handler -> this.kafka$controller$ZookeeperClient$$zNodeChangeHandlers().put(handler.path(), (ZNodeChangeHandler)handler));
        Seq asyncRequests = (Seq)handlers.map((Function1 & Serializable & scala.Serializable)handler -> new ExistsRequest(handler.path(), null), Seq$.MODULE$.canBuildFrom());
        return this.handle((Seq<AsyncRequest>)asyncRequests);
    }

    public void unregisterZNodeChangeHandler(String path) {
        this.kafka$controller$ZookeeperClient$$zNodeChangeHandlers().remove(path);
    }

    public GetChildrenResponse registerZNodeChildChangeHandler(ZNodeChildChangeHandler zNodeChildChangeHandler) {
        return (GetChildrenResponse)this.registerZNodeChildChangeHandlers((Seq<ZNodeChildChangeHandler>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ZNodeChildChangeHandler[]{zNodeChildChangeHandler})))).head();
    }

    public Seq<GetChildrenResponse> registerZNodeChildChangeHandlers(Seq<ZNodeChildChangeHandler> handlers) {
        handlers.foreach((Function1 & Serializable & scala.Serializable)handler -> this.kafka$controller$ZookeeperClient$$zNodeChildChangeHandlers().put(handler.path(), (ZNodeChildChangeHandler)handler));
        Seq asyncRequests = (Seq)handlers.map((Function1 & Serializable & scala.Serializable)handler -> new GetChildrenRequest(handler.path(), null), Seq$.MODULE$.canBuildFrom());
        return this.handle((Seq<AsyncRequest>)asyncRequests);
    }

    public void unregisterZNodeChildChangeHandler(String path) {
        this.kafka$controller$ZookeeperClient$$zNodeChildChangeHandlers().remove(path);
    }

    public void close() {
        CoreUtils$.MODULE$.inWriteLock(this.kafka$controller$ZookeeperClient$$initializationLock(), (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Closing.");
            this.kafka$controller$ZookeeperClient$$zNodeChangeHandlers().clear();
            this.kafka$controller$ZookeeperClient$$zNodeChildChangeHandlers().clear();
            this.zooKeeper().close();
            this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Closed.");
        });
    }

    public void kafka$controller$ZookeeperClient$$initialize() {
        block3: {
            if (this.zooKeeper().getState().isAlive()) break block3;
            this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Initializing a new session to ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{$this.connectString})));
            long now = System.currentTimeMillis();
            long threshold = now + (long)this.connectionTimeoutMs;
            while (now < threshold) {
                try {
                    this.zooKeeper().close();
                    this.zooKeeper_$eq(new ZooKeeper(this.connectString, this.sessionTimeoutMs, (Watcher)this.ZookeeperClientWatcher()));
                    this.waitUntilConnected(threshold - now, TimeUnit.MILLISECONDS);
                    return;
                }
                catch (Exception exception) {
                    now = System.currentTimeMillis();
                    if (now >= threshold) continue;
                    Thread.sleep(1000L);
                    now = System.currentTimeMillis();
                }
            }
            this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Timed out waiting for connection during session initialization while in state: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.zooKeeper().getState()})));
            this.kafka$controller$ZookeeperClient$$stateChangeHandler.onConnectionTimeout();
        }
    }

    private final void ZookeeperClientWatcher$lzycompute$1() {
        ZookeeperClient zookeeperClient = this;
        synchronized (zookeeperClient) {
            if (this.ZookeeperClientWatcher$module == null) {
                this.ZookeeperClientWatcher$module = new ZookeeperClient$ZookeeperClientWatcher$(this);
            }
        }
    }

    public static final /* synthetic */ void $anonfun$handle$2(ZookeeperClient $this, CountDownLatch countDownLatch$1, ArrayBlockingQueue responseQueue$1, AsyncRequest x0$1) {
        AsyncRequest asyncRequest = x0$1;
        if (asyncRequest instanceof CreateRequest) {
            CreateRequest createRequest = (CreateRequest)asyncRequest;
            String path = createRequest.path();
            byte[] data = createRequest.data();
            Seq<ACL> acl = createRequest.acl();
            CreateMode createMode = createRequest.createMode();
            Object ctx = createRequest.ctx();
            $this.zooKeeper().create(path, data, (List)JavaConverters$.MODULE$.seqAsJavaListConverter(acl).asJava(), createMode, new AsyncCallback.StringCallback(null, countDownLatch$1, responseQueue$1){
                private final CountDownLatch countDownLatch$1;
                private final ArrayBlockingQueue responseQueue$1;

                public void processResult(int rc, String path, Object ctx, String name) {
                    this.responseQueue$1.add(new CreateResponse(rc, path, ctx, name));
                    this.countDownLatch$1.countDown();
                }
                {
                    this.countDownLatch$1 = countDownLatch$1;
                    this.responseQueue$1 = responseQueue$1;
                }
            }, ctx);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (asyncRequest instanceof DeleteRequest) {
            DeleteRequest deleteRequest = (DeleteRequest)asyncRequest;
            String path = deleteRequest.path();
            int version = deleteRequest.version();
            Object ctx = deleteRequest.ctx();
            $this.zooKeeper().delete(path, version, new AsyncCallback.VoidCallback(null, countDownLatch$1, responseQueue$1){
                private final CountDownLatch countDownLatch$1;
                private final ArrayBlockingQueue responseQueue$1;

                public void processResult(int rc, String path, Object ctx) {
                    this.responseQueue$1.add(new DeleteResponse(rc, path, ctx));
                    this.countDownLatch$1.countDown();
                }
                {
                    this.countDownLatch$1 = countDownLatch$1;
                    this.responseQueue$1 = responseQueue$1;
                }
            }, ctx);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (asyncRequest instanceof ExistsRequest) {
            ExistsRequest existsRequest = (ExistsRequest)asyncRequest;
            String path = existsRequest.path();
            Object ctx = existsRequest.ctx();
            $this.zooKeeper().exists(path, $this.kafka$controller$ZookeeperClient$$zNodeChangeHandlers().containsKey(path), new AsyncCallback.StatCallback(null, countDownLatch$1, responseQueue$1){
                private final CountDownLatch countDownLatch$1;
                private final ArrayBlockingQueue responseQueue$1;

                public void processResult(int rc, String path, Object ctx, Stat stat) {
                    this.responseQueue$1.add(new ExistsResponse(rc, path, ctx, stat));
                    this.countDownLatch$1.countDown();
                }
                {
                    this.countDownLatch$1 = countDownLatch$1;
                    this.responseQueue$1 = responseQueue$1;
                }
            }, ctx);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (asyncRequest instanceof GetDataRequest) {
            GetDataRequest getDataRequest = (GetDataRequest)asyncRequest;
            String path = getDataRequest.path();
            Object ctx = getDataRequest.ctx();
            $this.zooKeeper().getData(path, $this.kafka$controller$ZookeeperClient$$zNodeChangeHandlers().containsKey(path), new AsyncCallback.DataCallback(null, countDownLatch$1, responseQueue$1){
                private final CountDownLatch countDownLatch$1;
                private final ArrayBlockingQueue responseQueue$1;

                public void processResult(int rc, String path, Object ctx, byte[] data, Stat stat) {
                    this.responseQueue$1.add(new GetDataResponse(rc, path, ctx, data, stat));
                    this.countDownLatch$1.countDown();
                }
                {
                    this.countDownLatch$1 = countDownLatch$1;
                    this.responseQueue$1 = responseQueue$1;
                }
            }, ctx);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (asyncRequest instanceof SetDataRequest) {
            SetDataRequest setDataRequest = (SetDataRequest)asyncRequest;
            String path = setDataRequest.path();
            byte[] data = setDataRequest.data();
            int version = setDataRequest.version();
            Object ctx = setDataRequest.ctx();
            $this.zooKeeper().setData(path, data, version, new AsyncCallback.StatCallback(null, countDownLatch$1, responseQueue$1){
                private final CountDownLatch countDownLatch$1;
                private final ArrayBlockingQueue responseQueue$1;

                public void processResult(int rc, String path, Object ctx, Stat stat) {
                    this.responseQueue$1.add(new SetDataResponse(rc, path, ctx, stat));
                    this.countDownLatch$1.countDown();
                }
                {
                    this.countDownLatch$1 = countDownLatch$1;
                    this.responseQueue$1 = responseQueue$1;
                }
            }, ctx);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (asyncRequest instanceof GetACLRequest) {
            GetACLRequest getACLRequest = (GetACLRequest)asyncRequest;
            String path = getACLRequest.path();
            Object ctx = getACLRequest.ctx();
            $this.zooKeeper().getACL(path, null, new AsyncCallback.ACLCallback(null, countDownLatch$1, responseQueue$1){
                private final CountDownLatch countDownLatch$1;
                private final ArrayBlockingQueue responseQueue$1;

                public void processResult(int rc, String path, Object ctx, List<ACL> acl, Stat stat) {
                    this.responseQueue$1.add(new GetACLResponse(rc, path, ctx, (Seq<ACL>)((Seq)Option$.MODULE$.apply(acl).map((Function1 & Serializable & scala.Serializable)x$1 -> (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(x$1).asScala()).orNull(Predef$.MODULE$.$conforms())), stat));
                    this.countDownLatch$1.countDown();
                }
                {
                    this.countDownLatch$1 = countDownLatch$1;
                    this.responseQueue$1 = responseQueue$1;
                }

                private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                    return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$processResult$1(java.util.List )}, serializedLambda);
                }
            }, ctx);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (asyncRequest instanceof SetACLRequest) {
            SetACLRequest setACLRequest = (SetACLRequest)asyncRequest;
            String path = setACLRequest.path();
            Seq<ACL> acl = setACLRequest.acl();
            int version = setACLRequest.version();
            Object ctx = setACLRequest.ctx();
            $this.zooKeeper().setACL(path, (List)JavaConverters$.MODULE$.seqAsJavaListConverter(acl).asJava(), version, new AsyncCallback.StatCallback(null, countDownLatch$1, responseQueue$1){
                private final CountDownLatch countDownLatch$1;
                private final ArrayBlockingQueue responseQueue$1;

                public void processResult(int rc, String path, Object ctx, Stat stat) {
                    this.responseQueue$1.add(new SetACLResponse(rc, path, ctx, stat));
                    this.countDownLatch$1.countDown();
                }
                {
                    this.countDownLatch$1 = countDownLatch$1;
                    this.responseQueue$1 = responseQueue$1;
                }
            }, ctx);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (asyncRequest instanceof GetChildrenRequest) {
            GetChildrenRequest getChildrenRequest = (GetChildrenRequest)asyncRequest;
            String path = getChildrenRequest.path();
            Object ctx = getChildrenRequest.ctx();
            $this.zooKeeper().getChildren(path, $this.kafka$controller$ZookeeperClient$$zNodeChildChangeHandlers().containsKey(path), new AsyncCallback.Children2Callback(null, countDownLatch$1, responseQueue$1){
                private final CountDownLatch countDownLatch$1;
                private final ArrayBlockingQueue responseQueue$1;

                public void processResult(int rc, String path, Object ctx, List<String> children, Stat stat) {
                    this.responseQueue$1.add(new GetChildrenResponse(rc, path, ctx, (Seq<String>)((Seq)Option$.MODULE$.apply(children).map((Function1 & Serializable & scala.Serializable)x$2 -> (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(x$2).asScala()).orNull(Predef$.MODULE$.$conforms())), stat));
                    this.countDownLatch$1.countDown();
                }
                {
                    this.countDownLatch$1 = countDownLatch$1;
                    this.responseQueue$1 = responseQueue$1;
                }

                private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                    return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$processResult$2(java.util.List )}, serializedLambda);
                }
            }, ctx);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)asyncRequest);
        }
    }

    public ZookeeperClient(String connectString, int sessionTimeoutMs, int connectionTimeoutMs, StateChangeHandler stateChangeHandler) {
        this.connectString = connectString;
        this.sessionTimeoutMs = sessionTimeoutMs;
        this.connectionTimeoutMs = connectionTimeoutMs;
        this.kafka$controller$ZookeeperClient$$stateChangeHandler = stateChangeHandler;
        Logging.$init$(this);
        this.logIdent_$eq("[ZookeeperClient]: ");
        this.kafka$controller$ZookeeperClient$$initializationLock = new ReentrantReadWriteLock();
        this.kafka$controller$ZookeeperClient$$isConnectedOrExpiredLock = new ReentrantLock();
        this.kafka$controller$ZookeeperClient$$isConnectedOrExpiredCondition = this.kafka$controller$ZookeeperClient$$isConnectedOrExpiredLock().newCondition();
        this.kafka$controller$ZookeeperClient$$zNodeChangeHandlers = new ConcurrentHashMap();
        this.kafka$controller$ZookeeperClient$$zNodeChildChangeHandlers = new ConcurrentHashMap();
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Initializing a new session to ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{$this.connectString})));
        this.zooKeeper = new ZooKeeper(connectString, sessionTimeoutMs, (Watcher)this.ZookeeperClientWatcher());
        this.waitUntilConnected(connectionTimeoutMs, TimeUnit.MILLISECONDS);
    }
}

