/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.config.zookeeper;

import io.vertx.config.spi.ConfigStore;
import io.vertx.core.AsyncResult;
import io.vertx.core.Context;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.JsonObject;
import java.util.Objects;
import org.apache.curator.RetryPolicy;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.framework.api.CuratorEvent;
import org.apache.curator.framework.api.ErrorListenerPathable;
import org.apache.curator.retry.ExponentialBackoffRetry;
import org.apache.zookeeper.KeeperException;

public class ZookeeperConfigStore
implements ConfigStore {
    private final CuratorFramework client;
    private final String path;
    private final Vertx vertx;

    public ZookeeperConfigStore(Vertx vertx, JsonObject configuration) {
        String connection = Objects.requireNonNull(configuration.getString("connection"));
        this.path = Objects.requireNonNull(configuration.getString("path"));
        this.vertx = Objects.requireNonNull(vertx);
        int maxRetries = configuration.getInteger("maxRetries", Integer.valueOf(3));
        int baseGraceBetweenRetries = configuration.getInteger("baseSleepTimeBetweenRetries", Integer.valueOf(1000));
        this.client = CuratorFrameworkFactory.newClient((String)connection, (RetryPolicy)new ExponentialBackoffRetry(baseGraceBetweenRetries, maxRetries));
        this.client.start();
    }

    public void get(Handler<AsyncResult<Buffer>> completionHandler) {
        Context context = Vertx.currentContext();
        this.vertx.executeBlocking(future -> {
            try {
                this.client.blockUntilConnected();
                future.complete();
            }
            catch (InterruptedException e) {
                future.fail((Throwable)e);
            }
        }, v -> {
            if (v.failed()) {
                completionHandler.handle((Object)Future.failedFuture((Throwable)v.cause()));
            } else {
                try {
                    ((ErrorListenerPathable)this.client.getData().inBackground((client, event) -> {
                        if (context != null) {
                            context.runOnContext(x -> this.retrieve(event, completionHandler));
                        } else {
                            this.retrieve(event, completionHandler);
                        }
                    })).withUnhandledErrorListener((message, e) -> {
                        Exception failure = new Exception(message, e);
                        if (context != null) {
                            context.runOnContext(x -> completionHandler.handle((Object)Future.failedFuture((Throwable)failure)));
                        } else {
                            completionHandler.handle((Object)Future.failedFuture((Throwable)failure));
                        }
                    }).forPath(this.path);
                }
                catch (Exception e2) {
                    completionHandler.handle((Object)Future.failedFuture((Throwable)e2));
                }
            }
        });
    }

    private void retrieve(CuratorEvent event, Handler<AsyncResult<Buffer>> completionHandler) {
        KeeperException.Code code = KeeperException.Code.get((int)event.getResultCode());
        if (code == KeeperException.Code.OK) {
            completionHandler.handle((Object)Future.succeededFuture((Object)Buffer.buffer((byte[])event.getData())));
        } else if (code == KeeperException.Code.NONODE) {
            completionHandler.handle((Object)Future.succeededFuture((Object)Buffer.buffer((String)"{}")));
        } else {
            completionHandler.handle((Object)Future.failedFuture((Throwable)KeeperException.create((KeeperException.Code)code, (String)this.path)));
        }
    }

    public void close(Handler<Void> completionHandler) {
        this.client.close();
        completionHandler.handle(null);
    }
}

