/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.consul;

import io.vertx.core.Vertx;
import io.vertx.core.eventbus.Message;
import io.vertx.core.eventbus.MessageCodec;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.consul.AclToken;
import io.vertx.ext.consul.BlockingQueryOptions;
import io.vertx.ext.consul.CheckList;
import io.vertx.ext.consul.CheckOptions;
import io.vertx.ext.consul.CheckQueryOptions;
import io.vertx.ext.consul.CheckStatus;
import io.vertx.ext.consul.ConsulService;
import io.vertx.ext.consul.CoordinateList;
import io.vertx.ext.consul.Event;
import io.vertx.ext.consul.EventList;
import io.vertx.ext.consul.EventListOptions;
import io.vertx.ext.consul.EventOptions;
import io.vertx.ext.consul.HealthState;
import io.vertx.ext.consul.KeyValue;
import io.vertx.ext.consul.KeyValueList;
import io.vertx.ext.consul.KeyValueOptions;
import io.vertx.ext.consul.MaintenanceOptions;
import io.vertx.ext.consul.NodeList;
import io.vertx.ext.consul.NodeQueryOptions;
import io.vertx.ext.consul.PreparedQueryDefinition;
import io.vertx.ext.consul.PreparedQueryExecuteOptions;
import io.vertx.ext.consul.PreparedQueryExecuteResponse;
import io.vertx.ext.consul.ServiceEntryList;
import io.vertx.ext.consul.ServiceList;
import io.vertx.ext.consul.ServiceOptions;
import io.vertx.ext.consul.ServiceQueryOptions;
import io.vertx.ext.consul.Session;
import io.vertx.ext.consul.SessionList;
import io.vertx.ext.consul.SessionOptions;
import io.vertx.ext.consul.TxnRequest;
import io.vertx.ext.consul.TxnResponse;
import io.vertx.serviceproxy.HelperUtils;
import io.vertx.serviceproxy.ProxyHandler;
import io.vertx.serviceproxy.ServiceException;
import io.vertx.serviceproxy.ServiceExceptionMessageCodec;
import java.util.List;
import java.util.stream.Collectors;

public class ConsulServiceVertxProxyHandler
extends ProxyHandler {
    public static final long DEFAULT_CONNECTION_TIMEOUT = 300L;
    private final Vertx vertx;
    private final ConsulService service;
    private final long timerID;
    private long lastAccessed;
    private final long timeoutSeconds;

    public ConsulServiceVertxProxyHandler(Vertx vertx, ConsulService service) {
        this(vertx, service, 300L);
    }

    public ConsulServiceVertxProxyHandler(Vertx vertx, ConsulService service, long timeoutInSecond) {
        this(vertx, service, true, timeoutInSecond);
    }

    public ConsulServiceVertxProxyHandler(Vertx vertx, ConsulService service, boolean topLevel, long timeoutSeconds) {
        this.vertx = vertx;
        this.service = service;
        this.timeoutSeconds = timeoutSeconds;
        try {
            this.vertx.eventBus().registerDefaultCodec(ServiceException.class, (MessageCodec)new ServiceExceptionMessageCodec());
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        if (timeoutSeconds != -1L && !topLevel) {
            long period = timeoutSeconds * 1000L / 2L;
            if (period > 10000L) {
                period = 10000L;
            }
            this.timerID = vertx.setPeriodic(period, this::checkTimedOut);
        } else {
            this.timerID = -1L;
        }
        this.accessed();
    }

    private void checkTimedOut(long id) {
        long now = System.nanoTime();
        if (now - this.lastAccessed > this.timeoutSeconds * 1000000000L) {
            this.close();
        }
    }

    public void close() {
        if (this.timerID != -1L) {
            this.vertx.cancelTimer(this.timerID);
        }
        super.close();
    }

    private void accessed() {
        this.lastAccessed = System.nanoTime();
    }

    public void handle(Message<JsonObject> msg) {
        try {
            JsonObject json = (JsonObject)msg.body();
            String action = msg.headers().get("action");
            if (action == null) {
                throw new IllegalStateException("action not specified");
            }
            this.accessed();
            switch (action) {
                case "agentInfo": {
                    this.service.agentInfo(HelperUtils.createHandler(msg));
                    break;
                }
                case "coordinateNodes": {
                    this.service.coordinateNodes(res -> {
                        if (res.failed()) {
                            if (res.cause() instanceof ServiceException) {
                                msg.reply((Object)res.cause());
                            } else {
                                msg.reply((Object)new ServiceException(-1, res.cause().getMessage()));
                            }
                        } else {
                            msg.reply(res.result() == null ? null : ((CoordinateList)res.result()).toJson());
                        }
                    });
                    break;
                }
                case "coordinateNodesWithOptions": {
                    this.service.coordinateNodesWithOptions(json.getJsonObject("options") == null ? null : new BlockingQueryOptions(json.getJsonObject("options")), res -> {
                        if (res.failed()) {
                            if (res.cause() instanceof ServiceException) {
                                msg.reply((Object)res.cause());
                            } else {
                                msg.reply((Object)new ServiceException(-1, res.cause().getMessage()));
                            }
                        } else {
                            msg.reply(res.result() == null ? null : ((CoordinateList)res.result()).toJson());
                        }
                    });
                    break;
                }
                case "coordinateDatacenters": {
                    this.service.coordinateDatacenters(res -> {
                        if (res.failed()) {
                            if (res.cause() instanceof ServiceException) {
                                msg.reply((Object)res.cause());
                            } else {
                                msg.reply((Object)new ServiceException(-1, res.cause().getMessage()));
                            }
                        } else {
                            msg.reply((Object)new JsonArray(((List)res.result()).stream().map(r -> r == null ? null : r.toJson()).collect(Collectors.toList())));
                        }
                    });
                    break;
                }
                case "getKeys": {
                    this.service.getKeys((String)json.getValue("keyPrefix"), HelperUtils.createListHandler(msg));
                    break;
                }
                case "getKeysWithOptions": {
                    this.service.getKeysWithOptions((String)json.getValue("keyPrefix"), json.getJsonObject("options") == null ? null : new BlockingQueryOptions(json.getJsonObject("options")), HelperUtils.createListHandler(msg));
                    break;
                }
                case "getValue": {
                    this.service.getValue((String)json.getValue("key"), res -> {
                        if (res.failed()) {
                            if (res.cause() instanceof ServiceException) {
                                msg.reply((Object)res.cause());
                            } else {
                                msg.reply((Object)new ServiceException(-1, res.cause().getMessage()));
                            }
                        } else {
                            msg.reply(res.result() == null ? null : ((KeyValue)res.result()).toJson());
                        }
                    });
                    break;
                }
                case "getValueWithOptions": {
                    this.service.getValueWithOptions((String)json.getValue("key"), json.getJsonObject("options") == null ? null : new BlockingQueryOptions(json.getJsonObject("options")), res -> {
                        if (res.failed()) {
                            if (res.cause() instanceof ServiceException) {
                                msg.reply((Object)res.cause());
                            } else {
                                msg.reply((Object)new ServiceException(-1, res.cause().getMessage()));
                            }
                        } else {
                            msg.reply(res.result() == null ? null : ((KeyValue)res.result()).toJson());
                        }
                    });
                    break;
                }
                case "deleteValue": {
                    this.service.deleteValue((String)json.getValue("key"), HelperUtils.createHandler(msg));
                    break;
                }
                case "getValues": {
                    this.service.getValues((String)json.getValue("keyPrefix"), res -> {
                        if (res.failed()) {
                            if (res.cause() instanceof ServiceException) {
                                msg.reply((Object)res.cause());
                            } else {
                                msg.reply((Object)new ServiceException(-1, res.cause().getMessage()));
                            }
                        } else {
                            msg.reply(res.result() == null ? null : ((KeyValueList)res.result()).toJson());
                        }
                    });
                    break;
                }
                case "getValuesWithOptions": {
                    this.service.getValuesWithOptions((String)json.getValue("keyPrefix"), json.getJsonObject("options") == null ? null : new BlockingQueryOptions(json.getJsonObject("options")), res -> {
                        if (res.failed()) {
                            if (res.cause() instanceof ServiceException) {
                                msg.reply((Object)res.cause());
                            } else {
                                msg.reply((Object)new ServiceException(-1, res.cause().getMessage()));
                            }
                        } else {
                            msg.reply(res.result() == null ? null : ((KeyValueList)res.result()).toJson());
                        }
                    });
                    break;
                }
                case "deleteValues": {
                    this.service.deleteValues((String)json.getValue("keyPrefix"), HelperUtils.createHandler(msg));
                    break;
                }
                case "putValue": {
                    this.service.putValue((String)json.getValue("key"), (String)json.getValue("value"), HelperUtils.createHandler(msg));
                    break;
                }
                case "putValueWithOptions": {
                    this.service.putValueWithOptions((String)json.getValue("key"), (String)json.getValue("value"), json.getJsonObject("options") == null ? null : new KeyValueOptions(json.getJsonObject("options")), HelperUtils.createHandler(msg));
                    break;
                }
                case "transaction": {
                    this.service.transaction(json.getJsonObject("request") == null ? null : new TxnRequest(json.getJsonObject("request")), res -> {
                        if (res.failed()) {
                            if (res.cause() instanceof ServiceException) {
                                msg.reply((Object)res.cause());
                            } else {
                                msg.reply((Object)new ServiceException(-1, res.cause().getMessage()));
                            }
                        } else {
                            msg.reply(res.result() == null ? null : ((TxnResponse)res.result()).toJson());
                        }
                    });
                    break;
                }
                case "createAclToken": {
                    this.service.createAclToken(json.getJsonObject("token") == null ? null : new AclToken(json.getJsonObject("token")), HelperUtils.createHandler(msg));
                    break;
                }
                case "updateAclToken": {
                    this.service.updateAclToken(json.getJsonObject("token") == null ? null : new AclToken(json.getJsonObject("token")), HelperUtils.createHandler(msg));
                    break;
                }
                case "cloneAclToken": {
                    this.service.cloneAclToken((String)json.getValue("id"), HelperUtils.createHandler(msg));
                    break;
                }
                case "listAclTokens": {
                    this.service.listAclTokens(res -> {
                        if (res.failed()) {
                            if (res.cause() instanceof ServiceException) {
                                msg.reply((Object)res.cause());
                            } else {
                                msg.reply((Object)new ServiceException(-1, res.cause().getMessage()));
                            }
                        } else {
                            msg.reply((Object)new JsonArray(((List)res.result()).stream().map(r -> r == null ? null : r.toJson()).collect(Collectors.toList())));
                        }
                    });
                    break;
                }
                case "infoAclToken": {
                    this.service.infoAclToken((String)json.getValue("id"), res -> {
                        if (res.failed()) {
                            if (res.cause() instanceof ServiceException) {
                                msg.reply((Object)res.cause());
                            } else {
                                msg.reply((Object)new ServiceException(-1, res.cause().getMessage()));
                            }
                        } else {
                            msg.reply(res.result() == null ? null : ((AclToken)res.result()).toJson());
                        }
                    });
                    break;
                }
                case "destroyAclToken": {
                    this.service.destroyAclToken((String)json.getValue("id"), HelperUtils.createHandler(msg));
                    break;
                }
                case "fireEvent": {
                    this.service.fireEvent((String)json.getValue("name"), res -> {
                        if (res.failed()) {
                            if (res.cause() instanceof ServiceException) {
                                msg.reply((Object)res.cause());
                            } else {
                                msg.reply((Object)new ServiceException(-1, res.cause().getMessage()));
                            }
                        } else {
                            msg.reply(res.result() == null ? null : ((Event)res.result()).toJson());
                        }
                    });
                    break;
                }
                case "fireEventWithOptions": {
                    this.service.fireEventWithOptions((String)json.getValue("name"), json.getJsonObject("options") == null ? null : new EventOptions(json.getJsonObject("options")), res -> {
                        if (res.failed()) {
                            if (res.cause() instanceof ServiceException) {
                                msg.reply((Object)res.cause());
                            } else {
                                msg.reply((Object)new ServiceException(-1, res.cause().getMessage()));
                            }
                        } else {
                            msg.reply(res.result() == null ? null : ((Event)res.result()).toJson());
                        }
                    });
                    break;
                }
                case "listEvents": {
                    this.service.listEvents(res -> {
                        if (res.failed()) {
                            if (res.cause() instanceof ServiceException) {
                                msg.reply((Object)res.cause());
                            } else {
                                msg.reply((Object)new ServiceException(-1, res.cause().getMessage()));
                            }
                        } else {
                            msg.reply(res.result() == null ? null : ((EventList)res.result()).toJson());
                        }
                    });
                    break;
                }
                case "listEventsWithOptions": {
                    this.service.listEventsWithOptions(json.getJsonObject("options") == null ? null : new EventListOptions(json.getJsonObject("options")), res -> {
                        if (res.failed()) {
                            if (res.cause() instanceof ServiceException) {
                                msg.reply((Object)res.cause());
                            } else {
                                msg.reply((Object)new ServiceException(-1, res.cause().getMessage()));
                            }
                        } else {
                            msg.reply(res.result() == null ? null : ((EventList)res.result()).toJson());
                        }
                    });
                    break;
                }
                case "registerService": {
                    this.service.registerService(json.getJsonObject("serviceOptions") == null ? null : new ServiceOptions(json.getJsonObject("serviceOptions")), HelperUtils.createHandler(msg));
                    break;
                }
                case "maintenanceService": {
                    this.service.maintenanceService(json.getJsonObject("maintenanceOptions") == null ? null : new MaintenanceOptions(json.getJsonObject("maintenanceOptions")), HelperUtils.createHandler(msg));
                    break;
                }
                case "deregisterService": {
                    this.service.deregisterService((String)json.getValue("id"), HelperUtils.createHandler(msg));
                    break;
                }
                case "healthChecks": {
                    this.service.healthChecks((String)json.getValue("service"), res -> {
                        if (res.failed()) {
                            if (res.cause() instanceof ServiceException) {
                                msg.reply((Object)res.cause());
                            } else {
                                msg.reply((Object)new ServiceException(-1, res.cause().getMessage()));
                            }
                        } else {
                            msg.reply(res.result() == null ? null : ((CheckList)res.result()).toJson());
                        }
                    });
                    break;
                }
                case "healthChecksWithOptions": {
                    this.service.healthChecksWithOptions((String)json.getValue("service"), json.getJsonObject("options") == null ? null : new CheckQueryOptions(json.getJsonObject("options")), res -> {
                        if (res.failed()) {
                            if (res.cause() instanceof ServiceException) {
                                msg.reply((Object)res.cause());
                            } else {
                                msg.reply((Object)new ServiceException(-1, res.cause().getMessage()));
                            }
                        } else {
                            msg.reply(res.result() == null ? null : ((CheckList)res.result()).toJson());
                        }
                    });
                    break;
                }
                case "healthState": {
                    this.service.healthState(json.getString("healthState") == null ? null : HealthState.valueOf((String)json.getString("healthState")), res -> {
                        if (res.failed()) {
                            if (res.cause() instanceof ServiceException) {
                                msg.reply((Object)res.cause());
                            } else {
                                msg.reply((Object)new ServiceException(-1, res.cause().getMessage()));
                            }
                        } else {
                            msg.reply(res.result() == null ? null : ((CheckList)res.result()).toJson());
                        }
                    });
                    break;
                }
                case "healthStateWithOptions": {
                    this.service.healthStateWithOptions(json.getString("healthState") == null ? null : HealthState.valueOf((String)json.getString("healthState")), json.getJsonObject("checkQueryOptions") == null ? null : new CheckQueryOptions(json.getJsonObject("checkQueryOptions")), res -> {
                        if (res.failed()) {
                            if (res.cause() instanceof ServiceException) {
                                msg.reply((Object)res.cause());
                            } else {
                                msg.reply((Object)new ServiceException(-1, res.cause().getMessage()));
                            }
                        } else {
                            msg.reply(res.result() == null ? null : ((CheckList)res.result()).toJson());
                        }
                    });
                    break;
                }
                case "healthServiceNodes": {
                    this.service.healthServiceNodes((String)json.getValue("service"), (boolean)((Boolean)json.getValue("passing")), res -> {
                        if (res.failed()) {
                            if (res.cause() instanceof ServiceException) {
                                msg.reply((Object)res.cause());
                            } else {
                                msg.reply((Object)new ServiceException(-1, res.cause().getMessage()));
                            }
                        } else {
                            msg.reply(res.result() == null ? null : ((ServiceEntryList)res.result()).toJson());
                        }
                    });
                    break;
                }
                case "healthServiceNodesWithOptions": {
                    this.service.healthServiceNodesWithOptions((String)json.getValue("service"), (boolean)((Boolean)json.getValue("passing")), json.getJsonObject("options") == null ? null : new ServiceQueryOptions(json.getJsonObject("options")), res -> {
                        if (res.failed()) {
                            if (res.cause() instanceof ServiceException) {
                                msg.reply((Object)res.cause());
                            } else {
                                msg.reply((Object)new ServiceException(-1, res.cause().getMessage()));
                            }
                        } else {
                            msg.reply(res.result() == null ? null : ((ServiceEntryList)res.result()).toJson());
                        }
                    });
                    break;
                }
                case "catalogServiceNodes": {
                    this.service.catalogServiceNodes((String)json.getValue("service"), res -> {
                        if (res.failed()) {
                            if (res.cause() instanceof ServiceException) {
                                msg.reply((Object)res.cause());
                            } else {
                                msg.reply((Object)new ServiceException(-1, res.cause().getMessage()));
                            }
                        } else {
                            msg.reply(res.result() == null ? null : ((ServiceList)res.result()).toJson());
                        }
                    });
                    break;
                }
                case "catalogServiceNodesWithOptions": {
                    this.service.catalogServiceNodesWithOptions((String)json.getValue("service"), json.getJsonObject("options") == null ? null : new ServiceQueryOptions(json.getJsonObject("options")), res -> {
                        if (res.failed()) {
                            if (res.cause() instanceof ServiceException) {
                                msg.reply((Object)res.cause());
                            } else {
                                msg.reply((Object)new ServiceException(-1, res.cause().getMessage()));
                            }
                        } else {
                            msg.reply(res.result() == null ? null : ((ServiceList)res.result()).toJson());
                        }
                    });
                    break;
                }
                case "catalogDatacenters": {
                    this.service.catalogDatacenters(HelperUtils.createListHandler(msg));
                    break;
                }
                case "catalogNodes": {
                    this.service.catalogNodes(res -> {
                        if (res.failed()) {
                            if (res.cause() instanceof ServiceException) {
                                msg.reply((Object)res.cause());
                            } else {
                                msg.reply((Object)new ServiceException(-1, res.cause().getMessage()));
                            }
                        } else {
                            msg.reply(res.result() == null ? null : ((NodeList)res.result()).toJson());
                        }
                    });
                    break;
                }
                case "catalogNodesWithOptions": {
                    this.service.catalogNodesWithOptions(json.getJsonObject("options") == null ? null : new NodeQueryOptions(json.getJsonObject("options")), res -> {
                        if (res.failed()) {
                            if (res.cause() instanceof ServiceException) {
                                msg.reply((Object)res.cause());
                            } else {
                                msg.reply((Object)new ServiceException(-1, res.cause().getMessage()));
                            }
                        } else {
                            msg.reply(res.result() == null ? null : ((NodeList)res.result()).toJson());
                        }
                    });
                    break;
                }
                case "catalogServices": {
                    this.service.catalogServices(res -> {
                        if (res.failed()) {
                            if (res.cause() instanceof ServiceException) {
                                msg.reply((Object)res.cause());
                            } else {
                                msg.reply((Object)new ServiceException(-1, res.cause().getMessage()));
                            }
                        } else {
                            msg.reply(res.result() == null ? null : ((ServiceList)res.result()).toJson());
                        }
                    });
                    break;
                }
                case "catalogServicesWithOptions": {
                    this.service.catalogServicesWithOptions(json.getJsonObject("options") == null ? null : new BlockingQueryOptions(json.getJsonObject("options")), res -> {
                        if (res.failed()) {
                            if (res.cause() instanceof ServiceException) {
                                msg.reply((Object)res.cause());
                            } else {
                                msg.reply((Object)new ServiceException(-1, res.cause().getMessage()));
                            }
                        } else {
                            msg.reply(res.result() == null ? null : ((ServiceList)res.result()).toJson());
                        }
                    });
                    break;
                }
                case "localServices": {
                    this.service.localServices(res -> {
                        if (res.failed()) {
                            if (res.cause() instanceof ServiceException) {
                                msg.reply((Object)res.cause());
                            } else {
                                msg.reply((Object)new ServiceException(-1, res.cause().getMessage()));
                            }
                        } else {
                            msg.reply((Object)new JsonArray(((List)res.result()).stream().map(r -> r == null ? null : r.toJson()).collect(Collectors.toList())));
                        }
                    });
                    break;
                }
                case "catalogNodeServices": {
                    this.service.catalogNodeServices((String)json.getValue("node"), res -> {
                        if (res.failed()) {
                            if (res.cause() instanceof ServiceException) {
                                msg.reply((Object)res.cause());
                            } else {
                                msg.reply((Object)new ServiceException(-1, res.cause().getMessage()));
                            }
                        } else {
                            msg.reply(res.result() == null ? null : ((ServiceList)res.result()).toJson());
                        }
                    });
                    break;
                }
                case "catalogNodeServicesWithOptions": {
                    this.service.catalogNodeServicesWithOptions((String)json.getValue("node"), json.getJsonObject("options") == null ? null : new BlockingQueryOptions(json.getJsonObject("options")), res -> {
                        if (res.failed()) {
                            if (res.cause() instanceof ServiceException) {
                                msg.reply((Object)res.cause());
                            } else {
                                msg.reply((Object)new ServiceException(-1, res.cause().getMessage()));
                            }
                        } else {
                            msg.reply(res.result() == null ? null : ((ServiceList)res.result()).toJson());
                        }
                    });
                    break;
                }
                case "localChecks": {
                    this.service.localChecks(res -> {
                        if (res.failed()) {
                            if (res.cause() instanceof ServiceException) {
                                msg.reply((Object)res.cause());
                            } else {
                                msg.reply((Object)new ServiceException(-1, res.cause().getMessage()));
                            }
                        } else {
                            msg.reply((Object)new JsonArray(((List)res.result()).stream().map(r -> r == null ? null : r.toJson()).collect(Collectors.toList())));
                        }
                    });
                    break;
                }
                case "registerCheck": {
                    this.service.registerCheck(json.getJsonObject("checkOptions") == null ? null : new CheckOptions(json.getJsonObject("checkOptions")), HelperUtils.createHandler(msg));
                    break;
                }
                case "deregisterCheck": {
                    this.service.deregisterCheck((String)json.getValue("checkId"), HelperUtils.createHandler(msg));
                    break;
                }
                case "passCheck": {
                    this.service.passCheck((String)json.getValue("checkId"), HelperUtils.createHandler(msg));
                    break;
                }
                case "passCheckWithNote": {
                    this.service.passCheckWithNote((String)json.getValue("checkId"), (String)json.getValue("note"), HelperUtils.createHandler(msg));
                    break;
                }
                case "warnCheck": {
                    this.service.warnCheck((String)json.getValue("checkId"), HelperUtils.createHandler(msg));
                    break;
                }
                case "warnCheckWithNote": {
                    this.service.warnCheckWithNote((String)json.getValue("checkId"), (String)json.getValue("note"), HelperUtils.createHandler(msg));
                    break;
                }
                case "failCheck": {
                    this.service.failCheck((String)json.getValue("checkId"), HelperUtils.createHandler(msg));
                    break;
                }
                case "failCheckWithNote": {
                    this.service.failCheckWithNote((String)json.getValue("checkId"), (String)json.getValue("note"), HelperUtils.createHandler(msg));
                    break;
                }
                case "updateCheck": {
                    this.service.updateCheck((String)json.getValue("checkId"), json.getString("status") == null ? null : CheckStatus.valueOf((String)json.getString("status")), HelperUtils.createHandler(msg));
                    break;
                }
                case "updateCheckWithNote": {
                    this.service.updateCheckWithNote((String)json.getValue("checkId"), json.getString("status") == null ? null : CheckStatus.valueOf((String)json.getString("status")), (String)json.getValue("note"), HelperUtils.createHandler(msg));
                    break;
                }
                case "leaderStatus": {
                    this.service.leaderStatus(HelperUtils.createHandler(msg));
                    break;
                }
                case "peersStatus": {
                    this.service.peersStatus(HelperUtils.createListHandler(msg));
                    break;
                }
                case "createSession": {
                    this.service.createSession(HelperUtils.createHandler(msg));
                    break;
                }
                case "createSessionWithOptions": {
                    this.service.createSessionWithOptions(json.getJsonObject("options") == null ? null : new SessionOptions(json.getJsonObject("options")), HelperUtils.createHandler(msg));
                    break;
                }
                case "infoSession": {
                    this.service.infoSession((String)json.getValue("id"), res -> {
                        if (res.failed()) {
                            if (res.cause() instanceof ServiceException) {
                                msg.reply((Object)res.cause());
                            } else {
                                msg.reply((Object)new ServiceException(-1, res.cause().getMessage()));
                            }
                        } else {
                            msg.reply(res.result() == null ? null : ((Session)res.result()).toJson());
                        }
                    });
                    break;
                }
                case "infoSessionWithOptions": {
                    this.service.infoSessionWithOptions((String)json.getValue("id"), json.getJsonObject("options") == null ? null : new BlockingQueryOptions(json.getJsonObject("options")), res -> {
                        if (res.failed()) {
                            if (res.cause() instanceof ServiceException) {
                                msg.reply((Object)res.cause());
                            } else {
                                msg.reply((Object)new ServiceException(-1, res.cause().getMessage()));
                            }
                        } else {
                            msg.reply(res.result() == null ? null : ((Session)res.result()).toJson());
                        }
                    });
                    break;
                }
                case "renewSession": {
                    this.service.renewSession((String)json.getValue("id"), res -> {
                        if (res.failed()) {
                            if (res.cause() instanceof ServiceException) {
                                msg.reply((Object)res.cause());
                            } else {
                                msg.reply((Object)new ServiceException(-1, res.cause().getMessage()));
                            }
                        } else {
                            msg.reply(res.result() == null ? null : ((Session)res.result()).toJson());
                        }
                    });
                    break;
                }
                case "listSessions": {
                    this.service.listSessions(res -> {
                        if (res.failed()) {
                            if (res.cause() instanceof ServiceException) {
                                msg.reply((Object)res.cause());
                            } else {
                                msg.reply((Object)new ServiceException(-1, res.cause().getMessage()));
                            }
                        } else {
                            msg.reply(res.result() == null ? null : ((SessionList)res.result()).toJson());
                        }
                    });
                    break;
                }
                case "listSessionsWithOptions": {
                    this.service.listSessionsWithOptions(json.getJsonObject("options") == null ? null : new BlockingQueryOptions(json.getJsonObject("options")), res -> {
                        if (res.failed()) {
                            if (res.cause() instanceof ServiceException) {
                                msg.reply((Object)res.cause());
                            } else {
                                msg.reply((Object)new ServiceException(-1, res.cause().getMessage()));
                            }
                        } else {
                            msg.reply(res.result() == null ? null : ((SessionList)res.result()).toJson());
                        }
                    });
                    break;
                }
                case "listNodeSessions": {
                    this.service.listNodeSessions((String)json.getValue("nodeId"), res -> {
                        if (res.failed()) {
                            if (res.cause() instanceof ServiceException) {
                                msg.reply((Object)res.cause());
                            } else {
                                msg.reply((Object)new ServiceException(-1, res.cause().getMessage()));
                            }
                        } else {
                            msg.reply(res.result() == null ? null : ((SessionList)res.result()).toJson());
                        }
                    });
                    break;
                }
                case "listNodeSessionsWithOptions": {
                    this.service.listNodeSessionsWithOptions((String)json.getValue("nodeId"), json.getJsonObject("options") == null ? null : new BlockingQueryOptions(json.getJsonObject("options")), res -> {
                        if (res.failed()) {
                            if (res.cause() instanceof ServiceException) {
                                msg.reply((Object)res.cause());
                            } else {
                                msg.reply((Object)new ServiceException(-1, res.cause().getMessage()));
                            }
                        } else {
                            msg.reply(res.result() == null ? null : ((SessionList)res.result()).toJson());
                        }
                    });
                    break;
                }
                case "destroySession": {
                    this.service.destroySession((String)json.getValue("id"), HelperUtils.createHandler(msg));
                    break;
                }
                case "createPreparedQuery": {
                    this.service.createPreparedQuery(json.getJsonObject("definition") == null ? null : new PreparedQueryDefinition(json.getJsonObject("definition")), HelperUtils.createHandler(msg));
                    break;
                }
                case "getPreparedQuery": {
                    this.service.getPreparedQuery((String)json.getValue("id"), res -> {
                        if (res.failed()) {
                            if (res.cause() instanceof ServiceException) {
                                msg.reply((Object)res.cause());
                            } else {
                                msg.reply((Object)new ServiceException(-1, res.cause().getMessage()));
                            }
                        } else {
                            msg.reply(res.result() == null ? null : ((PreparedQueryDefinition)res.result()).toJson());
                        }
                    });
                    break;
                }
                case "getAllPreparedQueries": {
                    this.service.getAllPreparedQueries(res -> {
                        if (res.failed()) {
                            if (res.cause() instanceof ServiceException) {
                                msg.reply((Object)res.cause());
                            } else {
                                msg.reply((Object)new ServiceException(-1, res.cause().getMessage()));
                            }
                        } else {
                            msg.reply((Object)new JsonArray(((List)res.result()).stream().map(r -> r == null ? null : r.toJson()).collect(Collectors.toList())));
                        }
                    });
                    break;
                }
                case "updatePreparedQuery": {
                    this.service.updatePreparedQuery(json.getJsonObject("definition") == null ? null : new PreparedQueryDefinition(json.getJsonObject("definition")), HelperUtils.createHandler(msg));
                    break;
                }
                case "deletePreparedQuery": {
                    this.service.deletePreparedQuery((String)json.getValue("id"), HelperUtils.createHandler(msg));
                    break;
                }
                case "executePreparedQuery": {
                    this.service.executePreparedQuery((String)json.getValue("query"), res -> {
                        if (res.failed()) {
                            if (res.cause() instanceof ServiceException) {
                                msg.reply((Object)res.cause());
                            } else {
                                msg.reply((Object)new ServiceException(-1, res.cause().getMessage()));
                            }
                        } else {
                            msg.reply(res.result() == null ? null : ((PreparedQueryExecuteResponse)res.result()).toJson());
                        }
                    });
                    break;
                }
                case "executePreparedQueryWithOptions": {
                    this.service.executePreparedQueryWithOptions((String)json.getValue("query"), json.getJsonObject("options") == null ? null : new PreparedQueryExecuteOptions(json.getJsonObject("options")), res -> {
                        if (res.failed()) {
                            if (res.cause() instanceof ServiceException) {
                                msg.reply((Object)res.cause());
                            } else {
                                msg.reply((Object)new ServiceException(-1, res.cause().getMessage()));
                            }
                        } else {
                            msg.reply(res.result() == null ? null : ((PreparedQueryExecuteResponse)res.result()).toJson());
                        }
                    });
                    break;
                }
                case "close": {
                    this.service.close();
                    break;
                }
                default: {
                    throw new IllegalStateException("Invalid action: " + action);
                }
            }
        }
        catch (Throwable t) {
            msg.reply((Object)new ServiceException(500, t.getMessage()));
            throw t;
        }
    }
}

