/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.consul.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.consul.AclToken;
import io.vertx.ext.consul.BlockingQueryOptions;
import io.vertx.ext.consul.Check;
import io.vertx.ext.consul.CheckList;
import io.vertx.ext.consul.CheckOptions;
import io.vertx.ext.consul.CheckQueryOptions;
import io.vertx.ext.consul.CheckStatus;
import io.vertx.ext.consul.ConsulClient;
import io.vertx.ext.consul.ConsulService;
import io.vertx.ext.consul.CoordinateList;
import io.vertx.ext.consul.DcCoordinates;
import io.vertx.ext.consul.Event;
import io.vertx.ext.consul.EventList;
import io.vertx.ext.consul.EventListOptions;
import io.vertx.ext.consul.EventOptions;
import io.vertx.ext.consul.HealthState;
import io.vertx.ext.consul.KeyValue;
import io.vertx.ext.consul.KeyValueList;
import io.vertx.ext.consul.KeyValueOptions;
import io.vertx.ext.consul.MaintenanceOptions;
import io.vertx.ext.consul.NodeList;
import io.vertx.ext.consul.NodeQueryOptions;
import io.vertx.ext.consul.PreparedQueryDefinition;
import io.vertx.ext.consul.PreparedQueryExecuteOptions;
import io.vertx.ext.consul.PreparedQueryExecuteResponse;
import io.vertx.ext.consul.Service;
import io.vertx.ext.consul.ServiceEntryList;
import io.vertx.ext.consul.ServiceList;
import io.vertx.ext.consul.ServiceOptions;
import io.vertx.ext.consul.ServiceQueryOptions;
import io.vertx.ext.consul.Session;
import io.vertx.ext.consul.SessionList;
import io.vertx.ext.consul.SessionOptions;
import io.vertx.ext.consul.TxnRequest;
import io.vertx.ext.consul.TxnResponse;
import java.util.List;

public class ConsulServiceImpl
implements ConsulService {
    private final ConsulClient consulClient;

    public ConsulServiceImpl(ConsulClient consulClient) {
        this.consulClient = consulClient;
    }

    @Override
    public ConsulService agentInfo(Handler<AsyncResult<JsonObject>> resultHandler) {
        this.consulClient.agentInfo(resultHandler);
        return this;
    }

    @Override
    public ConsulService coordinateNodes(Handler<AsyncResult<CoordinateList>> resultHandler) {
        this.consulClient.coordinateNodes(resultHandler);
        return this;
    }

    @Override
    public ConsulService coordinateNodesWithOptions(BlockingQueryOptions options, Handler<AsyncResult<CoordinateList>> resultHandler) {
        this.consulClient.coordinateNodesWithOptions(options, resultHandler);
        return this;
    }

    @Override
    public ConsulService coordinateDatacenters(Handler<AsyncResult<List<DcCoordinates>>> resultHandler) {
        this.consulClient.coordinateDatacenters(resultHandler);
        return this;
    }

    @Override
    public ConsulService getKeys(String keyPrefix, Handler<AsyncResult<List<String>>> resultHandler) {
        this.consulClient.getKeys(keyPrefix, resultHandler);
        return this;
    }

    @Override
    public ConsulService getKeysWithOptions(String keyPrefix, BlockingQueryOptions options, Handler<AsyncResult<List<String>>> resultHandler) {
        this.consulClient.getKeysWithOptions(keyPrefix, options, resultHandler);
        return this;
    }

    @Override
    public ConsulService getValue(String key, Handler<AsyncResult<KeyValue>> resultHandler) {
        this.consulClient.getValue(key, resultHandler);
        return this;
    }

    @Override
    public ConsulService getValueWithOptions(String key, BlockingQueryOptions options, Handler<AsyncResult<KeyValue>> resultHandler) {
        this.consulClient.getValueWithOptions(key, options, resultHandler);
        return this;
    }

    @Override
    public ConsulService deleteValue(String key, Handler<AsyncResult<Void>> resultHandler) {
        this.consulClient.deleteValue(key, resultHandler);
        return this;
    }

    @Override
    public ConsulService getValues(String keyPrefix, Handler<AsyncResult<KeyValueList>> resultHandler) {
        this.consulClient.getValues(keyPrefix, resultHandler);
        return this;
    }

    @Override
    public ConsulService getValuesWithOptions(String keyPrefix, BlockingQueryOptions options, Handler<AsyncResult<KeyValueList>> resultHandler) {
        this.consulClient.getValuesWithOptions(keyPrefix, options, resultHandler);
        return this;
    }

    @Override
    public ConsulService deleteValues(String keyPrefix, Handler<AsyncResult<Void>> resultHandler) {
        this.consulClient.deleteValues(keyPrefix, resultHandler);
        return this;
    }

    @Override
    public ConsulService putValue(String key, String value, Handler<AsyncResult<Boolean>> resultHandler) {
        this.consulClient.putValue(key, value, resultHandler);
        return this;
    }

    @Override
    public ConsulService putValueWithOptions(String key, String value, KeyValueOptions options, Handler<AsyncResult<Boolean>> resultHandler) {
        this.consulClient.putValueWithOptions(key, value, options, resultHandler);
        return this;
    }

    @Override
    public ConsulService transaction(TxnRequest request, Handler<AsyncResult<TxnResponse>> resultHandler) {
        this.consulClient.transaction(request, resultHandler);
        return this;
    }

    @Override
    public ConsulService createAclToken(AclToken aclToken, Handler<AsyncResult<String>> idHandler) {
        this.consulClient.createAclToken(aclToken, idHandler);
        return this;
    }

    @Override
    public ConsulService updateAclToken(AclToken token, Handler<AsyncResult<String>> idHandler) {
        this.consulClient.updateAclToken(token, idHandler);
        return this;
    }

    @Override
    public ConsulService cloneAclToken(String id, Handler<AsyncResult<String>> idHandler) {
        this.consulClient.cloneAclToken(id, idHandler);
        return this;
    }

    @Override
    public ConsulService listAclTokens(Handler<AsyncResult<List<AclToken>>> resultHandler) {
        this.consulClient.listAclTokens(resultHandler);
        return this;
    }

    @Override
    public ConsulService infoAclToken(String id, Handler<AsyncResult<AclToken>> tokenHandler) {
        this.consulClient.infoAclToken(id, tokenHandler);
        return this;
    }

    @Override
    public ConsulService destroyAclToken(String id, Handler<AsyncResult<Void>> resultHandler) {
        this.consulClient.destroyAclToken(id, resultHandler);
        return this;
    }

    @Override
    public ConsulService fireEvent(String name, Handler<AsyncResult<Event>> resultHandler) {
        this.consulClient.fireEvent(name, resultHandler);
        return this;
    }

    @Override
    public ConsulService fireEventWithOptions(String name, EventOptions options, Handler<AsyncResult<Event>> resultHandler) {
        this.consulClient.fireEventWithOptions(name, options, resultHandler);
        return this;
    }

    @Override
    public ConsulService listEvents(Handler<AsyncResult<EventList>> resultHandler) {
        this.consulClient.listEvents(resultHandler);
        return this;
    }

    @Override
    public ConsulService listEventsWithOptions(EventListOptions options, Handler<AsyncResult<EventList>> resultHandler) {
        this.consulClient.listEventsWithOptions(options, resultHandler);
        return this;
    }

    @Override
    public ConsulService registerService(ServiceOptions serviceOptions, Handler<AsyncResult<Void>> resultHandler) {
        this.consulClient.registerService(serviceOptions, resultHandler);
        return this;
    }

    @Override
    public ConsulService maintenanceService(MaintenanceOptions maintenanceOptions, Handler<AsyncResult<Void>> resultHandler) {
        this.consulClient.maintenanceService(maintenanceOptions, resultHandler);
        return this;
    }

    @Override
    public ConsulService deregisterService(String id, Handler<AsyncResult<Void>> resultHandler) {
        this.consulClient.deregisterService(id, resultHandler);
        return this;
    }

    @Override
    public ConsulService healthChecks(String service, Handler<AsyncResult<CheckList>> resultHandler) {
        this.consulClient.healthChecks(service, resultHandler);
        return this;
    }

    @Override
    public ConsulService healthChecksWithOptions(String service, CheckQueryOptions options, Handler<AsyncResult<CheckList>> resultHandler) {
        this.consulClient.healthChecksWithOptions(service, options, resultHandler);
        return this;
    }

    @Override
    public ConsulService healthState(HealthState healthState, Handler<AsyncResult<CheckList>> handler) {
        this.consulClient.healthState(healthState, handler);
        return this;
    }

    @Override
    public ConsulService healthStateWithOptions(HealthState healthState, CheckQueryOptions checkQueryOptions, Handler<AsyncResult<CheckList>> handler) {
        this.consulClient.healthStateWithOptions(healthState, checkQueryOptions, handler);
        return this;
    }

    @Override
    public ConsulService healthServiceNodes(String service, boolean passing, Handler<AsyncResult<ServiceEntryList>> resultHandler) {
        this.consulClient.healthServiceNodes(service, passing, resultHandler);
        return this;
    }

    @Override
    public ConsulService healthServiceNodesWithOptions(String service, boolean passing, ServiceQueryOptions options, Handler<AsyncResult<ServiceEntryList>> resultHandler) {
        this.consulClient.healthServiceNodesWithOptions(service, passing, options, resultHandler);
        return this;
    }

    @Override
    public ConsulService catalogServiceNodes(String service, Handler<AsyncResult<ServiceList>> resultHandler) {
        this.consulClient.catalogServiceNodes(service, resultHandler);
        return this;
    }

    @Override
    public ConsulService catalogServiceNodesWithOptions(String service, ServiceQueryOptions options, Handler<AsyncResult<ServiceList>> resultHandler) {
        this.consulClient.catalogServiceNodesWithOptions(service, options, resultHandler);
        return this;
    }

    @Override
    public ConsulService catalogDatacenters(Handler<AsyncResult<List<String>>> resultHandler) {
        this.consulClient.catalogDatacenters(resultHandler);
        return this;
    }

    @Override
    public ConsulService catalogNodes(Handler<AsyncResult<NodeList>> resultHandler) {
        this.consulClient.catalogNodes(resultHandler);
        return this;
    }

    @Override
    public ConsulService catalogNodesWithOptions(NodeQueryOptions options, Handler<AsyncResult<NodeList>> resultHandler) {
        this.consulClient.catalogNodesWithOptions(options, resultHandler);
        return this;
    }

    @Override
    public ConsulService catalogServices(Handler<AsyncResult<ServiceList>> resultHandler) {
        this.consulClient.catalogServices(resultHandler);
        return this;
    }

    @Override
    public ConsulService catalogServicesWithOptions(BlockingQueryOptions options, Handler<AsyncResult<ServiceList>> resultHandler) {
        this.consulClient.catalogServicesWithOptions(options, resultHandler);
        return this;
    }

    @Override
    public ConsulService localChecks(Handler<AsyncResult<List<Check>>> resultHandler) {
        this.consulClient.localChecks(resultHandler);
        return this;
    }

    @Override
    public ConsulService registerCheck(CheckOptions checkOptions, Handler<AsyncResult<Void>> resultHandler) {
        this.consulClient.registerCheck(checkOptions, resultHandler);
        return this;
    }

    @Override
    public ConsulService deregisterCheck(String checkId, Handler<AsyncResult<Void>> resultHandler) {
        this.consulClient.deregisterCheck(checkId, resultHandler);
        return this;
    }

    @Override
    public ConsulService passCheck(String checkId, Handler<AsyncResult<Void>> resultHandler) {
        this.consulClient.passCheck(checkId, resultHandler);
        return this;
    }

    @Override
    public ConsulService passCheckWithNote(String checkId, String note, Handler<AsyncResult<Void>> resultHandler) {
        this.consulClient.passCheckWithNote(checkId, note, resultHandler);
        return this;
    }

    @Override
    public ConsulService warnCheck(String checkId, Handler<AsyncResult<Void>> resultHandler) {
        this.consulClient.warnCheck(checkId, resultHandler);
        return this;
    }

    @Override
    public ConsulService warnCheckWithNote(String checkId, String note, Handler<AsyncResult<Void>> resultHandler) {
        this.consulClient.warnCheckWithNote(checkId, note, resultHandler);
        return this;
    }

    @Override
    public ConsulService failCheck(String checkId, Handler<AsyncResult<Void>> resultHandler) {
        this.consulClient.failCheck(checkId, resultHandler);
        return this;
    }

    @Override
    public ConsulService failCheckWithNote(String checkId, String note, Handler<AsyncResult<Void>> resultHandler) {
        this.consulClient.failCheckWithNote(checkId, note, resultHandler);
        return this;
    }

    @Override
    public ConsulService updateCheck(String checkId, CheckStatus status, Handler<AsyncResult<Void>> resultHandler) {
        this.consulClient.updateCheck(checkId, status, resultHandler);
        return this;
    }

    @Override
    public ConsulService updateCheckWithNote(String checkId, CheckStatus status, String note, Handler<AsyncResult<Void>> resultHandler) {
        this.consulClient.updateCheckWithNote(checkId, status, note, resultHandler);
        return this;
    }

    @Override
    public ConsulService leaderStatus(Handler<AsyncResult<String>> resultHandler) {
        this.consulClient.leaderStatus(resultHandler);
        return this;
    }

    @Override
    public ConsulService peersStatus(Handler<AsyncResult<List<String>>> resultHandler) {
        this.consulClient.peersStatus(resultHandler);
        return this;
    }

    @Override
    public ConsulService createSession(Handler<AsyncResult<String>> idHandler) {
        this.consulClient.createSession(idHandler);
        return this;
    }

    @Override
    public ConsulService createSessionWithOptions(SessionOptions options, Handler<AsyncResult<String>> idHandler) {
        this.consulClient.createSessionWithOptions(options, idHandler);
        return this;
    }

    @Override
    public ConsulService infoSession(String id, Handler<AsyncResult<Session>> resultHandler) {
        this.consulClient.infoSession(id, resultHandler);
        return this;
    }

    @Override
    public ConsulService infoSessionWithOptions(String id, BlockingQueryOptions options, Handler<AsyncResult<Session>> resultHandler) {
        this.consulClient.infoSessionWithOptions(id, options, resultHandler);
        return this;
    }

    @Override
    public ConsulService renewSession(String id, Handler<AsyncResult<Session>> resultHandler) {
        this.consulClient.renewSession(id, resultHandler);
        return this;
    }

    @Override
    public ConsulService listSessions(Handler<AsyncResult<SessionList>> resultHandler) {
        this.consulClient.listSessions(resultHandler);
        return this;
    }

    @Override
    public ConsulService listSessionsWithOptions(BlockingQueryOptions options, Handler<AsyncResult<SessionList>> resultHandler) {
        this.consulClient.listSessionsWithOptions(options, resultHandler);
        return this;
    }

    @Override
    public ConsulService listNodeSessions(String nodeId, Handler<AsyncResult<SessionList>> resultHandler) {
        this.consulClient.listNodeSessions(nodeId, resultHandler);
        return this;
    }

    @Override
    public ConsulService listNodeSessionsWithOptions(String nodeId, BlockingQueryOptions options, Handler<AsyncResult<SessionList>> resultHandler) {
        this.consulClient.listNodeSessionsWithOptions(nodeId, options, resultHandler);
        return this;
    }

    @Override
    public ConsulService destroySession(String id, Handler<AsyncResult<Void>> resultHandler) {
        this.consulClient.destroySession(id, resultHandler);
        return this;
    }

    @Override
    public ConsulService createPreparedQuery(PreparedQueryDefinition definition, Handler<AsyncResult<String>> resultHandler) {
        this.consulClient.createPreparedQuery(definition, resultHandler);
        return this;
    }

    @Override
    public ConsulService getPreparedQuery(String id, Handler<AsyncResult<PreparedQueryDefinition>> resultHandler) {
        this.consulClient.getPreparedQuery(id, resultHandler);
        return this;
    }

    @Override
    public ConsulService getAllPreparedQueries(Handler<AsyncResult<List<PreparedQueryDefinition>>> resultHandler) {
        this.consulClient.getAllPreparedQueries(resultHandler);
        return this;
    }

    @Override
    public ConsulService updatePreparedQuery(PreparedQueryDefinition definition, Handler<AsyncResult<Void>> resultHandler) {
        this.consulClient.updatePreparedQuery(definition, resultHandler);
        return this;
    }

    @Override
    public ConsulService deletePreparedQuery(String id, Handler<AsyncResult<Void>> resultHandler) {
        this.consulClient.deletePreparedQuery(id, resultHandler);
        return this;
    }

    @Override
    public ConsulService executePreparedQuery(String query, Handler<AsyncResult<PreparedQueryExecuteResponse>> resultHandler) {
        this.consulClient.executePreparedQuery(query, resultHandler);
        return this;
    }

    @Override
    public ConsulService executePreparedQueryWithOptions(String query, PreparedQueryExecuteOptions options, Handler<AsyncResult<PreparedQueryExecuteResponse>> resultHandler) {
        this.consulClient.executePreparedQueryWithOptions(query, options, resultHandler);
        return this;
    }

    @Override
    public ConsulService localServices(Handler<AsyncResult<List<Service>>> resultHandler) {
        this.consulClient.localServices(resultHandler);
        return this;
    }

    @Override
    public ConsulService catalogNodeServices(String node, Handler<AsyncResult<ServiceList>> resultHandler) {
        this.consulClient.catalogNodeServices(node, resultHandler);
        return this;
    }

    @Override
    public ConsulService catalogNodeServicesWithOptions(String node, BlockingQueryOptions options, Handler<AsyncResult<ServiceList>> resultHandler) {
        this.consulClient.catalogNodeServicesWithOptions(node, options, resultHandler);
        return this;
    }

    @Override
    public void close() {
        this.consulClient.close();
    }
}

