/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.shell.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.ext.shell.ShellServer;
import io.vertx.ext.shell.ShellServerOptions;
import io.vertx.ext.shell.ShellService;
import io.vertx.ext.shell.ShellServiceOptions;
import io.vertx.ext.shell.command.CommandRegistry;
import io.vertx.ext.shell.command.CommandResolver;
import io.vertx.ext.shell.spi.CommandResolverFactory;
import io.vertx.ext.shell.term.HttpTermOptions;
import io.vertx.ext.shell.term.SSHTermOptions;
import io.vertx.ext.shell.term.TelnetTermOptions;
import io.vertx.ext.shell.term.impl.HttpTermServer;
import io.vertx.ext.shell.term.impl.SSHServer;
import io.vertx.ext.shell.term.impl.TelnetTermServer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ServiceLoader;
import java.util.concurrent.atomic.AtomicInteger;

public class ShellServiceImpl
implements ShellService {
    private final Vertx vertx;
    private final ShellServiceOptions options;
    private final ShellServer server;
    private final CommandRegistry registry;

    public ShellServiceImpl(Vertx vertx, ShellServiceOptions options) {
        this.vertx = vertx;
        this.options = options;
        this.server = ShellServer.create(vertx, new ShellServerOptions(options));
        this.registry = CommandRegistry.getShared(vertx);
    }

    @Override
    public ShellServer server() {
        return this.server;
    }

    @Override
    public void start(Handler<AsyncResult<Void>> startHandler) {
        ServiceLoader<CommandResolverFactory> loader = ServiceLoader.load(CommandResolverFactory.class);
        Iterator<CommandResolverFactory> it = loader.iterator();
        ArrayList<CommandResolverFactory> factories = new ArrayList<CommandResolverFactory>();
        factories.add((vertx, handler) -> handler.handle((Object)Future.succeededFuture((Object)CommandResolver.baseCommands(vertx))));
        while (true) {
            try {
                while (it.hasNext()) {
                    CommandResolverFactory factory = it.next();
                    factories.add(factory);
                }
            }
            catch (Exception factory) {
                continue;
            }
            break;
        }
        AtomicInteger count = new AtomicInteger(factories.size());
        ArrayList<CommandRegistry> resolvers = new ArrayList<CommandRegistry>();
        resolvers.add(this.registry);
        Handler startServer = v -> {
            if (count.decrementAndGet() == 0) {
                this.startServer(resolvers, startHandler);
            }
        };
        for (CommandResolverFactory factory : factories) {
            factory.resolver(this.vertx, (Handler<AsyncResult<CommandResolver>>)((Handler)ar -> {
                if (ar.succeeded()) {
                    resolvers.add((CommandRegistry)ar.result());
                }
                startServer.handle(null);
            }));
        }
    }

    private void startServer(List<CommandResolver> resolvers, Handler<AsyncResult<Void>> startHandler) {
        TelnetTermOptions telnetOptions = this.options.getTelnetOptions();
        SSHTermOptions sshOptions = this.options.getSSHOptions();
        HttpTermOptions webOptions = this.options.getHttpOptions();
        if (telnetOptions != null) {
            this.server.registerTermServer(new TelnetTermServer(this.vertx, telnetOptions));
        }
        if (sshOptions != null) {
            this.server.registerTermServer(new SSHServer(this.vertx, sshOptions));
        }
        if (webOptions != null) {
            this.server.registerTermServer(new HttpTermServer(this.vertx, webOptions));
        }
        resolvers.forEach(this.server::registerCommandResolver);
        this.server.listen(startHandler);
    }

    @Override
    public void stop(Handler<AsyncResult<Void>> stopHandler) {
        this.server.close(stopHandler);
    }
}

