/*
 * Decompiled with CFR 0.152.
 */
package com.mitchellbosecke.pebble.template;

import com.mitchellbosecke.pebble.template.Scope;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;

public class ScopeChain {
    private LinkedList<Scope> stack = new LinkedList();

    public ScopeChain() {
    }

    public ScopeChain(Map<String, Object> map) {
        Scope scope = new Scope(new HashMap<String, Object>(map));
        this.stack.push(scope);
    }

    public ScopeChain deepCopy() {
        ScopeChain copy = new ScopeChain();
        for (Scope originalScope : this.stack) {
            copy.stack.add(originalScope.shallowCopy());
        }
        return copy;
    }

    public void pushScope() {
        this.pushScope(new HashMap<String, Object>());
    }

    public void pushScope(Map<String, Object> map) {
        Scope scope = new Scope(map);
        this.stack.push(scope);
    }

    public void popScope() {
        this.stack.pop();
    }

    public void put(String key, Object value) {
        this.stack.peek().put(key, value);
    }

    public Object get(String key) {
        Scope scope = this.stack.getFirst();
        Object result = scope.get(key);
        if (result != null) {
            return result;
        }
        if (this.stack.size() > 1) {
            if (scope.containsKey(key)) {
                return null;
            }
            Iterator iterator = this.stack.iterator();
            iterator.next();
            while (iterator.hasNext()) {
                result = ((Scope)iterator.next()).get(key);
                if (result != null) {
                    return result;
                }
                if (!scope.containsKey(key)) continue;
                return null;
            }
        }
        return null;
    }

    public boolean containsKey(String key) {
        Scope scope = this.stack.getFirst();
        if (scope.containsKey(key)) {
            return true;
        }
        Iterator iterator = this.stack.iterator();
        iterator.next();
        while (iterator.hasNext()) {
            scope = (Scope)iterator.next();
            if (!scope.containsKey(key)) continue;
            return true;
        }
        return false;
    }

    public boolean currentScopeContainsVariable(String variableName) {
        return this.stack.getFirst().containsKey(variableName);
    }

    public void set(String key, Object value) {
        Scope scope = this.stack.getFirst();
        if (scope.containsKey(key)) {
            scope.put(key, value);
            return;
        }
        Iterator iterator = this.stack.iterator();
        iterator.next();
        while (iterator.hasNext()) {
            scope = (Scope)iterator.next();
            if (!scope.containsKey(key)) continue;
            scope.put(key, value);
            return;
        }
        this.put(key, value);
    }
}

