/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.templ.handlebars.impl;

import com.github.jknack.handlebars.ValueResolver;
import io.vertx.core.json.JsonArray;
import java.util.Collections;
import java.util.Map;
import java.util.Set;

public class JsonArrayValueResolver
implements ValueResolver {
    public static final ValueResolver INSTANCE = new JsonArrayValueResolver();

    @Override
    public Object resolve(Object context) {
        if (context instanceof JsonArray) {
            return context;
        }
        return UNRESOLVED;
    }

    @Override
    public Object resolve(Object context, String name) {
        if (context instanceof JsonArray) {
            JsonArray jsonArray = (JsonArray)context;
            if ("length".equals(name) || "size".equals(name)) {
                return jsonArray.size();
            }
            Object value = jsonArray.getValue(Integer.valueOf(name).intValue());
            if (value != null) {
                return value;
            }
        }
        return UNRESOLVED;
    }

    @Override
    public Set<Map.Entry<String, Object>> propertySet(Object context) {
        return Collections.emptySet();
    }
}

