/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.lang.rxjava;

import io.vertx.codegen.ClassModel;
import io.vertx.codegen.MethodInfo;
import io.vertx.codegen.ParamInfo;
import io.vertx.codegen.TypeParamInfo;
import io.vertx.codegen.type.ApiTypeInfo;
import io.vertx.codegen.type.ClassKind;
import io.vertx.codegen.type.ClassTypeInfo;
import io.vertx.codegen.type.ParameterizedTypeInfo;
import io.vertx.codegen.type.TypeInfo;
import io.vertx.codegen.type.TypeReflectionFactory;
import io.vertx.lang.rx.AbstractRxGenerator;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import rx.Observable;
import rx.Single;

class RxJavaGenerator
extends AbstractRxGenerator {
    RxJavaGenerator() {
        super("rxjava");
        this.name = "RxJava";
    }

    protected void genRxImports(ClassModel model, PrintWriter writer) {
        writer.println("import rx.Observable;");
        writer.println("import rx.Single;");
        super.genRxImports(model, writer);
    }

    protected void genToObservable(ApiTypeInfo type, PrintWriter writer) {
        TypeInfo streamType = type.getReadStreamArg();
        writer.print("  private rx.Observable<");
        writer.print(this.genTypeName(streamType));
        writer.println("> observable;");
        writer.println();
        writer.print("  public synchronized rx.Observable<");
        writer.print(this.genTypeName(streamType));
        writer.println("> toObservable() {");
        writer.print("    ");
        writer.println("if (observable == null) {");
        if (streamType.getKind() == ClassKind.API) {
            writer.print("      java.util.function.Function<");
            writer.print(streamType.getName());
            writer.print(", ");
            writer.print(this.genTypeName(streamType));
            writer.print("> conv = ");
            writer.print(this.genTypeName((TypeInfo)streamType.getRaw()));
            writer.println("::newInstance;");
            writer.println("      observable = io.vertx.rx.java.RxHelper.toObservable(delegate, conv);");
        } else if (streamType.isVariable()) {
            String typeVar = streamType.getSimpleName();
            writer.print("      java.util.function.Function<");
            writer.print(typeVar);
            writer.print(", ");
            writer.print(typeVar);
            writer.print("> conv = (java.util.function.Function<");
            writer.print(typeVar);
            writer.print(", ");
            writer.print(typeVar);
            writer.println(">) __typeArg_0.wrap;");
            writer.println("      observable = io.vertx.rx.java.RxHelper.toObservable(delegate, conv);");
        } else {
            writer.println("      observable = io.vertx.rx.java.RxHelper.toObservable(this.getDelegate());");
        }
        writer.println("    }");
        writer.println("    return observable;");
        writer.println("  }");
        writer.println();
    }

    protected void genMethods(ClassModel model, MethodInfo method, List<String> cacheDecls, PrintWriter writer) {
        this.genMethod(model, method, cacheDecls, writer);
        MethodInfo overloaded = this.genOverloadedMethod(method);
        if (overloaded != null) {
            this.genMethod(model, overloaded, cacheDecls, writer);
        }
    }

    protected void genRxMethod(ClassModel model, MethodInfo method, PrintWriter writer) {
        ClassTypeInfo type = model.getType();
        String packageName = type.getPackageName();
        writer.print("  ");
        if (packageName.startsWith("io.vertx.codegen") || packageName.startsWith("io.vertx.core") || packageName.startsWith("io.vertx.ext.web") || packageName.startsWith("io.vertx.ext.sql") || packageName.startsWith("io.vertx.ext.jdbc") || packageName.startsWith("io.vertx.ext.mongo") || packageName.startsWith("io.vertx.ext.auth") || packageName.startsWith("io.vertx.ext.jwt") || packageName.startsWith("io.vertx.redis") || packageName.startsWith("io.vertx.ext.mail") || packageName.startsWith("io.vertx.ext.asyncsql") || packageName.startsWith("io.vertx.ext.stomp") || packageName.startsWith("io.vertx.ext.shell") || packageName.startsWith("io.vertx.ext.dropwizard") || packageName.startsWith("io.vertx.amqpbridge") || packageName.startsWith("io.vertx.rabbitmq") || packageName.startsWith("io.vertx.ext.unit")) {
            ArrayList futureParams = new ArrayList(method.getParams());
            ParamInfo futureParam = (ParamInfo)futureParams.remove(futureParams.size() - 1);
            ParameterizedTypeInfo handlerType = (ParameterizedTypeInfo)futureParam.getType();
            ParameterizedTypeInfo asyncResultType = (ParameterizedTypeInfo)handlerType.getArg(0);
            TypeInfo futureType = asyncResultType.getArg(0);
            ParameterizedTypeInfo futureReturnType = new ParameterizedTypeInfo(TypeReflectionFactory.create(Observable.class).getRaw(), false, Collections.singletonList(futureType));
            MethodInfo futureMethod = method.copy().setName(method.getName() + "Observable").setParams(futureParams).setReturnType((TypeInfo)futureReturnType);
            this.startMethodTemplate(type, futureMethod, "use {@link #" + this.genFutureMethodName(method) + "} instead", writer);
            writer.println(" { ");
            writer.print("    io.vertx.rx.java.ObservableFuture<");
            writer.print(this.genTypeName(futureType));
            writer.print("> ");
            writer.print(futureParam.getName());
            writer.println(" = io.vertx.rx.java.RxHelper.observableFuture();");
            writer.print("    ");
            writer.print(method.getName());
            writer.print("(");
            writer.print(futureParams.stream().map(ParamInfo::getName).collect(Collectors.joining(", ")));
            if (futureParams.size() > 0) {
                writer.print(", ");
            }
            writer.print(futureParam.getName());
            writer.println(".toHandler());");
            writer.print("    return ");
            writer.print(futureParam.getName());
            writer.println(";");
            writer.println("  }");
            writer.println();
        }
        MethodInfo futMethod = this.genFutureMethod(method);
        this.startMethodTemplate(type, futMethod, "", writer);
        writer.println(" { ");
        writer.println("    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {");
        writer.print("      ");
        writer.print(method.getName());
        writer.print("(");
        writer.print(futMethod.getParams().stream().map(ParamInfo::getName).collect(Collectors.joining(", ")));
        if (futMethod.getParams().size() > 0) {
            writer.print(", ");
        }
        writer.println("fut);");
        writer.println("    }));");
        writer.println("  }");
        writer.println();
    }

    private MethodInfo genFutureMethod(MethodInfo method) {
        String futMethodName = this.genFutureMethodName(method);
        ArrayList<ParamInfo> futParams = new ArrayList<ParamInfo>();
        int size = method.getParams().size() - 1;
        for (int count = 0; count < size; ++count) {
            ParamInfo param = method.getParam(count);
            futParams.add(param);
        }
        ParamInfo futParam = method.getParam(size);
        TypeInfo futType = ((ParameterizedTypeInfo)((ParameterizedTypeInfo)futParam.getType()).getArg(0)).getArg(0);
        ParameterizedTypeInfo futReturnType = new ParameterizedTypeInfo(TypeReflectionFactory.create(Single.class).getRaw(), false, Collections.singletonList(futType));
        return method.copy().setName(futMethodName).setParams(futParams).setReturnType((TypeInfo)futReturnType);
    }

    private MethodInfo genOverloadedMethod(MethodInfo method) {
        ArrayList<ParamInfo> params = null;
        int count = 0;
        for (ParamInfo param : method.getParams()) {
            if (param.getType().isParameterized() && param.getType().getRaw().getName().equals("io.vertx.core.streams.ReadStream")) {
                if (params == null) {
                    params = new ArrayList<ParamInfo>(method.getParams());
                }
                ParameterizedTypeInfo paramType = new ParameterizedTypeInfo(TypeReflectionFactory.create(Observable.class).getRaw(), false, Collections.singletonList(((ParameterizedTypeInfo)param.getType()).getArg(0)));
                params.set(count, new ParamInfo(param.getIndex(), param.getName(), param.getDescription(), (TypeInfo)paramType));
            }
            ++count;
        }
        if (params != null) {
            return method.copy().setParams(params);
        }
        return null;
    }

    protected void genReadStream(List<? extends TypeParamInfo> typeParams, PrintWriter writer) {
        writer.print("  rx.Observable<");
        writer.print(typeParams.get(0).getName());
        writer.println("> toObservable();");
        writer.println();
    }
}

