/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.kafka.admin.impl;

import io.vertx.codegen.annotations.VertxGen;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.kafka.admin.AdminUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import kafka.admin.RackAwareMode;
import kafka.utils.ZKStringSerializer$;
import kafka.utils.ZkUtils;
import org.I0Itec.zkclient.ZkClient;
import org.I0Itec.zkclient.ZkConnection;
import org.I0Itec.zkclient.serialize.ZkSerializer;

@VertxGen
public class AdminUtilsImpl
implements AdminUtils {
    private Vertx vertx;
    private final String zookeeper;
    private final boolean isSecure;
    private int connectionTimeoutMs;
    private ZkUtils zkUtils;
    private boolean autoClose = false;

    public AdminUtilsImpl(Vertx vertx, String zookeeperHosts, int connectionTimeoutMs, boolean isSecure, boolean autoClose) {
        this.vertx = vertx;
        this.connectionTimeoutMs = connectionTimeoutMs;
        this.zookeeper = zookeeperHosts;
        this.isSecure = isSecure;
        this.autoClose = autoClose;
    }

    public AdminUtilsImpl(Vertx vertx, String zookeeperHosts) {
        this(vertx, zookeeperHosts, 8000, false, false);
    }

    public AdminUtilsImpl(Vertx vertx, String zookeeperHosts, boolean autoClose) {
        this(vertx, zookeeperHosts, 8000, false, autoClose);
    }

    @Override
    public void createTopic(String topicName, int partitionCount, int replicationFactor, Handler<AsyncResult<Void>> completionHandler) {
        this.createTopic(topicName, partitionCount, replicationFactor, new HashMap<String, String>(), completionHandler);
    }

    @Override
    public void createTopic(String topicName, int partitionCount, int replicationFactor, Map<String, String> topicConfig, Handler<AsyncResult<Void>> completionHandler) {
        Properties topicConfigProperties = new Properties();
        topicConfigProperties.putAll(topicConfig);
        this.vertx.executeBlocking(future -> {
            try {
                kafka.admin.AdminUtils.createTopic((ZkUtils)this.initZkClientAndGetZkUtils(), (String)topicName, (int)partitionCount, (int)replicationFactor, (Properties)topicConfigProperties, (RackAwareMode)kafka.admin.AdminUtils.createTopic$default$6());
                completionHandler.handle((Object)Future.succeededFuture());
            }
            catch (Exception e) {
                completionHandler.handle((Object)Future.failedFuture((String)e.getLocalizedMessage()));
            }
            finally {
                if (this.autoClose) {
                    this.zkUtils.close();
                }
            }
        }, r -> {});
    }

    @Override
    public void deleteTopic(String topicName, Handler<AsyncResult<Void>> completionHandler) {
        this.vertx.executeBlocking(future -> {
            try {
                kafka.admin.AdminUtils.deleteTopic((ZkUtils)this.initZkClientAndGetZkUtils(), (String)topicName);
                completionHandler.handle((Object)Future.succeededFuture());
                future.complete();
            }
            catch (Exception e) {
                completionHandler.handle((Object)Future.failedFuture((String)e.getLocalizedMessage()));
                future.fail((Throwable)e);
            }
            finally {
                if (this.autoClose) {
                    this.zkUtils.close();
                }
            }
        }, r -> {});
    }

    @Override
    public void topicExists(String topicName, Handler<AsyncResult<Boolean>> completionHandler) {
        this.vertx.executeBlocking(future -> {
            try {
                boolean exists = kafka.admin.AdminUtils.topicExists((ZkUtils)this.initZkClientAndGetZkUtils(), (String)topicName);
                completionHandler.handle((Object)Future.succeededFuture((Object)exists));
                future.complete();
            }
            catch (Exception e) {
                completionHandler.handle((Object)Future.failedFuture((String)e.getLocalizedMessage()));
                future.fail((Throwable)e);
            }
            finally {
                if (this.autoClose) {
                    this.zkUtils.close();
                }
            }
        }, r -> {});
    }

    @Override
    public void changeTopicConfig(String topicName, Map<String, String> topicConfig, Handler<AsyncResult<Void>> completionHandler) {
        Properties topicConfigProperties = new Properties();
        topicConfigProperties.putAll(topicConfig);
        this.vertx.executeBlocking(future -> {
            try {
                kafka.admin.AdminUtils.changeTopicConfig((ZkUtils)this.initZkClientAndGetZkUtils(), (String)topicName, (Properties)topicConfigProperties);
                completionHandler.handle((Object)Future.succeededFuture());
            }
            catch (Exception e) {
                completionHandler.handle((Object)Future.failedFuture((String)e.getLocalizedMessage()));
            }
            finally {
                if (this.autoClose) {
                    this.zkUtils.close();
                }
            }
        }, r -> {});
    }

    @Override
    public void close(Handler<AsyncResult<Void>> completionHandler) {
        this.vertx.executeBlocking(future -> {
            if (this.zkUtils != null) {
                this.zkUtils.close();
            }
            completionHandler.handle((Object)Future.succeededFuture());
            future.complete();
        }, r -> {});
    }

    private synchronized ZkUtils initZkClientAndGetZkUtils() {
        int sessionTimeoutMs = 10000;
        if (this.zkUtils == null) {
            this.zkUtils = new ZkUtils(new ZkClient(this.zookeeper, sessionTimeoutMs, this.connectionTimeoutMs, (ZkSerializer)ZKStringSerializer$.MODULE$), new ZkConnection(this.zookeeper), this.isSecure);
        }
        return this.zkUtils;
    }
}

