/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.client.session;

import java.io.IOException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.sshd.agent.common.AgentForwardSupport;
import org.apache.sshd.client.ClientFactoryManager;
import org.apache.sshd.client.session.AbstractClientSession;
import org.apache.sshd.client.session.ClientSession;
import org.apache.sshd.client.session.ClientSessionHolder;
import org.apache.sshd.common.PropertyResolverUtils;
import org.apache.sshd.common.SshException;
import org.apache.sshd.common.io.AbstractIoWriteFuture;
import org.apache.sshd.common.io.IoWriteFuture;
import org.apache.sshd.common.session.helpers.AbstractConnectionService;
import org.apache.sshd.common.util.buffer.Buffer;
import org.apache.sshd.server.x11.X11ForwardSupport;

public class ClientConnectionService
extends AbstractConnectionService<AbstractClientSession>
implements ClientSessionHolder {
    public ClientConnectionService(AbstractClientSession s) throws SshException {
        super(s);
    }

    @Override
    public final ClientSession getClientSession() {
        return (ClientSession)this.getSession();
    }

    @Override
    public void start() {
        ClientSession session = this.getClientSession();
        if (!session.isAuthenticated()) {
            throw new IllegalStateException("Session is not authenticated");
        }
        this.startHeartBeat();
    }

    protected void startHeartBeat() {
        ClientSession session = this.getClientSession();
        long interval = PropertyResolverUtils.getLongProperty(session, "hearbeat-interval", 0L);
        if (interval > 0L) {
            ClientFactoryManager manager = session.getFactoryManager();
            ScheduledExecutorService service = manager.getScheduledExecutorService();
            service.scheduleAtFixedRate(new Runnable(){

                @Override
                public void run() {
                    ClientConnectionService.this.sendHeartBeat();
                }
            }, interval, interval, TimeUnit.MILLISECONDS);
            if (this.log.isDebugEnabled()) {
                this.log.debug("startHeartbeat - started at interval={}", (Object)interval);
            }
        }
    }

    protected IoWriteFuture sendHeartBeat() {
        ClientSession session = this.getClientSession();
        String request = PropertyResolverUtils.getStringProperty(session, "heartbeat-request", "keepalive@sshd.apache.org");
        try {
            Buffer buf = session.createBuffer((byte)80, request.length() + 8);
            buf.putString(request);
            buf.putBoolean(false);
            return session.writePacket(buf);
        }
        catch (IOException e) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Error (" + e.getClass().getSimpleName() + ") sending keepalive message=" + request + ": " + e.getMessage());
            }
            final IOException t = e;
            return new AbstractIoWriteFuture(null){
                {
                    super(lock);
                    this.setValue(t);
                }
            };
        }
    }

    @Override
    public AgentForwardSupport getAgentForwardSupport() {
        throw new IllegalStateException("Server side operation");
    }

    @Override
    public X11ForwardSupport getX11ForwardSupport() {
        throw new IllegalStateException("Server side operation");
    }
}

