/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.sshd.common.Factory;
import org.apache.sshd.common.NamedResource;
import org.apache.sshd.common.OptionalFeature;
import org.apache.sshd.common.util.Transformer;

public interface NamedFactory<T>
extends Factory<T>,
NamedResource {

    public static final class Utils {
        private Utils() {
            throw new UnsupportedOperationException("No instance allowed");
        }

        public static <T> T create(Collection<? extends NamedFactory<T>> factories, String name) {
            NamedFactory<T> f = NamedResource.Utils.findByName(name, String.CASE_INSENSITIVE_ORDER, factories);
            if (f != null) {
                return f.create();
            }
            return null;
        }

        public static <S extends OptionalFeature, T, E extends NamedFactory<T>> List<NamedFactory<T>> setUpTransformedFactories(boolean ignoreUnsupported, Collection<? extends S> preferred, Transformer<? super S, ? extends E> xform) {
            ArrayList<NamedFactory<T>> avail = new ArrayList<NamedFactory<T>>(preferred.size());
            for (OptionalFeature f : preferred) {
                if (!ignoreUnsupported && !f.isSupported()) continue;
                avail.add((NamedFactory<T>)xform.transform(f));
            }
            return avail;
        }

        public static <T, E extends NamedFactory<T> & OptionalFeature> List<NamedFactory<T>> setUpBuiltinFactories(boolean ignoreUnsupported, Collection<? extends E> preferred) {
            ArrayList<NamedFactory<T>> avail = new ArrayList<NamedFactory<T>>(preferred.size());
            for (NamedFactory f : preferred) {
                if (!ignoreUnsupported && !((OptionalFeature)((Object)f)).isSupported()) continue;
                avail.add(f);
            }
            return avail;
        }
    }
}

