/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.channel;

import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.net.SocketException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.sshd.common.PropertyResolver;
import org.apache.sshd.common.PropertyResolverUtils;
import org.apache.sshd.common.channel.ChannelPipedSink;
import org.apache.sshd.common.channel.Window;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.buffer.Buffer;
import org.apache.sshd.common.util.buffer.ByteArrayBuffer;

public class ChannelPipedInputStream
extends InputStream
implements ChannelPipedSink {
    private final Window localWindow;
    private final Buffer buffer = new ByteArrayBuffer();
    private final byte[] b = new byte[1];
    private final AtomicBoolean open = new AtomicBoolean(true);
    private final AtomicBoolean eofSent = new AtomicBoolean(false);
    private final Lock lock = new ReentrantLock();
    private final Condition dataAvailable = this.lock.newCondition();
    private final AtomicBoolean writerClosed = new AtomicBoolean(false);
    private long timeout;

    public ChannelPipedInputStream(PropertyResolver resolver, Window localWindow) {
        this(localWindow, PropertyResolverUtils.getLongProperty(resolver, "window-timeout", 0L));
    }

    public ChannelPipedInputStream(Window localWindow, long windowTimeout) {
        this.localWindow = ValidateUtils.checkNotNull(localWindow, "No local window provided");
        this.timeout = windowTimeout;
    }

    @Override
    public boolean isOpen() {
        return this.open.get();
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public long getTimeout() {
        return this.timeout;
    }

    @Override
    public int available() throws IOException {
        this.lock.lock();
        try {
            int avail = this.buffer.available();
            if (avail == 0 && this.writerClosed.get()) {
                int n = -1;
                return n;
            }
            int n = avail;
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read() throws IOException {
        byte[] byArray = this.b;
        synchronized (this.b) {
            int l = this.read(this.b, 0, 1);
            if (l == -1) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return -1;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.b[0] & 0xFF;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        long startTime = System.currentTimeMillis();
        this.lock.lock();
        try {
            int index = 0;
            while (true) {
                boolean openState = this.isOpen();
                boolean writerClosedState = this.writerClosed.get();
                if (!openState && writerClosedState && this.eofSent.get() || !openState && !writerClosedState) {
                    throw new IOException("Pipe closed after " + index + " cycles");
                }
                if (this.buffer.available() > 0) break;
                if (this.writerClosed.get()) {
                    this.eofSent.set(true);
                    int n = -1;
                    return n;
                }
                try {
                    if (this.timeout > 0L) {
                        long remaining = this.timeout - (System.currentTimeMillis() - startTime);
                        if (remaining <= 0L) {
                            throw new SocketException("Timeout (" + this.timeout + ") exceeded after " + index + " cycles");
                        }
                        this.dataAvailable.await(remaining, TimeUnit.MILLISECONDS);
                    } else {
                        this.dataAvailable.await();
                    }
                }
                catch (InterruptedException e) {
                    throw (IOException)new InterruptedIOException("Interrupted at cycle #" + index + " while waiting for data to become available").initCause(e);
                }
                ++index;
            }
            if (len > this.buffer.available()) {
                len = this.buffer.available();
            }
            this.buffer.getRawBytes(b, off, len);
            if (this.buffer.rpos() > this.localWindow.getPacketSize() || this.buffer.available() == 0) {
                this.buffer.compact();
            }
        }
        finally {
            this.lock.unlock();
        }
        this.localWindow.consumeAndCheck(len);
        return len;
    }

    @Override
    public void eof() {
        this.lock.lock();
        try {
            this.writerClosed.set(true);
            this.dataAvailable.signalAll();
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void close() throws IOException {
        this.lock.lock();
        try {
            this.dataAvailable.signalAll();
        }
        finally {
            this.open.set(false);
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void receive(byte[] bytes, int off, int len) throws IOException {
        this.lock.lock();
        try {
            if (this.writerClosed.get() || !this.isOpen()) {
                throw new IOException("Pipe closed");
            }
            this.buffer.putRawBytes(bytes, off, len);
            this.dataAvailable.signalAll();
        }
        finally {
            this.lock.unlock();
        }
    }
}

