/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.channel;

import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.sshd.common.util.GenericUtils;

public enum PtyMode {
    VINTR(1),
    VQUIT(2),
    VERASE(3),
    VKILL(4),
    VEOF(5),
    VEOL(6),
    VEOL2(7),
    VSTART(8),
    VSTOP(9),
    VSUSP(10),
    VDSUSP(11),
    VREPRINT(12),
    VWERASE(13),
    VLNEXT(14),
    VFLUSH(15),
    VSWTCH(16),
    VSTATUS(17),
    VDISCARD(18),
    IGNPAR(30),
    PARMRK(31),
    INPCK(32),
    ISTRIP(33),
    INLCR(34),
    IGNCR(35),
    ICRNL(36),
    IUCLC(37),
    IXON(38),
    IXANY(39),
    IXOFF(40),
    IMAXBEL(41),
    ISIG(50),
    ICANON(51),
    XCASE(52),
    ECHO(53),
    ECHOE(54),
    ECHOK(55),
    ECHONL(56),
    NOFLSH(57),
    TOSTOP(58),
    IEXTEN(59),
    ECHOCTL(60),
    ECHOKE(61),
    PENDIN(62),
    OPOST(70),
    OLCUC(71),
    ONLCR(72),
    OCRNL(73),
    ONOCR(74),
    ONLRET(75),
    CS7(90),
    CS8(91),
    PARENB(92),
    PARODD(93),
    TTY_OP_ISPEED(128),
    TTY_OP_OSPEED(129);

    public static final byte TTY_OP_END = 0;
    public static final Integer FALSE_SETTING;
    public static final Integer TRUE_SETTING;
    public static final Set<PtyMode> MODES;
    private static final Map<Integer, PtyMode> COMMANDS;
    private int v;

    private PtyMode(int v) {
        this.v = v;
    }

    public int toInt() {
        return this.v;
    }

    public static PtyMode fromInt(int b) {
        return COMMANDS.get(0xFF & b);
    }

    public static Map<PtyMode, Integer> createEnabledOptions(PtyMode ... options) {
        return PtyMode.createEnabledOptions(GenericUtils.of((Enum[])options));
    }

    public static Map<PtyMode, Integer> createEnabledOptions(Collection<PtyMode> options) {
        if (GenericUtils.isEmpty(options)) {
            return Collections.emptyMap();
        }
        EnumMap<PtyMode, Integer> modes = new EnumMap<PtyMode, Integer>(PtyMode.class);
        for (PtyMode m : options) {
            modes.put(m, TRUE_SETTING);
        }
        return modes;
    }

    public static Set<PtyMode> resolveEnabledOptions(Map<PtyMode, ?> modes, PtyMode ... options) {
        return PtyMode.resolveEnabledOptions(modes, GenericUtils.of((Enum[])options));
    }

    public static Set<PtyMode> resolveEnabledOptions(Map<PtyMode, ?> modes, Collection<PtyMode> options) {
        if (GenericUtils.isEmpty(modes) || GenericUtils.isEmpty(options)) {
            return Collections.emptySet();
        }
        EnumSet<PtyMode> enabled = EnumSet.noneOf(PtyMode.class);
        for (PtyMode m : options) {
            if (!PtyMode.getBooleanSettingValue(modes, m)) continue;
            enabled.add(m);
        }
        return enabled;
    }

    public static boolean getBooleanSettingValue(Map<PtyMode, ?> modes, PtyMode m) {
        if (m == null || GenericUtils.isEmpty(modes)) {
            return false;
        }
        return PtyMode.getBooleanSettingValue(modes.get((Object)m));
    }

    public static boolean getBooleanSettingValue(Object v) {
        return v instanceof Number && PtyMode.getBooleanSettingValue(((Number)v).intValue());
    }

    public static boolean getBooleanSettingValue(int v) {
        return v != 0;
    }

    static {
        FALSE_SETTING = 0;
        TRUE_SETTING = 1;
        MODES = Collections.unmodifiableSet(EnumSet.allOf(PtyMode.class));
        COMMANDS = Collections.unmodifiableMap(new HashMap<Integer, PtyMode>(MODES.size()){
            private static final long serialVersionUID = 1L;
            {
                for (PtyMode c : PtyMode.values()) {
                    this.put(c.toInt(), c);
                }
            }
        });
    }
}

