/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.config.keys;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.KeyPairGenerator;
import java.security.interfaces.DSAParams;
import java.security.interfaces.DSAPrivateKey;
import java.security.interfaces.DSAPublicKey;
import java.security.spec.DSAPrivateKeySpec;
import java.security.spec.DSAPublicKeySpec;
import java.security.spec.InvalidKeySpecException;
import java.util.Collections;
import org.apache.sshd.common.config.keys.AbstractPublicKeyEntryDecoder;
import org.apache.sshd.common.util.SecurityUtils;
import org.apache.sshd.common.util.ValidateUtils;

public class DSSPublicKeyEntryDecoder
extends AbstractPublicKeyEntryDecoder<DSAPublicKey, DSAPrivateKey> {
    public static final DSSPublicKeyEntryDecoder INSTANCE = new DSSPublicKeyEntryDecoder();

    public DSSPublicKeyEntryDecoder() {
        super(DSAPublicKey.class, DSAPrivateKey.class, Collections.unmodifiableList(Collections.singletonList("ssh-dss")));
    }

    @Override
    public DSAPublicKey decodePublicKey(String keyType, InputStream keyData) throws IOException, GeneralSecurityException {
        if (!"ssh-dss".equals(keyType)) {
            throw new InvalidKeySpecException("Unepected key type: " + keyType);
        }
        BigInteger p = DSSPublicKeyEntryDecoder.decodeBigInt(keyData);
        BigInteger q = DSSPublicKeyEntryDecoder.decodeBigInt(keyData);
        BigInteger g = DSSPublicKeyEntryDecoder.decodeBigInt(keyData);
        BigInteger y = DSSPublicKeyEntryDecoder.decodeBigInt(keyData);
        return (DSAPublicKey)this.generatePublicKey(new DSAPublicKeySpec(y, p, q, g));
    }

    @Override
    public String encodePublicKey(OutputStream s, DSAPublicKey key) throws IOException {
        ValidateUtils.checkNotNull(key, "No public key provided");
        DSAParams keyParams = ValidateUtils.checkNotNull(key.getParams(), "No DSA params available");
        DSSPublicKeyEntryDecoder.encodeString(s, "ssh-dss");
        DSSPublicKeyEntryDecoder.encodeBigInt(s, keyParams.getP());
        DSSPublicKeyEntryDecoder.encodeBigInt(s, keyParams.getQ());
        DSSPublicKeyEntryDecoder.encodeBigInt(s, keyParams.getG());
        DSSPublicKeyEntryDecoder.encodeBigInt(s, key.getY());
        return "ssh-dss";
    }

    @Override
    public DSAPublicKey clonePublicKey(DSAPublicKey key) throws GeneralSecurityException {
        if (key == null) {
            return null;
        }
        DSAParams params = key.getParams();
        if (params == null) {
            throw new InvalidKeyException("Missing parameters in key");
        }
        return (DSAPublicKey)this.generatePublicKey(new DSAPublicKeySpec(key.getY(), params.getP(), params.getQ(), params.getG()));
    }

    @Override
    public DSAPrivateKey clonePrivateKey(DSAPrivateKey key) throws GeneralSecurityException {
        if (key == null) {
            return null;
        }
        DSAParams params = key.getParams();
        if (params == null) {
            throw new InvalidKeyException("Missing parameters in key");
        }
        return (DSAPrivateKey)this.generatePrivateKey(new DSAPrivateKeySpec(key.getX(), params.getP(), params.getQ(), params.getG()));
    }

    @Override
    public KeyPairGenerator getKeyPairGenerator() throws GeneralSecurityException {
        return SecurityUtils.getKeyPairGenerator("DSA");
    }

    @Override
    public KeyFactory getKeyFactoryInstance() throws GeneralSecurityException {
        return SecurityUtils.getKeyFactory("DSA");
    }
}

