/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.io.mina;

import java.io.IOException;
import java.net.SocketAddress;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.mina.core.service.IoProcessor;
import org.apache.mina.core.service.IoService;
import org.apache.mina.transport.socket.nio.NioSession;
import org.apache.mina.transport.socket.nio.NioSocketAcceptor;
import org.apache.sshd.common.FactoryManager;
import org.apache.sshd.common.PropertyResolverUtils;
import org.apache.sshd.common.io.IoAcceptor;
import org.apache.sshd.common.io.IoHandler;
import org.apache.sshd.common.io.mina.MinaService;

public class MinaAcceptor
extends MinaService
implements IoAcceptor,
org.apache.mina.core.service.IoHandler {
    public static final int DEFAULT_BACKLOG = 0;
    public static final boolean DEFAULT_REUSE_ADDRESS = true;
    protected final AtomicReference<org.apache.mina.core.service.IoAcceptor> acceptorHolder = new AtomicReference<Object>(null);
    protected int backlog = 0;
    protected boolean reuseAddress = true;

    public MinaAcceptor(FactoryManager manager, IoHandler handler, IoProcessor<NioSession> ioProcessor) {
        super(manager, handler, ioProcessor);
        this.backlog = PropertyResolverUtils.getIntProperty(manager, "socket-backlog", 0);
        this.reuseAddress = PropertyResolverUtils.getBooleanProperty(manager, "socket-reuseaddr", true);
    }

    protected org.apache.mina.core.service.IoAcceptor createAcceptor() {
        NioSocketAcceptor acceptor = new NioSocketAcceptor(this.ioProcessor);
        acceptor.setCloseOnDeactivation(false);
        acceptor.setReuseAddress(this.reuseAddress);
        acceptor.setBacklog(this.backlog);
        this.configure(acceptor.getSessionConfig());
        return acceptor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected org.apache.mina.core.service.IoAcceptor getAcceptor() {
        org.apache.mina.core.service.IoAcceptor acceptor;
        AtomicReference<org.apache.mina.core.service.IoAcceptor> atomicReference = this.acceptorHolder;
        synchronized (atomicReference) {
            acceptor = this.acceptorHolder.get();
            if (acceptor != null) {
                return acceptor;
            }
            acceptor = this.createAcceptor();
            acceptor.setHandler((org.apache.mina.core.service.IoHandler)this);
            this.acceptorHolder.set(acceptor);
        }
        this.log.debug("Created IoAcceptor");
        return acceptor;
    }

    @Override
    protected IoService getIoService() {
        return this.getAcceptor();
    }

    @Override
    public void bind(Collection<? extends SocketAddress> addresses) throws IOException {
        this.getAcceptor().bind(addresses);
    }

    @Override
    public void bind(SocketAddress address) throws IOException {
        this.getAcceptor().bind(address);
    }

    @Override
    public void unbind() {
        this.getAcceptor().unbind();
    }

    @Override
    public void unbind(Collection<? extends SocketAddress> addresses) {
        this.getAcceptor().unbind(addresses);
    }

    @Override
    public void unbind(SocketAddress address) {
        this.getAcceptor().unbind(address);
    }

    @Override
    public Set<SocketAddress> getBoundAddresses() {
        return this.getAcceptor().getLocalAddresses();
    }
}

