/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.kex;

import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PublicKey;
import java.security.interfaces.ECPublicKey;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.ECPublicKeySpec;
import javax.crypto.KeyAgreement;
import org.apache.sshd.common.cipher.ECCurves;
import org.apache.sshd.common.config.keys.ECDSAPublicKeyEntryDecoder;
import org.apache.sshd.common.digest.Digest;
import org.apache.sshd.common.kex.AbstractDH;
import org.apache.sshd.common.util.SecurityUtils;
import org.apache.sshd.common.util.ValidateUtils;

public class ECDH
extends AbstractDH {
    private ECParameterSpec params;
    private ECPoint e;
    private byte[] e_array;
    private ECPoint f;
    private KeyPairGenerator myKpairGen = SecurityUtils.getKeyPairGenerator("EC");
    private KeyAgreement myKeyAgree = SecurityUtils.getKeyAgreement("ECDH");

    public ECDH() throws Exception {
        this((ECParameterSpec)null);
    }

    public ECDH(String curveName) throws Exception {
        this(ValidateUtils.checkNotNull(ECCurves.fromCurveName(curveName), "Unknown curve name: %s", (Object)curveName));
    }

    public ECDH(ECCurves curve) throws Exception {
        this(ValidateUtils.checkNotNull(curve, "No known curve instance provided").getParameters());
    }

    public ECDH(ECParameterSpec paramSpec) throws Exception {
        this.params = paramSpec;
    }

    @Override
    public byte[] getE() throws Exception {
        if (this.e == null) {
            ValidateUtils.checkNotNull(this.params, "No ECParameterSpec(s)");
            this.myKpairGen.initialize(this.params);
            KeyPair myKpair = this.myKpairGen.generateKeyPair();
            this.myKeyAgree.init(myKpair.getPrivate());
            this.e = ((ECPublicKey)myKpair.getPublic()).getW();
            this.e_array = ECCurves.encodeECPoint(this.e, this.params);
        }
        return this.e_array;
    }

    @Override
    protected byte[] calculateK() throws Exception {
        ValidateUtils.checkNotNull(this.params, "No ECParameterSpec(s)");
        KeyFactory myKeyFac = SecurityUtils.getKeyFactory("EC");
        ECPublicKeySpec keySpec = new ECPublicKeySpec(this.f, this.params);
        PublicKey yourPubKey = myKeyFac.generatePublic(keySpec);
        this.myKeyAgree.doPhase(yourPubKey, true);
        return ECDH.stripLeadingZeroes(this.myKeyAgree.generateSecret());
    }

    public void setCurveParameters(ECParameterSpec paramSpec) {
        this.params = paramSpec;
    }

    @Override
    public void setF(byte[] f) {
        ValidateUtils.checkNotNull(this.params, "No ECParameterSpec(s)");
        this.f = ECDSAPublicKeyEntryDecoder.octetStringToEcPoint(f);
    }

    @Override
    public Digest getHash() throws Exception {
        ValidateUtils.checkNotNull(this.params, "No ECParameterSpec(s)");
        ECCurves curve = ValidateUtils.checkNotNull(ECCurves.fromCurveParameters(this.params), "Unknown curve parameters");
        return curve.getDigestForParams();
    }
}

