/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.keyprovider;

import java.security.KeyPair;
import java.util.ArrayList;
import java.util.List;
import org.apache.sshd.common.config.keys.KeyUtils;
import org.apache.sshd.common.keyprovider.KeyPairProvider;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.logging.AbstractLoggingBean;

public abstract class AbstractKeyPairProvider
extends AbstractLoggingBean
implements KeyPairProvider {
    protected AbstractKeyPairProvider() {
    }

    @Override
    public KeyPair loadKey(String type) {
        ValidateUtils.checkNotNullAndNotEmpty(type, "No key type to load");
        Iterable<KeyPair> keys = this.loadKeys();
        for (KeyPair key : keys) {
            String keyType = KeyUtils.getKeyType(key);
            if (!type.equals(keyType)) continue;
            return key;
        }
        return null;
    }

    public List<String> getKeyTypes() {
        ArrayList<String> types = new ArrayList<String>();
        Iterable<KeyPair> keys = this.loadKeys();
        for (KeyPair key : keys) {
            String type = KeyUtils.getKeyType(key);
            if (GenericUtils.isEmpty(type) || types.contains(type)) continue;
            types.add(type);
        }
        return types;
    }
}

