/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.util.buffer.keys;

import java.security.GeneralSecurityException;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.util.Arrays;
import java.util.Collection;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.buffer.Buffer;
import org.apache.sshd.common.util.buffer.keys.DSSBufferPublicKeyParser;
import org.apache.sshd.common.util.buffer.keys.ECBufferPublicKeyParser;
import org.apache.sshd.common.util.buffer.keys.RSABufferPublicKeyParser;

public interface BufferPublicKeyParser<PUB extends PublicKey> {
    public static final BufferPublicKeyParser<PublicKey> EMPTY = new BufferPublicKeyParser<PublicKey>(){

        @Override
        public boolean isKeyTypeSupported(String keyType) {
            return false;
        }

        @Override
        public PublicKey getRawPublicKey(String keyType, Buffer buffer) throws GeneralSecurityException {
            throw new NoSuchAlgorithmException(keyType);
        }

        public String toString() {
            return "EMPTY";
        }
    };

    public boolean isKeyTypeSupported(String var1);

    public PUB getRawPublicKey(String var1, Buffer var2) throws GeneralSecurityException;

    public static final class Utils {
        public static final BufferPublicKeyParser<PublicKey> DEFAULT = Utils.aggregate(Arrays.asList(RSABufferPublicKeyParser.INSTANCE, DSSBufferPublicKeyParser.INSTANCE, ECBufferPublicKeyParser.INSTANCE));

        private Utils() {
            throw new UnsupportedOperationException("No instance");
        }

        public static BufferPublicKeyParser<PublicKey> aggregate(final Collection<? extends BufferPublicKeyParser<? extends PublicKey>> parsers) {
            if (GenericUtils.isEmpty(parsers)) {
                return EMPTY;
            }
            return new BufferPublicKeyParser<PublicKey>(){

                @Override
                public boolean isKeyTypeSupported(String keyType) {
                    for (BufferPublicKeyParser p : parsers) {
                        if (!p.isKeyTypeSupported(keyType)) continue;
                        return true;
                    }
                    return false;
                }

                @Override
                public PublicKey getRawPublicKey(String keyType, Buffer buffer) throws GeneralSecurityException {
                    for (BufferPublicKeyParser p : parsers) {
                        if (!p.isKeyTypeSupported(keyType)) continue;
                        return p.getRawPublicKey(keyType, buffer);
                    }
                    throw new NoSuchAlgorithmException("No aggregate matcher for " + keyType);
                }

                public String toString() {
                    return String.valueOf(parsers);
                }
            };
        }
    }
}

