/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.util.closeable;

import java.util.Collections;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.sshd.common.Closeable;
import org.apache.sshd.common.future.CloseFuture;
import org.apache.sshd.common.future.SshFutureListener;
import org.apache.sshd.common.util.closeable.SimpleCloseable;

public class ParallelCloseable
extends SimpleCloseable {
    private final Iterable<? extends Closeable> closeables;

    public ParallelCloseable(Object lock, Iterable<? extends Closeable> closeables) {
        super(lock);
        this.closeables = closeables == null ? Collections.emptyList() : closeables;
    }

    @Override
    protected void doClose(final boolean immediately) {
        final AtomicInteger count = new AtomicInteger(1);
        SshFutureListener<CloseFuture> listener = new SshFutureListener<CloseFuture>(){

            @Override
            public void operationComplete(CloseFuture f) {
                int pendingCount = count.decrementAndGet();
                if (ParallelCloseable.this.log.isTraceEnabled()) {
                    ParallelCloseable.this.log.trace("doClose(" + immediately + ") completed pending: " + pendingCount);
                }
                if (pendingCount == 0) {
                    ParallelCloseable.this.future.setClosed();
                }
            }
        };
        for (Closeable closeable : this.closeables) {
            if (closeable == null) continue;
            int pendingCount = count.incrementAndGet();
            if (this.log.isTraceEnabled()) {
                this.log.trace("doClose(" + immediately + ") pending closeables: " + pendingCount);
            }
            closeable.close(immediately).addListener(listener);
        }
        listener.operationComplete(null);
    }
}

