/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.server.channel;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.sshd.client.future.DefaultOpenFuture;
import org.apache.sshd.client.future.OpenFuture;
import org.apache.sshd.common.FactoryManager;
import org.apache.sshd.common.channel.AbstractChannel;
import org.apache.sshd.common.channel.Channel;
import org.apache.sshd.common.channel.ChannelListener;
import org.apache.sshd.common.channel.RequestHandler;
import org.apache.sshd.common.channel.Window;
import org.apache.sshd.common.session.Session;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.buffer.Buffer;
import org.apache.sshd.server.channel.ServerChannel;
import org.apache.sshd.server.session.ServerSession;

public abstract class AbstractServerChannel
extends AbstractChannel
implements ServerChannel {
    protected final AtomicBoolean exitStatusSent = new AtomicBoolean(false);

    protected AbstractServerChannel() {
        this(Collections.emptyList());
    }

    protected AbstractServerChannel(Collection<? extends RequestHandler<Channel>> handlers) {
        this("", handlers);
    }

    protected AbstractServerChannel(String discriminator, Collection<? extends RequestHandler<Channel>> handlers) {
        super(discriminator, false, handlers);
    }

    @Override
    public ServerSession getServerSession() {
        return (ServerSession)this.getSession();
    }

    @Override
    public OpenFuture open(int recipient, int rwSize, int packetSize, Buffer buffer) {
        this.setRecipient(recipient);
        Session s = this.getSession();
        FactoryManager manager = ValidateUtils.checkNotNull(s.getFactoryManager(), "No factory manager");
        Window wRemote = this.getRemoteWindow();
        wRemote.init(rwSize, packetSize, manager.getProperties());
        this.configureWindow();
        return this.doInit(buffer);
    }

    @Override
    public void handleOpenSuccess(int recipient, int rwSize, int packetSize, Buffer buffer) throws IOException {
        throw new UnsupportedOperationException("handleOpenSuccess(" + recipient + "," + rwSize + "," + packetSize + ") N/A");
    }

    @Override
    public void handleOpenFailure(Buffer buffer) {
        throw new UnsupportedOperationException("handleOpenFailure() N/A");
    }

    protected OpenFuture doInit(Buffer buffer) {
        ChannelListener listener = this.getChannelListenerProxy();
        DefaultOpenFuture f = new DefaultOpenFuture(this);
        try {
            listener.channelOpenSuccess(this);
            f.setOpened();
        }
        catch (Throwable t) {
            Throwable e;
            block6: {
                e = GenericUtils.peelException(t);
                try {
                    listener.channelOpenFailure(this, e);
                }
                catch (Throwable err) {
                    Throwable[] suppressed;
                    Throwable ignored = GenericUtils.peelException(err);
                    this.log.warn("doInit({}) failed ({}) to inform listener of open failure={}: {}", new Object[]{this, ignored.getClass().getSimpleName(), e.getClass().getSimpleName(), ignored.getMessage()});
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("doInit(" + this + ") listener inform failure details", ignored);
                    }
                    if (!this.log.isTraceEnabled() || GenericUtils.length(suppressed = ignored.getSuppressed()) <= 0) break block6;
                    for (Throwable s : suppressed) {
                        this.log.trace("doInit(" + this + ") suppressed channel open failure signalling", s);
                    }
                }
            }
            f.setException(e);
        }
        return f;
    }

    protected void sendExitStatus(int v) throws IOException {
        if (this.exitStatusSent.getAndSet(true)) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("sendExitStatus({}) exit-status={} - already sent", (Object)this, (Object)v);
            }
            this.notifyStateChanged("exit-status");
            return;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("sendExitStatus({}) SSH_MSG_CHANNEL_REQUEST exit-status={}", (Object)this, (Object)v);
        }
        Session session = this.getSession();
        Buffer buffer = session.createBuffer((byte)98, 64);
        buffer.putInt(this.getRecipient());
        buffer.putString("exit-status");
        buffer.putBoolean(false);
        buffer.putInt(v);
        this.writePacket(buffer);
        this.notifyStateChanged("exit-status");
    }
}

