/*
 * Decompiled with CFR 0.152.
 */
package com.fizzed.rocker.runtime;

import com.fizzed.rocker.ContentType;
import com.fizzed.rocker.RockerOutputFactory;
import com.fizzed.rocker.runtime.AbstractRockerOutput;
import java.io.IOException;
import java.nio.charset.Charset;

public class StringBuilderOutput
extends AbstractRockerOutput<StringBuilderOutput> {
    public static RockerOutputFactory<StringBuilderOutput> FACTORY = new RockerOutputFactory<StringBuilderOutput>(){

        @Override
        public StringBuilderOutput create(ContentType contentType, String charsetName) {
            return new StringBuilderOutput(contentType, charsetName);
        }
    };
    private final StringBuilder buffer;

    public StringBuilderOutput(ContentType contentType, String charsetName) {
        super(contentType, charsetName, -1);
        this.buffer = new StringBuilder();
    }

    public StringBuilderOutput(ContentType contentType, String charsetName, int intialSize) {
        super(contentType, charsetName, -1);
        this.buffer = new StringBuilder(intialSize);
    }

    public StringBuilderOutput(ContentType contentType, Charset charset) {
        super(contentType, charset, -1);
        this.buffer = new StringBuilder();
    }

    public StringBuilderOutput(ContentType contentType, Charset charset, int intialSize) {
        super(contentType, charset, -1);
        this.buffer = new StringBuilder(intialSize);
    }

    public StringBuilder getBuffer() {
        return this.buffer;
    }

    @Override
    public StringBuilderOutput w(String string) throws IOException {
        this.buffer.append(string);
        return this;
    }

    @Override
    public StringBuilderOutput w(byte[] bytes) throws IOException {
        String s = new String(bytes, this.charset);
        this.buffer.append(s);
        return this;
    }

    @Override
    public String toString() {
        return this.buffer.toString();
    }
}

