/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.mongo;

import io.vertx.codegen.annotations.DataObject;
import io.vertx.core.json.JsonObject;

@DataObject
public class BulkOperation {
    private static final boolean DEFAULT_MULTI = false;
    private static final boolean DEFAULT_UPSERT = false;
    private BulkOperationType type;
    private JsonObject filter;
    private JsonObject document;
    private boolean upsert;
    private boolean multi;

    private BulkOperation(BulkOperationType type) {
        this.type = type;
        this.filter = null;
        this.document = null;
        this.upsert = false;
        this.multi = false;
    }

    public BulkOperation(JsonObject json) {
        String typeValue = json.getString("type");
        if (typeValue != null) {
            this.type = BulkOperationType.valueOf(typeValue.toUpperCase());
        }
        this.filter = json.getJsonObject("filter");
        this.document = json.getJsonObject("document");
        this.upsert = json.getBoolean("upsert");
        this.multi = json.getBoolean("multi");
    }

    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        json.put("type", (Enum)this.type);
        json.put("filter", this.filter);
        json.put("document", this.document);
        json.put("upsert", Boolean.valueOf(this.upsert));
        json.put("multi", Boolean.valueOf(this.multi));
        return json;
    }

    public static BulkOperation createDelete(JsonObject filter) {
        return new BulkOperation(BulkOperationType.DELETE).setFilter(filter);
    }

    public static BulkOperation createInsert(JsonObject document) {
        return new BulkOperation(BulkOperationType.INSERT).setDocument(document);
    }

    public static BulkOperation createReplace(JsonObject filter, JsonObject document) {
        return new BulkOperation(BulkOperationType.REPLACE).setFilter(filter).setDocument(document);
    }

    public static BulkOperation createReplace(JsonObject filter, JsonObject document, boolean upsert) {
        return new BulkOperation(BulkOperationType.REPLACE).setFilter(filter).setDocument(document).setUpsert(upsert);
    }

    public static BulkOperation createUpdate(JsonObject filter, JsonObject document) {
        return new BulkOperation(BulkOperationType.UPDATE).setFilter(filter).setDocument(document);
    }

    public static BulkOperation createUpdate(JsonObject filter, JsonObject document, boolean upsert, boolean multi) {
        return new BulkOperation(BulkOperationType.UPDATE).setFilter(filter).setDocument(document).setUpsert(upsert).setMulti(multi);
    }

    public BulkOperationType getType() {
        return this.type;
    }

    public BulkOperation setType(BulkOperationType type) {
        this.type = type;
        return this;
    }

    public JsonObject getFilter() {
        return this.filter;
    }

    public BulkOperation setFilter(JsonObject filter) {
        this.filter = filter;
        return this;
    }

    public JsonObject getDocument() {
        return this.document;
    }

    public BulkOperation setDocument(JsonObject document) {
        this.document = document;
        return this;
    }

    public boolean isUpsert() {
        return this.upsert;
    }

    public BulkOperation setUpsert(boolean upsert) {
        this.upsert = upsert;
        return this;
    }

    public boolean isMulti() {
        return this.multi;
    }

    public BulkOperation setMulti(boolean multi) {
        this.multi = multi;
        return this;
    }

    public static enum BulkOperationType {
        UPDATE,
        REPLACE,
        INSERT,
        DELETE;

    }
}

