/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.mongo.impl;

import com.mongodb.async.AsyncBatchCursor;
import com.mongodb.async.SingleResultCallback;
import com.mongodb.async.client.MongoIterable;
import io.vertx.core.Context;
import io.vertx.core.Handler;
import io.vertx.core.json.JsonObject;
import io.vertx.core.streams.ReadStream;
import io.vertx.core.streams.impl.InboundBuffer;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;

class MongoIterableStream
implements ReadStream<JsonObject> {
    private final Context context;
    private final MongoIterable<JsonObject> mongoIterable;
    private final int batchSize;
    private AsyncBatchCursor<JsonObject> batchCursor;
    private InboundBuffer<JsonObject> queue;
    private Handler<Throwable> exceptionHandler;
    private Handler<Void> endHandler;
    private boolean closed;

    MongoIterableStream(Context context, MongoIterable<JsonObject> mongoIterable, int batchSize) {
        this.context = context;
        this.mongoIterable = mongoIterable;
        this.batchSize = batchSize;
        this.queue = new InboundBuffer(context);
        this.queue.drainHandler(v -> this.doRead());
    }

    public synchronized MongoIterableStream exceptionHandler(Handler<Throwable> handler) {
        this.exceptionHandler = handler;
        return this;
    }

    public synchronized MongoIterableStream handler(Handler<JsonObject> handler) {
        this.queue.handler(handler);
        if (handler == null) {
            this.close();
        } else {
            SingleResultCallback callback = (result, t) -> this.context.runOnContext(v -> {
                MongoIterableStream mongoIterableStream = this;
                synchronized (mongoIterableStream) {
                    if (t != null) {
                        this.close();
                        this.handleException(t);
                    } else {
                        this.batchCursor = result;
                        this.batchCursor.setBatchSize(this.batchSize);
                        if (!this.closed) {
                            this.doRead();
                        }
                    }
                }
            });
            try {
                this.mongoIterable.batchCursor(callback);
            }
            catch (Exception e) {
                this.close();
                this.handleException(e);
            }
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MongoIterableStream pause() {
        MongoIterableStream mongoIterableStream = this;
        synchronized (mongoIterableStream) {
            if (this.closed) {
                return this;
            }
        }
        this.queue.pause();
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MongoIterableStream resume() {
        MongoIterableStream mongoIterableStream = this;
        synchronized (mongoIterableStream) {
            if (this.closed) {
                return this;
            }
        }
        this.queue.resume();
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ReadStream<JsonObject> fetch(long amount) {
        MongoIterableStream mongoIterableStream = this;
        synchronized (mongoIterableStream) {
            if (this.closed) {
                return this;
            }
        }
        this.queue.fetch(amount);
        return this;
    }

    private synchronized void doRead() {
        this.context.executeBlocking(fut -> this.batchCursor.next((result, t) -> {
            if (t != null) {
                fut.fail(t);
            } else {
                fut.complete(result);
            }
        }), true, ar -> {
            MongoIterableStream mongoIterableStream = this;
            synchronized (mongoIterableStream) {
                if (ar.succeeded()) {
                    List list = (List)ar.result();
                    if (list != null) {
                        if (this.queue.write((Iterable)list)) {
                            this.doRead();
                        }
                    } else {
                        this.close();
                        if (this.endHandler != null) {
                            this.endHandler.handle(null);
                        }
                    }
                } else {
                    this.close();
                    this.handleException(ar.cause());
                }
            }
        });
    }

    private void handleException(Throwable cause) {
        if (this.exceptionHandler != null) {
            this.exceptionHandler.handle((Object)cause);
        }
    }

    public synchronized MongoIterableStream endHandler(Handler<Void> handler) {
        this.endHandler = handler;
        return this;
    }

    private void close() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        AtomicReference cursorRef = new AtomicReference();
        this.context.executeBlocking(fut -> {
            MongoIterableStream mongoIterableStream = this;
            synchronized (mongoIterableStream) {
                cursorRef.set(this.batchCursor);
            }
            AsyncBatchCursor cursor = (AsyncBatchCursor)cursorRef.get();
            if (cursor != null) {
                cursor.close();
            }
            fut.complete();
        }, false, null);
    }
}

