/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.jvm.intrinsics;

import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.jvm.intrinsics.ArrayConstructor;
import org.jetbrains.kotlin.backend.jvm.intrinsics.ArrayGet;
import org.jetbrains.kotlin.backend.jvm.intrinsics.ArrayIterator;
import org.jetbrains.kotlin.backend.jvm.intrinsics.ArrayOf;
import org.jetbrains.kotlin.backend.jvm.intrinsics.ArraySet;
import org.jetbrains.kotlin.backend.jvm.intrinsics.ArraySize;
import org.jetbrains.kotlin.backend.jvm.intrinsics.BinaryOp;
import org.jetbrains.kotlin.backend.jvm.intrinsics.Clone;
import org.jetbrains.kotlin.backend.jvm.intrinsics.CompareTo;
import org.jetbrains.kotlin.backend.jvm.intrinsics.Concat;
import org.jetbrains.kotlin.backend.jvm.intrinsics.Equals;
import org.jetbrains.kotlin.backend.jvm.intrinsics.HashCode;
import org.jetbrains.kotlin.backend.jvm.intrinsics.Increment;
import org.jetbrains.kotlin.backend.jvm.intrinsics.IntrinsicMethod;
import org.jetbrains.kotlin.backend.jvm.intrinsics.IntrinsicsMap;
import org.jetbrains.kotlin.backend.jvm.intrinsics.Inv;
import org.jetbrains.kotlin.backend.jvm.intrinsics.IsArrayOf;
import org.jetbrains.kotlin.backend.jvm.intrinsics.IteratorNext;
import org.jetbrains.kotlin.backend.jvm.intrinsics.JavaClassProperty;
import org.jetbrains.kotlin.backend.jvm.intrinsics.KClassJavaProperty;
import org.jetbrains.kotlin.backend.jvm.intrinsics.MonitorInstruction;
import org.jetbrains.kotlin.backend.jvm.intrinsics.NewArray;
import org.jetbrains.kotlin.backend.jvm.intrinsics.Not;
import org.jetbrains.kotlin.backend.jvm.intrinsics.NumberCast;
import org.jetbrains.kotlin.backend.jvm.intrinsics.RangeTo;
import org.jetbrains.kotlin.backend.jvm.intrinsics.StringGetChar;
import org.jetbrains.kotlin.backend.jvm.intrinsics.StringPlus;
import org.jetbrains.kotlin.backend.jvm.intrinsics.ToString;
import org.jetbrains.kotlin.backend.jvm.intrinsics.TotalOrderEquals;
import org.jetbrains.kotlin.backend.jvm.intrinsics.UnaryMinus;
import org.jetbrains.kotlin.backend.jvm.intrinsics.UnaryPlus;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.builtins.PrimitiveType;
import org.jetbrains.kotlin.com.google.common.collect.ImmutableList;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.FqNameUnsafe;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.resolve.jvm.AsmTypes;
import org.jetbrains.kotlin.resolve.jvm.JvmPrimitiveType;
import org.jetbrains.kotlin.types.expressions.OperatorConventions;
import org.jetbrains.org.objectweb.asm.Type;

public class IntrinsicMethods {
    public static final String INTRINSICS_CLASS_NAME = "kotlin/jvm/internal/Intrinsics";
    private static final FqName KOTLIN_JVM = new FqName("kotlin.jvm");
    static final FqNameUnsafe RECEIVER_PARAMETER_FQ_NAME = new FqNameUnsafe("T");
    private static final IntrinsicMethod UNARY_MINUS = new UnaryMinus();
    private static final IntrinsicMethod UNARY_PLUS = new UnaryPlus();
    private static final IntrinsicMethod NUMBER_CAST = new NumberCast();
    private static final IntrinsicMethod INV = new Inv();
    private static final IntrinsicMethod RANGE_TO = new RangeTo();
    private static final IntrinsicMethod INC = new Increment(1);
    private static final IntrinsicMethod DEC = new Increment(-1);
    private static final IntrinsicMethod HASH_CODE = new HashCode();
    private static final IntrinsicMethod ARRAY_SIZE = new ArraySize();
    private static final Equals EQUALS = new Equals(KtTokens.EQEQ);
    private static final IteratorNext ITERATOR_NEXT = new IteratorNext();
    private static final ArraySet ARRAY_SET = new ArraySet();
    private static final ArrayGet ARRAY_GET = new ArrayGet();
    private static final StringPlus STRING_PLUS = new StringPlus();
    private static final ToString TO_STRING = new ToString();
    private static final Clone CLONE = new Clone();
    private static final IntrinsicMethod ARRAY_ITERATOR = new ArrayIterator();
    private final IntrinsicsMap intrinsicsMap = new IntrinsicsMap();

    public IntrinsicMethods() {
        this.intrinsicsMap.registerIntrinsic(KOTLIN_JVM, RECEIVER_PARAMETER_FQ_NAME, "javaClass", -1, JavaClassProperty.INSTANCE);
        this.intrinsicsMap.registerIntrinsic(KOTLIN_JVM, KotlinBuiltIns.FQ_NAMES.kClass, "java", -1, new KClassJavaProperty());
        this.intrinsicsMap.registerIntrinsic(new FqName("kotlin.jvm.internal.unsafe"), null, "monitorEnter", 1, MonitorInstruction.MONITOR_ENTER);
        this.intrinsicsMap.registerIntrinsic(new FqName("kotlin.jvm.internal.unsafe"), null, "monitorExit", 1, MonitorInstruction.MONITOR_EXIT);
        this.intrinsicsMap.registerIntrinsic(KOTLIN_JVM, KotlinBuiltIns.FQ_NAMES.array, "isArrayOf", 0, new IsArrayOf());
        this.intrinsicsMap.registerIntrinsic(KotlinBuiltIns.BUILT_INS_PACKAGE_FQ_NAME, null, "arrayOf", 1, new ArrayOf());
        ImmutableList<Name> primitiveCastMethods = OperatorConventions.NUMBER_CONVERSIONS.asList();
        for (Name method : primitiveCastMethods) {
            String methodName = method.asString();
            this.declareIntrinsicFunction(KotlinBuiltIns.FQ_NAMES.number, methodName, 0, NUMBER_CAST);
            for (PrimitiveType type2 : PrimitiveType.NUMBER_TYPES) {
                this.declareIntrinsicFunction(type2.getTypeFqName(), methodName, 0, NUMBER_CAST);
            }
        }
        for (PrimitiveType type3 : PrimitiveType.NUMBER_TYPES) {
            FqName typeFqName = type3.getTypeFqName();
            this.declareIntrinsicFunction(typeFqName, "plus", 0, UNARY_PLUS);
            this.declareIntrinsicFunction(typeFqName, "unaryPlus", 0, UNARY_PLUS);
            this.declareIntrinsicFunction(typeFqName, "minus", 0, UNARY_MINUS);
            this.declareIntrinsicFunction(typeFqName, "unaryMinus", 0, UNARY_MINUS);
            this.declareIntrinsicFunction(typeFqName, "inv", 0, INV);
            this.declareIntrinsicFunction(typeFqName, "rangeTo", 1, RANGE_TO);
            this.declareIntrinsicFunction(typeFqName, "inc", 0, INC);
            this.declareIntrinsicFunction(typeFqName, "dec", 0, DEC);
        }
        for (PrimitiveType type4 : PrimitiveType.values()) {
            FqName typeFqName = type4.getTypeFqName();
            Type asmPrimitiveType = AsmTypes.valueTypeForPrimitive(type4);
            if (asmPrimitiveType == Type.FLOAT_TYPE || asmPrimitiveType == Type.DOUBLE_TYPE) {
                this.declareIntrinsicFunction(typeFqName, "equals", 1, (IntrinsicMethod)new TotalOrderEquals(asmPrimitiveType));
            } else {
                this.declareIntrinsicFunction(typeFqName, "equals", 1, (IntrinsicMethod)EQUALS);
            }
            this.declareIntrinsicFunction(typeFqName, "hashCode", 0, HASH_CODE);
            this.declareIntrinsicFunction(typeFqName, "toString", 0, (IntrinsicMethod)TO_STRING);
            this.intrinsicsMap.registerIntrinsic(KotlinBuiltIns.BUILT_INS_PACKAGE_FQ_NAME, null, StringsKt.decapitalize((String)type4.getArrayTypeName().asString()) + "Of", 1, new ArrayOf());
        }
        this.declareBinaryOp("plus", 96);
        this.declareBinaryOp("minus", 100);
        this.declareBinaryOp("times", 104);
        this.declareBinaryOp("div", 108);
        this.declareBinaryOp("mod", 112);
        this.declareBinaryOp("rem", 112);
        this.declareBinaryOp("shl", 120);
        this.declareBinaryOp("shr", 122);
        this.declareBinaryOp("ushr", 124);
        this.declareBinaryOp("and", 126);
        this.declareBinaryOp("or", 128);
        this.declareBinaryOp("xor", 130);
        this.declareIntrinsicFunction(KotlinBuiltIns.FQ_NAMES._boolean, "not", 0, (IntrinsicMethod)new Not());
        this.declareIntrinsicFunction(KotlinBuiltIns.FQ_NAMES.string, "plus", 1, (IntrinsicMethod)new Concat());
        this.declareIntrinsicFunction(KotlinBuiltIns.FQ_NAMES.string, "get", 1, (IntrinsicMethod)new StringGetChar());
        this.declareIntrinsicFunction(KotlinBuiltIns.FQ_NAMES.cloneable, "clone", 0, (IntrinsicMethod)CLONE);
        this.intrinsicsMap.registerIntrinsic(KotlinBuiltIns.BUILT_INS_PACKAGE_FQ_NAME, KotlinBuiltIns.FQ_NAMES.any, "toString", 0, TO_STRING);
        this.intrinsicsMap.registerIntrinsic(KotlinBuiltIns.BUILT_INS_PACKAGE_FQ_NAME, KotlinBuiltIns.FQ_NAMES.string, "plus", 1, STRING_PLUS);
        this.intrinsicsMap.registerIntrinsic(KotlinBuiltIns.BUILT_INS_PACKAGE_FQ_NAME, null, "arrayOfNulls", 1, new NewArray());
        for (PrimitiveType type4 : PrimitiveType.values()) {
            this.declareIntrinsicFunction(type4.getTypeFqName(), "compareTo", 1, (IntrinsicMethod)new CompareTo());
            this.declareIntrinsicFunction(KotlinBuiltIns.COLLECTIONS_PACKAGE_FQ_NAME.child(Name.identifier(type4.getTypeName().asString() + "Iterator")), "next", 0, (IntrinsicMethod)ITERATOR_NEXT);
        }
        this.declareArrayMethods();
    }

    private void declareArrayMethods() {
        for (JvmPrimitiveType jvmPrimitiveType : JvmPrimitiveType.values()) {
            this.declareArrayMethods(jvmPrimitiveType.getPrimitiveType().getArrayTypeFqName());
        }
        this.declareArrayMethods(KotlinBuiltIns.FQ_NAMES.array.toSafe());
    }

    private void declareArrayMethods(@NotNull FqName arrayTypeFqName) {
        this.declareIntrinsicFunction(arrayTypeFqName, "size", -1, ARRAY_SIZE);
        this.declareIntrinsicFunction(arrayTypeFqName, "set", 2, (IntrinsicMethod)ARRAY_SET);
        this.declareIntrinsicFunction(arrayTypeFqName, "get", 1, (IntrinsicMethod)ARRAY_GET);
        this.declareIntrinsicFunction(arrayTypeFqName, "clone", 0, (IntrinsicMethod)CLONE);
        this.declareIntrinsicFunction(arrayTypeFqName, "iterator", 0, ARRAY_ITERATOR);
        this.declareIntrinsicFunction(arrayTypeFqName, "<init>", 2, (IntrinsicMethod)ArrayConstructor.INSTANCE);
    }

    private void declareBinaryOp(@NotNull String methodName, int opcode) {
        BinaryOp op2 = new BinaryOp(opcode);
        for (PrimitiveType type2 : PrimitiveType.values()) {
            this.declareIntrinsicFunction(type2.getTypeFqName(), methodName, 1, (IntrinsicMethod)op2);
        }
    }

    private void declareIntrinsicFunction(@NotNull FqName classFqName, @NotNull String methodName, int arity, @NotNull IntrinsicMethod implementation) {
        this.intrinsicsMap.registerIntrinsic(classFqName, null, methodName, arity, implementation);
    }

    private void declareIntrinsicFunction(@NotNull FqNameUnsafe classFqName, @NotNull String methodName, int arity, @NotNull IntrinsicMethod implementation) {
        this.intrinsicsMap.registerIntrinsic(classFqName.toSafe(), null, methodName, arity, implementation);
    }

    @Nullable
    public IntrinsicMethod getIntrinsic(@NotNull CallableMemberDescriptor descriptor2) {
        return this.intrinsicsMap.getIntrinsic(descriptor2);
    }
}

