/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.kotlinx.coroutines;

import java.util.concurrent.CancellationException;
import kotlin.ExceptionsKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.CoroutineContext;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.kotlinx.coroutines.CoroutineExceptionHandler;
import org.jetbrains.kotlin.kotlinx.coroutines.CoroutineExceptionHandlerImplKt;
import org.jetbrains.kotlin.kotlinx.coroutines.Job;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u0000\"\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u001a%\u0010\u0000\u001a\u00020\u00012\u001a\b\u0004\u0010\u0002\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0003H\u0086\b\u001a$\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\u00052\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0007\u00a8\u0006\f"}, d2={"CoroutineExceptionHandler", "Lorg/jetbrains/kotlin/kotlinx/coroutines/CoroutineExceptionHandler;", "handler", "Lkotlin/Function2;", "Lkotlin/coroutines/CoroutineContext;", "", "", "handleCoroutineException", "context", "exception", "caller", "Lorg/jetbrains/kotlin/kotlinx/coroutines/Job;", "kotlinx-coroutines-core"})
public final class CoroutineExceptionHandlerKt {
    /*
     * WARNING - void declaration
     */
    @JvmOverloads
    public static final void handleCoroutineException(@NotNull CoroutineContext context, @NotNull Throwable exception, @Nullable Job caller) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)exception, (String)"exception");
        try {
            if (exception instanceof CancellationException) {
                return;
            }
            Job parent2 = (Job)context.get((CoroutineContext.Key)Job.Key);
            if (parent2 != null && parent2 != caller && parent2.cancel(exception)) {
                return;
            }
            CoroutineExceptionHandler coroutineExceptionHandler = (CoroutineExceptionHandler)context.get((CoroutineContext.Key)CoroutineExceptionHandler.Key);
            if (coroutineExceptionHandler != null) {
                CoroutineExceptionHandler coroutineExceptionHandler2;
                CoroutineExceptionHandler it = coroutineExceptionHandler2 = coroutineExceptionHandler;
                it.handleException(context, exception);
                return;
            }
            CoroutineExceptionHandlerImplKt.handleCoroutineExceptionImpl(context, exception);
        }
        catch (Throwable handlerException) {
            void $receiver$iv;
            RuntimeException runtimeException;
            if (handlerException == exception) {
                throw exception;
            }
            RuntimeException $receiver = runtimeException = new RuntimeException("Exception while trying to handle coroutine exception", exception);
            Throwable $i$a$1$let = $receiver;
            Throwable other$iv = handlerException;
            ExceptionsKt.addSuppressed((Throwable)$receiver$iv, (Throwable)other$iv);
            throw (Throwable)runtimeException;
        }
    }

    @JvmOverloads
    public static /* synthetic */ void handleCoroutineException$default(CoroutineContext coroutineContext, Throwable throwable, Job job, int n, Object object) {
        if ((n & 4) != 0) {
            job = null;
        }
        CoroutineExceptionHandlerKt.handleCoroutineException(coroutineContext, throwable, job);
    }

    @JvmOverloads
    public static final void handleCoroutineException(@NotNull CoroutineContext context, @NotNull Throwable exception) {
        CoroutineExceptionHandlerKt.handleCoroutineException$default(context, exception, null, 4, null);
    }

    @NotNull
    public static final CoroutineExceptionHandler CoroutineExceptionHandler(@NotNull Function2<? super CoroutineContext, ? super Throwable, Unit> handler2) {
        Intrinsics.checkParameterIsNotNull(handler2, (String)"handler");
        return new CoroutineExceptionHandler(handler2, CoroutineExceptionHandler.Key){
            final /* synthetic */ Function2 $handler;

            public void handleException(@NotNull CoroutineContext context, @NotNull Throwable exception) {
                Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
                Intrinsics.checkParameterIsNotNull((Object)exception, (String)"exception");
                this.$handler.invoke((Object)context, (Object)exception);
            }
            {
                this.$handler = $captured_local_variable$0;
                super($super_call_param$1);
            }
        };
    }
}

