/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.lang.groovy.fastclasspathscanner.scanner;

import io.vertx.lang.groovy.fastclasspathscanner.scanner.ScanResult;
import io.vertx.lang.groovy.fastclasspathscanner.utils.ReflectionUtils;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class FieldInfo
implements Comparable<FieldInfo> {
    private final String className;
    private final String fieldName;
    private final int modifiers;
    private final String typeDescriptor;
    private final Object constValue;
    private final List<String> annotationNames;
    ScanResult scanResult;

    public FieldInfo(String className, String fieldName, int modifiers, String typeDescriptor, Object constValue, List<String> annotationNames) {
        this.className = className;
        this.fieldName = fieldName;
        this.modifiers = modifiers;
        this.typeDescriptor = typeDescriptor;
        this.constValue = constValue;
        this.annotationNames = annotationNames.isEmpty() ? Collections.emptyList() : annotationNames;
    }

    public String getClassName() {
        return this.className;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public String getModifiers() {
        return ReflectionUtils.modifiersToString(this.modifiers, false);
    }

    public boolean isPublic() {
        return Modifier.isPublic(this.modifiers);
    }

    public boolean isPrivate() {
        return Modifier.isPrivate(this.modifiers);
    }

    public boolean isProtected() {
        return Modifier.isProtected(this.modifiers);
    }

    public boolean isPackagePrivate() {
        return !this.isPublic() && !this.isPrivate() && !this.isProtected();
    }

    public boolean isStatic() {
        return Modifier.isStatic(this.modifiers);
    }

    public boolean isFinal() {
        return Modifier.isFinal(this.modifiers);
    }

    public boolean isTransient() {
        return Modifier.isTransient(this.modifiers);
    }

    public int getAccessFlags() {
        return this.modifiers;
    }

    public String getTypeDescriptor() {
        return this.typeDescriptor;
    }

    public String getTypeStr() {
        List<String> typeNames = ReflectionUtils.parseTypeDescriptor(this.typeDescriptor);
        if (typeNames.size() != 1) {
            throw new IllegalArgumentException("Invalid type descriptor for field: " + this.typeDescriptor);
        }
        return typeNames.get(0);
    }

    public Class<?> getType() throws IllegalArgumentException {
        return ReflectionUtils.typeStrToClass(this.getTypeStr(), this.scanResult);
    }

    public Object getConstFinalValue() {
        return this.constValue;
    }

    public List<String> getAnnotationNames() {
        return this.annotationNames;
    }

    public List<Class<?>> getAnnotationTypes() throws IllegalArgumentException {
        if (this.annotationNames.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList annotationClassRefs = new ArrayList();
        for (String annotationName : this.annotationNames) {
            annotationClassRefs.add(ReflectionUtils.typeStrToClass(annotationName, this.scanResult));
        }
        return annotationClassRefs;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FieldInfo other = (FieldInfo)obj;
        return this.className.equals(other.className) && this.fieldName.equals(other.fieldName);
    }

    public int hashCode() {
        return this.fieldName.hashCode() + this.className.hashCode() * 11;
    }

    @Override
    public int compareTo(FieldInfo other) {
        int diff = this.className.compareTo(other.className);
        if (diff != 0) {
            return diff;
        }
        return this.fieldName.compareTo(other.fieldName);
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        if (!this.annotationNames.isEmpty()) {
            for (String annotationName : this.annotationNames) {
                if (buf.length() > 0) {
                    buf.append(' ');
                }
                buf.append("@" + annotationName);
            }
        }
        if (buf.length() > 0) {
            buf.append(' ');
        }
        buf.append(this.getModifiers());
        if (buf.length() > 0) {
            buf.append(' ');
        }
        buf.append(this.getTypeStr());
        buf.append(' ');
        buf.append(this.fieldName);
        if (this.constValue != null) {
            buf.append(" = ");
            if (this.constValue instanceof String) {
                buf.append("\"" + this.constValue + "\"");
            } else if (this.constValue instanceof Character) {
                buf.append("'" + this.constValue + "'");
            } else {
                buf.append(this.constValue.toString());
            }
        }
        return buf.toString();
    }
}

