/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.lang.groovy.fastclasspathscanner.utils;

import io.vertx.lang.groovy.fastclasspathscanner.FastClasspathScanner;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;

public class VersionFinder {
    private static final String MAVEN_PACKAGE = "io.github.lukehutch";
    private static final String MAVEN_ARTIFACT = "fast-classpath-scanner";

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static final synchronized String getVersion() {
        Object classfileName;
        Class<FastClasspathScanner> cls;
        block41: {
            cls = FastClasspathScanner.class;
            try {
                int i;
                String className = cls.getName();
                classfileName = "/" + className.replace('.', '/') + ".class";
                URL classpathResource = cls.getResource((String)classfileName);
                if (classpathResource == null) break block41;
                Path absolutePackagePath = Paths.get(classpathResource.toURI()).getParent();
                int packagePathSegments = className.length() - className.replace(".", "").length();
                Path path = absolutePackagePath;
                int segmentsToRemove = packagePathSegments;
                for (i = 0; i < segmentsToRemove && path != null; path = path.getParent(), ++i) {
                }
                for (i = 0; i < 3 && path != null; ++i, path = path.getParent()) {
                    Path pom = path.resolve("pom.xml");
                    try (InputStream is = Files.newInputStream(pom, new OpenOption[0]);){
                        Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(is);
                        doc.getDocumentElement().normalize();
                        String version = (String)XPathFactory.newInstance().newXPath().compile("/project/version").evaluate(doc, XPathConstants.STRING);
                        if (version == null || (version = version.trim()).isEmpty()) continue;
                        String string = version;
                        return string;
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
            catch (Exception className) {
                // empty catch block
            }
        }
        try {
            InputStream is = cls.getResourceAsStream("/META-INF/maven/io.github.lukehutch/fast-classpath-scanner/pom.properties");
            classfileName = null;
            try {
                if (is != null) {
                    Properties p = new Properties();
                    p.load(is);
                    String version = p.getProperty("version", "").trim();
                    if (!version.isEmpty()) {
                        String string = version;
                        return string;
                    }
                }
            }
            catch (Throwable throwable) {
                classfileName = throwable;
                throw throwable;
            }
            finally {
                if (is != null) {
                    if (classfileName != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)classfileName).addSuppressed(throwable);
                        }
                    } else {
                        is.close();
                    }
                }
            }
        }
        catch (Exception is) {
            // empty catch block
        }
        Package pkg = cls.getPackage();
        if (pkg == null) return "unknown";
        String version = pkg.getImplementationVersion();
        if (version == null) {
            version = "";
        }
        if ((version = version.trim()).isEmpty()) {
            version = pkg.getSpecificationVersion();
            if (version == null) {
                version = "";
            }
            version = version.trim();
        }
        if (version.isEmpty()) return "unknown";
        return version;
    }
}

