/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.client.impl;

import io.vertx.core.http.CaseInsensitiveHeaders;
import io.vertx.ext.web.client.WebClient;
import io.vertx.ext.web.client.WebClientSession;
import io.vertx.ext.web.client.impl.SessionAwareInterceptor;
import io.vertx.ext.web.client.impl.WebClientBase;
import io.vertx.ext.web.client.spi.CookieStore;

public class WebClientSessionAware
extends WebClientBase
implements WebClientSession {
    private final CookieStore cookieStore;
    private CaseInsensitiveHeaders headers;

    public WebClientSessionAware(WebClient webClient, CookieStore cookieStore) {
        super((WebClientBase)webClient);
        this.cookieStore = cookieStore;
        this.addInterceptor(new SessionAwareInterceptor());
    }

    @Override
    public CookieStore cookieStore() {
        return this.cookieStore;
    }

    protected CaseInsensitiveHeaders headers() {
        if (this.headers == null) {
            this.headers = new CaseInsensitiveHeaders();
        }
        return this.headers;
    }

    @Override
    public WebClientSession setHeader(CharSequence name, CharSequence value) {
        this.headers().add(name, value);
        return this;
    }

    @Override
    public WebClientSession setHeader(String name, String value) {
        this.headers().add(name, value);
        return this;
    }

    @Override
    public WebClientSession setHeader(CharSequence name, Iterable<CharSequence> values) {
        this.headers().add(name, values);
        return this;
    }

    @Override
    public WebClientSession setHeader(String name, Iterable<String> values) {
        this.headers().add(name, values);
        return this;
    }

    @Override
    public WebClientSession removeHeader(CharSequence name) {
        this.headers().remove(name);
        return this;
    }

    @Override
    public WebClientSession removeHeader(String name) {
        this.headers().remove(name);
        return this;
    }
}

