/*
 * Decompiled with CFR 0.152.
 */
package org.attoparser.trace;

import java.util.Arrays;

public abstract class MarkupTraceEvent {
    private final EventType eventType;
    final String[] contents;
    final int[] lines;
    final int[] cols;

    private MarkupTraceEvent(EventType eventType, int[] lines, int[] cols, String ... contents) {
        if (eventType == null) {
            throw new IllegalArgumentException("Event type cannot be null");
        }
        this.eventType = eventType;
        this.contents = contents;
        this.lines = lines;
        this.cols = cols;
    }

    public EventType getEventType() {
        return this.eventType;
    }

    public String toString() {
        StringBuilder strBuilder = new StringBuilder();
        strBuilder.append((Object)this.eventType);
        if (this.contents != null && this.lines != null & this.lines.length == this.contents.length) {
            for (int i = 0; i < this.contents.length; ++i) {
                strBuilder.append('(');
                if (this.contents[i] != null) {
                    strBuilder.append(this.contents[i]);
                }
                strBuilder.append(')');
                strBuilder.append('{');
                strBuilder.append(String.valueOf(this.lines[i]));
                strBuilder.append(',');
                strBuilder.append(String.valueOf(this.cols[i]));
                strBuilder.append('}');
            }
            return strBuilder.toString();
        }
        if (this.contents != null) {
            for (String contentItem : this.contents) {
                strBuilder.append('(');
                if (contentItem != null) {
                    strBuilder.append(contentItem);
                }
                strBuilder.append(')');
            }
        }
        strBuilder.append('{');
        strBuilder.append(String.valueOf(this.lines[0]));
        strBuilder.append(',');
        strBuilder.append(String.valueOf(this.cols[0]));
        strBuilder.append('}');
        return strBuilder.toString();
    }

    public boolean matchesTypeAndContent(MarkupTraceEvent event) {
        if (this == event) {
            return true;
        }
        if (event == null) {
            return false;
        }
        if (this.eventType == null ? event.eventType != null : !this.eventType.equals((Object)event.eventType)) {
            return false;
        }
        return !(this.contents == null ? event.contents != null : !Arrays.equals(this.contents, event.contents));
    }

    public int hashCode() {
        int result = this.eventType.hashCode();
        result = 31 * result + Arrays.hashCode(this.contents);
        result = 31 * result + Arrays.hashCode(this.lines);
        result = 31 * result + Arrays.hashCode(this.cols);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MarkupTraceEvent that = (MarkupTraceEvent)o;
        if (!Arrays.equals(this.cols, that.cols)) {
            return false;
        }
        if (!Arrays.equals(this.contents, that.contents)) {
            return false;
        }
        if (!Arrays.equals(this.lines, that.lines)) {
            return false;
        }
        return this.eventType == that.eventType;
    }

    public static final class ProcessingInstructionTraceEvent
    extends MarkupTraceEvent {
        public ProcessingInstructionTraceEvent(String target, int targetLine, int targetCol, String content, int contentLine, int contentCol) {
            super(EventType.PROCESSING_INSTRUCTION, new int[]{targetLine, contentLine}, new int[]{targetCol, contentCol}, new String[]{target, content});
            if (target == null || target.trim().equals("")) {
                throw new IllegalArgumentException("Target cannot be null or empty");
            }
        }

        public String getTarget() {
            return this.contents[0];
        }

        public String getContent() {
            return this.contents[1];
        }

        public int getTargetLine() {
            return this.lines[0];
        }

        public int getContentLine() {
            return this.lines[1];
        }

        public int getTargetCol() {
            return this.lines[0];
        }

        public int getContentCol() {
            return this.lines[1];
        }
    }

    public static final class DocTypeTraceEvent
    extends MarkupTraceEvent {
        public DocTypeTraceEvent(String keyword, int keywordLine, int keywordCol, String elementName, int elementNameLine, int elementNameCol, String type, int typeLine, int typeCol, String publicId, int publicIdLine, int publicIdCol, String systemId, int systemIdLine, int systemIdCol, String internalSubset, int internalSubsetLine, int internalSubsetCol) {
            super(EventType.DOC_TYPE, new int[]{keywordLine, elementNameLine, typeLine, publicIdLine, systemIdLine, internalSubsetLine}, new int[]{keywordCol, elementNameCol, typeCol, publicIdCol, systemIdCol, internalSubsetCol}, new String[]{keyword, elementName, type, publicId, systemId, internalSubset});
            if (keyword == null || keyword.trim().equals("")) {
                throw new IllegalArgumentException("Keyword cannot be null or empty");
            }
        }

        public String getKeyword() {
            return this.contents[0];
        }

        public String getElementName() {
            return this.contents[1];
        }

        public String getType() {
            return this.contents[2];
        }

        public String getPublicId() {
            return this.contents[3];
        }

        public String getSystemId() {
            return this.contents[4];
        }

        public String getInternalSubset() {
            return this.contents[5];
        }

        public int getKeywordLine() {
            return this.lines[0];
        }

        public int getElementNameLine() {
            return this.lines[1];
        }

        public int getTypeLine() {
            return this.lines[2];
        }

        public int getPublicIdLine() {
            return this.lines[3];
        }

        public int getSystemIdLine() {
            return this.lines[4];
        }

        public int getInternalSubsetLine() {
            return this.lines[5];
        }

        public int getKeywordCol() {
            return this.lines[0];
        }

        public int getElementNameCol() {
            return this.lines[1];
        }

        public int getTypeCol() {
            return this.lines[2];
        }

        public int getPublicIdCol() {
            return this.lines[3];
        }

        public int getSystemIdCol() {
            return this.lines[4];
        }

        public int getInternalSubsetCol() {
            return this.lines[5];
        }
    }

    public static final class XmlDeclarationTraceEvent
    extends MarkupTraceEvent {
        public XmlDeclarationTraceEvent(String keyword, int keywordLine, int keywordCol, String version, int versionLine, int versionCol, String encoding, int encodingLine, int encodingCol, String standalone, int standaloneLine, int standaloneCol) {
            super(EventType.XML_DECLARATION, new int[]{keywordLine, versionLine, encodingLine, standaloneLine}, new int[]{keywordCol, versionCol, encodingCol, standaloneCol}, new String[]{keyword, version, encoding, standalone});
            if (keyword == null || keyword.trim().equals("")) {
                throw new IllegalArgumentException("Keyword cannot be null or empty");
            }
        }

        public String getKeyword() {
            return this.contents[0];
        }

        public String getVersion() {
            return this.contents[1];
        }

        public String getEncoding() {
            return this.contents[2];
        }

        public String getStandalone() {
            return this.contents[3];
        }

        public int getKeywordLine() {
            return this.lines[0];
        }

        public int getVersionLine() {
            return this.lines[1];
        }

        public int getEncodingLine() {
            return this.lines[2];
        }

        public int getStandaloneLine() {
            return this.lines[3];
        }

        public int getKeywordCol() {
            return this.lines[0];
        }

        public int getVersionCol() {
            return this.lines[1];
        }

        public int getEncodingCol() {
            return this.lines[2];
        }

        public int getStandaloneCol() {
            return this.lines[3];
        }
    }

    public static final class AttributeTraceEvent
    extends MarkupTraceEvent {
        public AttributeTraceEvent(String name, int nameLine, int nameCol, String operator, int operatorLine, int operatorCol, String outerValue, int valueLine, int valueCol) {
            super(EventType.ATTRIBUTE, new int[]{nameLine, operatorLine, valueLine}, new int[]{nameCol, operatorCol, valueCol}, new String[]{name, operator, outerValue});
            if (name == null || name.trim().equals("")) {
                throw new IllegalArgumentException("Attribute name cannot be null or empty");
            }
        }

        public String getName() {
            return this.contents[0];
        }

        public String getOperator() {
            return this.contents[1];
        }

        public String getOuterValue() {
            return this.contents[2];
        }

        public int getNameLine() {
            return this.lines[0];
        }

        public int getNameCol() {
            return this.cols[0];
        }

        public int getOperatorLine() {
            return this.lines[1];
        }

        public int getOperatorCol() {
            return this.cols[1];
        }

        public int getOuterValueLine() {
            return this.lines[2];
        }

        public int getOuterValueCol() {
            return this.cols[2];
        }
    }

    public static final class UnmatchedCloseElementEndTraceEvent
    extends AbstractElementTraceEvent {
        public UnmatchedCloseElementEndTraceEvent(String elementName, int line, int col) {
            super(EventType.UNMATCHED_CLOSE_ELEMENT_END, elementName, line, col);
        }
    }

    public static final class UnmatchedCloseElementStartTraceEvent
    extends AbstractElementTraceEvent {
        public UnmatchedCloseElementStartTraceEvent(String elementName, int line, int col) {
            super(EventType.UNMATCHED_CLOSE_ELEMENT_START, elementName, line, col);
        }
    }

    public static final class AutoCloseElementEndTraceEvent
    extends AbstractElementTraceEvent {
        public AutoCloseElementEndTraceEvent(String elementName, int line, int col) {
            super(EventType.AUTO_CLOSE_ELEMENT_END, elementName, line, col);
        }
    }

    public static final class AutoCloseElementStartTraceEvent
    extends AbstractElementTraceEvent {
        public AutoCloseElementStartTraceEvent(String elementName, int line, int col) {
            super(EventType.AUTO_CLOSE_ELEMENT_START, elementName, line, col);
        }
    }

    public static final class CloseElementEndTraceEvent
    extends AbstractElementTraceEvent {
        public CloseElementEndTraceEvent(String elementName, int line, int col) {
            super(EventType.CLOSE_ELEMENT_END, elementName, line, col);
        }
    }

    public static final class CloseElementStartTraceEvent
    extends AbstractElementTraceEvent {
        public CloseElementStartTraceEvent(String elementName, int line, int col) {
            super(EventType.CLOSE_ELEMENT_START, elementName, line, col);
        }
    }

    public static final class AutoOpenElementEndTraceEvent
    extends AbstractElementTraceEvent {
        public AutoOpenElementEndTraceEvent(String elementName, int line, int col) {
            super(EventType.AUTO_OPEN_ELEMENT_END, elementName, line, col);
        }
    }

    public static final class AutoOpenElementStartTraceEvent
    extends AbstractElementTraceEvent {
        public AutoOpenElementStartTraceEvent(String elementName, int line, int col) {
            super(EventType.AUTO_OPEN_ELEMENT_START, elementName, line, col);
        }
    }

    public static final class OpenElementEndTraceEvent
    extends AbstractElementTraceEvent {
        public OpenElementEndTraceEvent(String elementName, int line, int col) {
            super(EventType.OPEN_ELEMENT_END, elementName, line, col);
        }
    }

    public static final class OpenElementStartTraceEvent
    extends AbstractElementTraceEvent {
        public OpenElementStartTraceEvent(String elementName, int line, int col) {
            super(EventType.OPEN_ELEMENT_START, elementName, line, col);
        }
    }

    public static final class NonMinimizedStandaloneElementEndTraceEvent
    extends AbstractElementTraceEvent {
        public NonMinimizedStandaloneElementEndTraceEvent(String elementName, int line, int col) {
            super(EventType.NON_MINIMIZED_STANDALONE_ELEMENT_END, elementName, line, col);
        }
    }

    public static final class NonMinimizedStandaloneElementStartTraceEvent
    extends AbstractElementTraceEvent {
        public NonMinimizedStandaloneElementStartTraceEvent(String elementName, int line, int col) {
            super(EventType.NON_MINIMIZED_STANDALONE_ELEMENT_START, elementName, line, col);
        }
    }

    public static final class StandaloneElementEndTraceEvent
    extends AbstractElementTraceEvent {
        public StandaloneElementEndTraceEvent(String elementName, int line, int col) {
            super(EventType.STANDALONE_ELEMENT_END, elementName, line, col);
        }
    }

    public static final class StandaloneElementStartTraceEvent
    extends AbstractElementTraceEvent {
        public StandaloneElementStartTraceEvent(String elementName, int line, int col) {
            super(EventType.STANDALONE_ELEMENT_START, elementName, line, col);
        }
    }

    static abstract class AbstractElementTraceEvent
    extends MarkupTraceEvent {
        protected AbstractElementTraceEvent(EventType type, String elementName, int line, int col) {
            super(type, new int[]{line}, new int[]{col}, new String[]{elementName});
            if (elementName == null || elementName.trim().equals("")) {
                throw new IllegalArgumentException("Element name cannot be null or empty");
            }
        }

        public String getElementName() {
            return this.contents[0];
        }

        public int getLine() {
            return this.lines[0];
        }

        public int getCol() {
            return this.cols[0];
        }
    }

    public static final class InnerWhiteSpaceTraceEvent
    extends AbstractContentTraceEvent {
        public InnerWhiteSpaceTraceEvent(String content, int line, int col) {
            super(EventType.INNER_WHITE_SPACE, content, line, col);
        }
    }

    public static final class CDATASectionTraceEvent
    extends AbstractContentTraceEvent {
        public CDATASectionTraceEvent(String content, int line, int col) {
            super(EventType.CDATA_SECTION, content, line, col);
        }
    }

    public static final class CommentTraceEvent
    extends AbstractContentTraceEvent {
        public CommentTraceEvent(String content, int line, int col) {
            super(EventType.COMMENT, content, line, col);
        }
    }

    public static final class TextTraceEvent
    extends AbstractContentTraceEvent {
        public TextTraceEvent(String content, int line, int col) {
            super(EventType.TEXT, content, line, col);
        }
    }

    static abstract class AbstractContentTraceEvent
    extends MarkupTraceEvent {
        protected AbstractContentTraceEvent(EventType type, String content, int line, int col) {
            super(type, new int[]{line}, new int[]{col}, new String[]{content});
            if (content == null) {
                throw new IllegalArgumentException("Contentn cannot be null");
            }
        }

        public String getContent() {
            return this.contents[0];
        }

        public int getLine() {
            return this.lines[0];
        }

        public int getCol() {
            return this.cols[0];
        }
    }

    public static final class DocumentEndTraceEvent
    extends MarkupTraceEvent {
        public DocumentEndTraceEvent(long endTimeNanos, long totalTimeNanos, int line, int col) {
            super(EventType.DOCUMENT_END, new int[]{line}, new int[]{col}, new String[]{String.valueOf(endTimeNanos), String.valueOf(totalTimeNanos)});
        }

        public long getStartTimeNanos() {
            return Long.parseLong(this.contents[0]);
        }

        public long getTotalTimeNanos() {
            return Long.parseLong(this.contents[1]);
        }

        public int getLine() {
            return this.lines[0];
        }

        public int getCol() {
            return this.cols[0];
        }
    }

    public static final class DocumentStartTraceEvent
    extends MarkupTraceEvent {
        public DocumentStartTraceEvent(long startTimeNanos, int line, int col) {
            super(EventType.DOCUMENT_START, new int[]{line}, new int[]{col}, new String[]{String.valueOf(startTimeNanos)});
        }

        public long getStartTimeNanos() {
            return Long.parseLong(this.contents[0]);
        }

        public int getLine() {
            return this.lines[0];
        }

        public int getCol() {
            return this.cols[0];
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EventType {
        DOCUMENT_START("DS"),
        DOCUMENT_END("DE"),
        STANDALONE_ELEMENT_START("SES"),
        STANDALONE_ELEMENT_END("SEE"),
        NON_MINIMIZED_STANDALONE_ELEMENT_START("NSES"),
        NON_MINIMIZED_STANDALONE_ELEMENT_END("NSEE"),
        OPEN_ELEMENT_START("OES"),
        OPEN_ELEMENT_END("OEE"),
        AUTO_OPEN_ELEMENT_START("AOES"),
        AUTO_OPEN_ELEMENT_END("AOEE"),
        CLOSE_ELEMENT_START("CES"),
        CLOSE_ELEMENT_END("CEE"),
        AUTO_CLOSE_ELEMENT_START("ACES"),
        AUTO_CLOSE_ELEMENT_END("ACEE"),
        UNMATCHED_CLOSE_ELEMENT_START("UCES"),
        UNMATCHED_CLOSE_ELEMENT_END("UCEE"),
        ATTRIBUTE("A"),
        INNER_WHITE_SPACE("IWS"),
        TEXT("T"),
        COMMENT("C"),
        CDATA_SECTION("CD"),
        XML_DECLARATION("XD"),
        DOC_TYPE("DT"),
        PROCESSING_INSTRUCTION("P");

        private String stringRepresentation;

        private EventType(String stringRepresentation) {
            this.stringRepresentation = stringRepresentation;
        }

        public String toString() {
            return this.stringRepresentation;
        }
    }
}

