/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.mail;

import io.vertx.codegen.annotations.DataObject;
import io.vertx.codegen.annotations.GenIgnore;
import io.vertx.core.MultiMap;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.CaseInsensitiveHeaders;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.mail.Utils;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

@DataObject
public class MailAttachment {
    private Buffer data;
    private String name;
    private String contentType;
    private String disposition;
    private String description;
    private String contentId;
    private MultiMap headers;

    public MailAttachment() {
    }

    public MailAttachment(MailAttachment other) {
        Objects.requireNonNull(other);
        this.data = other.data == null ? null : other.data.copy();
        this.name = other.name;
        this.contentType = other.contentType;
        this.disposition = other.disposition;
        this.description = other.description;
        this.description = other.description;
        this.contentId = other.contentId;
        this.headers = other.headers == null ? null : new CaseInsensitiveHeaders().addAll(other.headers);
    }

    public MailAttachment(JsonObject json) {
        Objects.requireNonNull(json);
        this.data = json.getBinary("data") == null ? null : Buffer.buffer((byte[])json.getBinary("data"));
        this.name = json.getString("name");
        this.contentType = json.getString("contentType");
        this.disposition = json.getString("disposition");
        this.description = json.getString("description");
        this.contentId = json.getString("contentId");
        JsonObject headers = json.getJsonObject("headers");
        if (headers != null) {
            this.headers = Utils.jsonToMultiMap(headers);
        }
    }

    public Buffer getData() {
        return this.data;
    }

    public MailAttachment setData(Buffer data) {
        this.data = data;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public MailAttachment setName(String name) {
        this.name = name;
        return this;
    }

    public String getContentType() {
        return this.contentType;
    }

    public MailAttachment setContentType(String contentType) {
        this.contentType = contentType;
        return this;
    }

    public String getDisposition() {
        return this.disposition;
    }

    public MailAttachment setDisposition(String disposition) {
        this.disposition = disposition;
        return this;
    }

    public String getDescription() {
        return this.description;
    }

    public MailAttachment setDescription(String description) {
        this.description = description;
        return this;
    }

    public String getContentId() {
        return this.contentId;
    }

    public MailAttachment setContentId(String contentId) {
        this.contentId = contentId;
        return this;
    }

    public MailAttachment addHeader(String key, String value) {
        if (this.headers == null) {
            this.headers = new CaseInsensitiveHeaders();
        }
        Objects.requireNonNull(key, "no null key accepted");
        Objects.requireNonNull(value, "no null value accepted");
        this.headers.add(key, value);
        return this;
    }

    @GenIgnore
    public MultiMap getHeaders() {
        return this.headers;
    }

    @GenIgnore
    public MailAttachment setHeaders(MultiMap headers) {
        this.headers = headers;
        return this;
    }

    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        if (this.data != null) {
            json.put("data", this.data.getBytes());
        }
        Utils.putIfNotNull(json, "name", this.name);
        Utils.putIfNotNull(json, "contentType", this.contentType);
        Utils.putIfNotNull(json, "disposition", this.disposition);
        Utils.putIfNotNull(json, "description", this.description);
        Utils.putIfNotNull(json, "contentId", this.contentId);
        if (this.headers != null) {
            json.put("headers", Utils.multiMapToJson(this.headers));
        }
        return json;
    }

    private List<Object> getList() {
        return Arrays.asList(this.data, this.name, this.disposition, this.description, this.contentId, this.headers);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof MailAttachment)) {
            return false;
        }
        MailAttachment attachment = (MailAttachment)o;
        return this.getList().equals(attachment.getList());
    }

    public int hashCode() {
        return this.getList().hashCode();
    }
}

