/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.mail;

import io.vertx.codegen.annotations.DataObject;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import java.util.ArrayList;
import java.util.List;

@DataObject
public class MailResult {
    private String messageID;
    private List<String> recipients;

    public MailResult() {
        this.messageID = null;
        this.recipients = new ArrayList<String>();
    }

    public MailResult(MailResult other) {
        this.messageID = other.messageID;
        this.recipients = new ArrayList<String>(other.recipients);
    }

    public MailResult(JsonObject json) {
        this.messageID = json.getString("messageId");
        JsonArray jsonArray = json.getJsonArray("recipients");
        this.recipients = jsonArray == null ? new ArrayList() : jsonArray.getList();
    }

    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        if (this.messageID != null) {
            json.put("messageId", this.messageID);
        }
        if (this.recipients != null) {
            json.put("recipients", this.recipients);
        }
        return json;
    }

    public String getMessageID() {
        return this.messageID;
    }

    public MailResult setMessageID(String messageID) {
        this.messageID = messageID;
        return this;
    }

    public List<String> getRecipients() {
        return this.recipients;
    }

    public MailResult setRecipients(List<String> recipients) {
        this.recipients = recipients;
        return this;
    }

    public String toString() {
        return this.toJson().encode();
    }
}

