/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.mail.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Context;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import io.vertx.core.shareddata.LocalMap;
import io.vertx.core.shareddata.Shareable;
import io.vertx.ext.mail.MailClient;
import io.vertx.ext.mail.MailConfig;
import io.vertx.ext.mail.MailMessage;
import io.vertx.ext.mail.MailResult;
import io.vertx.ext.mail.impl.SMTPConnection;
import io.vertx.ext.mail.impl.SMTPConnectionPool;
import io.vertx.ext.mail.impl.SMTPSendMail;
import io.vertx.ext.mail.impl.Utils;

public class MailClientImpl
implements MailClient {
    private static final Logger log = LoggerFactory.getLogger(MailClientImpl.class);
    private static final String POOL_LOCAL_MAP_NAME = "__vertx.MailClient.pools";
    private final Vertx vertx;
    private final MailConfig config;
    private final SMTPConnectionPool connectionPool;
    private final MailHolder holder;
    private String hostname = null;
    private volatile boolean closed = false;

    public MailClientImpl(Vertx vertx, MailConfig config, String poolName) {
        this.vertx = vertx;
        this.config = config;
        this.holder = this.lookupHolder(poolName, config);
        this.connectionPool = this.holder.pool();
    }

    @Override
    public void close() {
        if (this.closed) {
            throw new IllegalStateException("Already closed");
        }
        this.holder.close();
        this.closed = true;
    }

    @Override
    public MailClient sendMail(MailMessage message, Handler<AsyncResult<MailResult>> resultHandler) {
        Context context = this.vertx.getOrCreateContext();
        if (!this.closed) {
            if (this.validateHeaders(message, resultHandler, context)) {
                if (this.hostname == null) {
                    this.vertx.executeBlocking(fut -> {
                        String hname = this.config.getOwnHostname() != null ? this.config.getOwnHostname() : Utils.getHostname();
                        fut.complete((Object)hname);
                    }, res -> {
                        if (res.succeeded()) {
                            this.hostname = (String)res.result();
                            this.getConnection(message, resultHandler, context);
                        } else {
                            this.handleError(res.cause(), resultHandler, context);
                        }
                    });
                } else {
                    this.getConnection(message, resultHandler, context);
                }
            }
        } else {
            this.handleError("mail client has been closed", resultHandler, context);
        }
        return this;
    }

    private void getConnection(MailMessage message, Handler<AsyncResult<MailResult>> resultHandler, Context context) {
        this.connectionPool.getConnection(this.hostname, (Handler<AsyncResult<SMTPConnection>>)((Handler)result -> {
            if (result.succeeded()) {
                SMTPConnection connection = (SMTPConnection)result.result();
                connection.setErrorHandler((Handler<Throwable>)((Handler)th -> this.handleError((Throwable)th, resultHandler, context)));
                this.sendMessage(message, connection, resultHandler, context);
            } else {
                this.handleError(result.cause(), resultHandler, context);
            }
        }));
    }

    private void sendMessage(MailMessage email, SMTPConnection conn, Handler<AsyncResult<MailResult>> resultHandler, Context context) {
        new SMTPSendMail(conn, email, this.config, this.hostname, (Handler<AsyncResult<MailResult>>)((Handler)result -> {
            if (result.succeeded()) {
                conn.returnToPool();
            } else {
                conn.setBroken();
            }
            this.returnResult((AsyncResult<MailResult>)result, resultHandler, context);
        })).start();
    }

    private boolean validateHeaders(MailMessage email, Handler<AsyncResult<MailResult>> resultHandler, Context context) {
        if (email.getBounceAddress() == null && email.getFrom() == null) {
            this.handleError("sender address is not present", resultHandler, context);
            return false;
        }
        if (!(email.getTo() != null && email.getTo().size() != 0 || email.getCc() != null && email.getCc().size() != 0 || email.getBcc() != null && email.getBcc().size() != 0)) {
            log.warn((Object)"no recipient addresses are present");
            this.handleError("no recipient addresses are present", resultHandler, context);
            return false;
        }
        return true;
    }

    private void handleError(String message, Handler<AsyncResult<MailResult>> resultHandler, Context context) {
        log.debug((Object)("handleError:" + message));
        this.returnResult((AsyncResult<MailResult>)Future.failedFuture((String)message), resultHandler, context);
    }

    private void handleError(Throwable t, Handler<AsyncResult<MailResult>> resultHandler, Context context) {
        log.debug((Object)"handleError", t);
        this.returnResult((AsyncResult<MailResult>)Future.failedFuture((Throwable)t), resultHandler, context);
    }

    private void returnResult(AsyncResult<MailResult> result, Handler<AsyncResult<MailResult>> resultHandler, Context context) {
        context.runOnContext(v -> {
            if (resultHandler != null) {
                resultHandler.handle((Object)result);
            } else if (result.succeeded()) {
                log.debug((Object)"dropping sendMail result");
            } else {
                log.info((Object)"dropping sendMail failure", result.cause());
            }
        });
    }

    SMTPConnectionPool getConnectionPool() {
        return this.connectionPool;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MailHolder lookupHolder(String poolName, MailConfig config) {
        Vertx vertx = this.vertx;
        synchronized (vertx) {
            LocalMap map = this.vertx.sharedData().getLocalMap(POOL_LOCAL_MAP_NAME);
            MailHolder theHolder = (MailHolder)map.get((Object)poolName);
            if (theHolder == null) {
                theHolder = new MailHolder(this.vertx, config, () -> this.removeFromMap((LocalMap<String, MailHolder>)map, poolName));
                map.put((Object)poolName, (Object)theHolder);
            } else {
                theHolder.incRefCount();
            }
            return theHolder;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeFromMap(LocalMap<String, MailHolder> map, String dataSourceName) {
        Vertx vertx = this.vertx;
        synchronized (vertx) {
            map.remove((Object)dataSourceName);
            if (map.isEmpty()) {
                map.close();
            }
        }
    }

    private static class MailHolder
    implements Shareable {
        final SMTPConnectionPool pool;
        final Runnable closeRunner;
        int refCount = 1;

        public MailHolder(Vertx vertx, MailConfig config, Runnable closeRunner) {
            this.closeRunner = closeRunner;
            this.pool = new SMTPConnectionPool(vertx, config);
        }

        SMTPConnectionPool pool() {
            return this.pool;
        }

        synchronized void incRefCount() {
            ++this.refCount;
        }

        synchronized void close() {
            if (--this.refCount == 0) {
                this.pool.close();
                if (this.closeRunner != null) {
                    this.closeRunner.run();
                }
            }
        }
    }
}

