/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.maven;

public class MavenCoords {
    private final String owner;
    private final String serviceName;
    private final String extension;
    private final String classifier;
    private final String version;

    public MavenCoords(String owner, String serviceName, String extension, String classifier, String version) {
        this.owner = owner;
        this.serviceName = serviceName;
        this.extension = extension;
        this.classifier = classifier;
        this.version = version;
    }

    public MavenCoords(String idString) {
        String[] split = idString.split(":");
        if (split.length != 2 && split.length != 3 && split.length != 4 && split.length != 5) {
            throw new IllegalArgumentException("Invalid maven coordinates: " + idString);
        }
        this.owner = split[0];
        this.serviceName = split[1];
        if (split.length == 3) {
            this.extension = null;
            this.classifier = null;
            this.version = split[2];
        } else if (split.length == 4) {
            this.extension = split[2];
            this.classifier = null;
            this.version = split[3];
        } else if (split.length == 5) {
            this.extension = split[2];
            this.classifier = split[3];
            this.version = split[4];
        } else {
            this.extension = null;
            this.classifier = null;
            this.version = null;
        }
    }

    public String owner() {
        return this.owner;
    }

    public String serviceName() {
        return this.serviceName;
    }

    public String extension() {
        return this.extension;
    }

    public String classifier() {
        return this.classifier;
    }

    public String version() {
        return this.version;
    }
}

