/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.consul.impl;

import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.consul.CheckStatus;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Utils {
    public static CheckStatus aggregateCheckStatus(List<CheckStatus> checks) {
        boolean warning = false;
        boolean critical = false;
        for (CheckStatus status : checks) {
            switch (status) {
                case WARNING: {
                    warning = true;
                    break;
                }
                case CRITICAL: {
                    critical = true;
                }
            }
        }
        if (critical) {
            return CheckStatus.CRITICAL;
        }
        if (warning) {
            return CheckStatus.WARNING;
        }
        return CheckStatus.PASSING;
    }

    public static String urlEncode(String str) {
        try {
            return URLEncoder.encode(str, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return "";
        }
    }

    public static String encode64(String src) {
        if (src == null || src.isEmpty()) {
            return "";
        }
        return new String(Base64.getEncoder().encode(src.getBytes()));
    }

    public static String decode64(String src) {
        if (src == null || src.isEmpty()) {
            return "";
        }
        return new String(Base64.getDecoder().decode(src));
    }

    public static <T> List<T> listOf(List<T> list) {
        if (list == null) {
            return null;
        }
        return new ArrayList<T>(list);
    }

    public static Map<String, String> mapStringString(JsonObject obj) {
        if (obj == null) {
            return null;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        obj.getMap().forEach((k, v) -> map.put((String)k, (String)v));
        return map;
    }

    public static <T> List<T> listOf(JsonArray arr) {
        if (arr == null) {
            return null;
        }
        return arr.getList();
    }
}

