/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.cache;

import com.github.benmanes.caffeine.cache.BoundedLocalCache;
import com.github.benmanes.caffeine.cache.CacheLoader;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.lang.reflect.Constructor;
import javax.annotation.Nullable;

final class LocalCacheFactory {
    public static final String MAXIMUM = "maximum";
    public static final String EDEN_MAXIMUM = "edenMaximum";
    public static final String MAIN_PROTECTED_MAXIMUM = "mainProtectedMaximum";
    public static final String WEIGHTED_SIZE = "weightedSize";
    public static final String EDEN_WEIGHTED_SIZE = "edenWeightedSize";
    public static final String MAIN_PROTECTED_WEIGHTED_SIZE = "mainProtectedWeightedSize";
    public static final String KEY = "key";
    public static final String VALUE = "value";
    public static final String ACCESS_TIME = "accessTime";
    public static final String WRITE_TIME = "writeTime";

    private LocalCacheFactory() {
    }

    static <K, V> BoundedLocalCache<K, V> newBoundedLocalCache(Caffeine<K, V> caffeine, @Nullable CacheLoader<? super K, V> cacheLoader, boolean bl) {
        StringBuilder stringBuilder = new StringBuilder("com.github.benmanes.caffeine.cache.");
        if (caffeine.isStrongKeys()) {
            stringBuilder.append('S');
        } else {
            stringBuilder.append('W');
        }
        if (caffeine.isStrongValues()) {
            stringBuilder.append('S');
        } else {
            stringBuilder.append('I');
        }
        if (caffeine.removalListener != null) {
            stringBuilder.append('L');
        }
        if (caffeine.isRecordingStats()) {
            stringBuilder.append('S');
        }
        if (caffeine.evicts()) {
            stringBuilder.append('M');
            if (caffeine.isWeighted()) {
                stringBuilder.append('W');
            } else {
                stringBuilder.append('S');
            }
        }
        if (caffeine.expiresAfterAccess() || caffeine.expiresVariable()) {
            stringBuilder.append('A');
        }
        if (caffeine.expiresAfterWrite()) {
            stringBuilder.append('W');
        }
        if (caffeine.refreshes()) {
            stringBuilder.append('R');
        }
        try {
            Class<?> clazz = LocalCacheFactory.class.getClassLoader().loadClass(stringBuilder.toString());
            Constructor<?> constructor = clazz.getDeclaredConstructor(Caffeine.class, CacheLoader.class, Boolean.TYPE);
            BoundedLocalCache boundedLocalCache = (BoundedLocalCache)constructor.newInstance(caffeine, cacheLoader, bl);
            return boundedLocalCache;
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            throw new IllegalStateException(stringBuilder.toString(), reflectiveOperationException);
        }
    }
}

