/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.core;

import com.github.dockerjava.api.exception.DockerClientException;
import com.github.dockerjava.api.model.AuthConfig;
import com.github.dockerjava.api.model.AuthConfigurations;
import com.github.dockerjava.core.AuthConfigFile;
import com.github.dockerjava.core.NameParser;
import com.github.dockerjava.core.RemoteApiVersion;
import com.google.common.base.Preconditions;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URI;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

public class DockerClientConfig
implements Serializable {
    private static final long serialVersionUID = -4307357472441531489L;
    public static final String DOCKER_HOST = "DOCKER_HOST";
    public static final String DOCKER_TLS_VERIFY = "DOCKER_TLS_VERIFY";
    public static final String DOCKER_CONFIG = "DOCKER_CONFIG";
    public static final String DOCKER_CERT_PATH = "DOCKER_CERT_PATH";
    public static final String API_VERSION = "api.version";
    public static final String REGISTRY_USERNAME = "registry.username";
    public static final String REGISTRY_PASSWORD = "registry.password";
    public static final String REGISTRY_EMAIL = "registry.email";
    public static final String REGISTRY_URL = "registry.url";
    private static final String DOCKER_JAVA_PROPERTIES = "docker-java.properties";
    private static final String DOCKER_CFG = ".dockercfg";
    private static final Set<String> CONFIG_KEYS = new HashSet<String>();
    private final URI dockerHost;
    private final String registryUsername;
    private final String registryPassword;
    private final String registryEmail;
    private final String registryUrl;
    private final String dockerConfig;
    private final String dockerCertPath;
    private final boolean dockerTlsVerify;
    private final RemoteApiVersion apiVersion;

    DockerClientConfig(URI dockerHost, String dockerConfig, String apiVersion, String registryUrl, String registryUsername, String registryPassword, String registryEmail, String dockerCertPath, boolean dockerTslVerify) {
        this.dockerHost = this.checkDockerHostScheme(dockerHost);
        this.dockerTlsVerify = dockerTslVerify;
        this.dockerCertPath = this.checkDockerCertPath(dockerTslVerify, dockerCertPath);
        this.dockerConfig = dockerConfig;
        this.apiVersion = RemoteApiVersion.parseConfigWithDefault(apiVersion);
        this.registryUsername = registryUsername;
        this.registryPassword = registryPassword;
        this.registryEmail = registryEmail;
        this.registryUrl = registryUrl;
    }

    private URI checkDockerHostScheme(URI dockerHost) {
        if ("tcp".equals(dockerHost.getScheme()) || "unix".equals(dockerHost.getScheme())) {
            return dockerHost;
        }
        throw new DockerClientException("Unsupported protocol scheme found: '" + dockerHost + "'. Only 'tcp://' or 'unix://' supported.");
    }

    private String checkDockerCertPath(boolean dockerTlsVerify, String dockerCertPath) {
        if (dockerTlsVerify) {
            if (StringUtils.isEmpty((String)dockerCertPath)) {
                throw new DockerClientException("Enabled TLS verification (DOCKER_TLS_VERIFY=1) but certifate path (DOCKER_CERT_PATH) is not defined.");
            }
            File certPath = new File(dockerCertPath);
            if (!certPath.exists()) {
                throw new DockerClientException("Enabled TLS verification (DOCKER_TLS_VERIFY=1) but certificate path (DOCKER_CERT_PATH) '" + dockerCertPath + "' doesn't exist.");
            }
            if (certPath.isDirectory()) {
                return dockerCertPath;
            }
            throw new DockerClientException("Enabled TLS verification (DOCKER_TLS_VERIFY=1) but certificate path (DOCKER_CERT_PATH) '" + dockerCertPath + "' doesn't point to a directory.");
        }
        return dockerCertPath;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Properties loadIncludedDockerProperties(Properties systemProperties) {
        try (InputStream is = DockerClientConfig.class.getResourceAsStream("/docker-java.properties");){
            Properties p = new Properties();
            p.load(is);
            DockerClientConfig.replaceProperties(p, systemProperties);
            Properties properties = p;
            return properties;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static void replaceProperties(Properties properties, Properties replacements) {
        for (Object objectKey : properties.keySet()) {
            String key = objectKey.toString();
            properties.setProperty(key, DockerClientConfig.replaceProperties(properties.getProperty(key), replacements));
        }
    }

    private static String replaceProperties(String s, Properties replacements) {
        for (Map.Entry<Object, Object> entry : replacements.entrySet()) {
            String key = "${" + entry.getKey() + "}";
            while (s.contains(key)) {
                s = s.replace(key, String.valueOf(entry.getValue()));
            }
        }
        return s;
    }

    private static Properties overrideDockerPropertiesWithSettingsFromUserHome(Properties p, Properties systemProperties) {
        Properties overriddenProperties = new Properties();
        overriddenProperties.putAll((Map<?, ?>)p);
        File usersDockerPropertiesFile = new File(systemProperties.getProperty("user.home"), ".docker-java.properties");
        if (usersDockerPropertiesFile.isFile()) {
            try (FileInputStream in = new FileInputStream(usersDockerPropertiesFile);){
                overriddenProperties.load(in);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return overriddenProperties;
    }

    private static Properties overrideDockerPropertiesWithEnv(Properties properties, Map<String, String> env) {
        Properties overriddenProperties = new Properties();
        overriddenProperties.putAll((Map<?, ?>)properties);
        if (env.containsKey(DOCKER_HOST)) {
            overriddenProperties.setProperty(DOCKER_HOST, env.get(DOCKER_HOST));
        }
        for (Map.Entry<String, String> envEntry : env.entrySet()) {
            String envKey = envEntry.getKey();
            if (!CONFIG_KEYS.contains(envKey)) continue;
            overriddenProperties.setProperty(envKey, envEntry.getValue());
        }
        return overriddenProperties;
    }

    private static Properties overrideDockerPropertiesWithSystemProperties(Properties p, Properties systemProperties) {
        Properties overriddenProperties = new Properties();
        overriddenProperties.putAll((Map<?, ?>)p);
        for (String key : CONFIG_KEYS) {
            if (!systemProperties.containsKey(key)) continue;
            overriddenProperties.setProperty(key, systemProperties.getProperty(key));
        }
        return overriddenProperties;
    }

    public static DockerClientConfigBuilder createDefaultConfigBuilder() {
        return DockerClientConfig.createDefaultConfigBuilder(System.getenv(), System.getProperties());
    }

    static DockerClientConfigBuilder createDefaultConfigBuilder(Map<String, String> env, Properties systemProperties) {
        Properties properties = DockerClientConfig.loadIncludedDockerProperties(systemProperties);
        properties = DockerClientConfig.overrideDockerPropertiesWithSettingsFromUserHome(properties, systemProperties);
        properties = DockerClientConfig.overrideDockerPropertiesWithEnv(properties, env);
        properties = DockerClientConfig.overrideDockerPropertiesWithSystemProperties(properties, systemProperties);
        return new DockerClientConfigBuilder().withProperties(properties);
    }

    public URI getDockerHost() {
        return this.dockerHost;
    }

    public RemoteApiVersion getApiVersion() {
        return this.apiVersion;
    }

    public String getRegistryUsername() {
        return this.registryUsername;
    }

    public String getRegistryPassword() {
        return this.registryPassword;
    }

    public String getRegistryEmail() {
        return this.registryEmail;
    }

    public String getRegistryUrl() {
        return this.registryUrl;
    }

    public String getDockerConfig() {
        return this.dockerConfig;
    }

    public String getDockerCertPath() {
        return this.dockerCertPath;
    }

    public boolean getDockerTlsVerify() {
        return this.dockerTlsVerify;
    }

    private AuthConfig getAuthConfig() {
        AuthConfig authConfig = null;
        if (this.getRegistryUsername() != null && this.getRegistryPassword() != null && this.getRegistryEmail() != null && this.getRegistryUrl() != null) {
            authConfig = new AuthConfig().withUsername(this.getRegistryUsername()).withPassword(this.getRegistryPassword()).withEmail(this.getRegistryEmail()).withRegistryAddress(this.getRegistryUrl());
        }
        return authConfig;
    }

    public AuthConfig effectiveAuthConfig(String imageName) {
        AuthConfig otherAuthConfig;
        AuthConfig authConfig = null;
        File dockerCfgFile = new File(this.getDockerConfig() + File.separator + DOCKER_CFG);
        if (dockerCfgFile.exists() && dockerCfgFile.isFile() && imageName != null) {
            AuthConfigFile authConfigFile;
            try {
                authConfigFile = AuthConfigFile.loadConfig(dockerCfgFile);
            }
            catch (IOException e) {
                throw new DockerClientException("Failed to parse dockerCfgFile", e);
            }
            NameParser.ReposTag reposTag = NameParser.parseRepositoryTag(imageName);
            NameParser.HostnameReposName hostnameReposName = NameParser.resolveRepositoryName(reposTag.repos);
            authConfig = authConfigFile.resolveAuthConfig(hostnameReposName.hostname);
        }
        if ((otherAuthConfig = this.getAuthConfig()) != null) {
            authConfig = otherAuthConfig;
        }
        return authConfig;
    }

    public AuthConfigurations getAuthConfigurations() {
        File dockerCfgFile = new File(this.getDockerConfig() + File.separator + DOCKER_CFG);
        if (dockerCfgFile.exists() && dockerCfgFile.isFile()) {
            AuthConfigFile authConfigFile;
            try {
                authConfigFile = AuthConfigFile.loadConfig(dockerCfgFile);
            }
            catch (IOException e) {
                throw new DockerClientException("Failed to parse dockerCfgFile", e);
            }
            return authConfigFile.getAuthConfigurations();
        }
        return new AuthConfigurations();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DockerClientConfig that = (DockerClientConfig)o;
        return EqualsBuilder.reflectionEquals((Object)this, (Object)that);
    }

    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode((Object)this);
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
    }

    static {
        CONFIG_KEYS.add(DOCKER_HOST);
        CONFIG_KEYS.add(DOCKER_TLS_VERIFY);
        CONFIG_KEYS.add(DOCKER_CONFIG);
        CONFIG_KEYS.add(DOCKER_CERT_PATH);
        CONFIG_KEYS.add(API_VERSION);
        CONFIG_KEYS.add(REGISTRY_USERNAME);
        CONFIG_KEYS.add(REGISTRY_PASSWORD);
        CONFIG_KEYS.add(REGISTRY_EMAIL);
        CONFIG_KEYS.add(REGISTRY_URL);
    }

    public static class DockerClientConfigBuilder {
        private URI dockerHost;
        private String apiVersion;
        private String registryUsername;
        private String registryPassword;
        private String registryEmail;
        private String registryUrl;
        private String dockerConfig;
        private String dockerCertPath;
        private boolean dockerTlsVerify;

        public DockerClientConfigBuilder withProperties(Properties p) {
            return this.withDockerHost(p.getProperty(DockerClientConfig.DOCKER_HOST)).withDockerTlsVerify(p.getProperty(DockerClientConfig.DOCKER_TLS_VERIFY)).withDockerConfig(p.getProperty(DockerClientConfig.DOCKER_CONFIG)).withDockerCertPath(p.getProperty(DockerClientConfig.DOCKER_CERT_PATH)).withApiVersion(p.getProperty(DockerClientConfig.API_VERSION)).withRegistryUsername(p.getProperty(DockerClientConfig.REGISTRY_USERNAME)).withRegistryPassword(p.getProperty(DockerClientConfig.REGISTRY_PASSWORD)).withRegistryEmail(p.getProperty(DockerClientConfig.REGISTRY_EMAIL)).withRegistryUrl(p.getProperty(DockerClientConfig.REGISTRY_URL));
        }

        public final DockerClientConfigBuilder withDockerHost(String dockerHost) {
            Preconditions.checkNotNull((Object)dockerHost, (Object)"uri was not specified");
            this.dockerHost = URI.create(dockerHost);
            return this;
        }

        public final DockerClientConfigBuilder withApiVersion(RemoteApiVersion apiVersion) {
            this.apiVersion = apiVersion.getVersion();
            return this;
        }

        public final DockerClientConfigBuilder withApiVersion(String apiVersion) {
            this.apiVersion = apiVersion;
            return this;
        }

        public final DockerClientConfigBuilder withRegistryUsername(String registryUsername) {
            this.registryUsername = registryUsername;
            return this;
        }

        public final DockerClientConfigBuilder withRegistryPassword(String registryPassword) {
            this.registryPassword = registryPassword;
            return this;
        }

        public final DockerClientConfigBuilder withRegistryEmail(String registryEmail) {
            this.registryEmail = registryEmail;
            return this;
        }

        public DockerClientConfigBuilder withRegistryUrl(String registryUrl) {
            this.registryUrl = registryUrl;
            return this;
        }

        public final DockerClientConfigBuilder withDockerCertPath(String dockerCertPath) {
            this.dockerCertPath = dockerCertPath;
            return this;
        }

        public final DockerClientConfigBuilder withDockerConfig(String dockerConfig) {
            this.dockerConfig = dockerConfig;
            return this;
        }

        public final DockerClientConfigBuilder withDockerTlsVerify(String dockerTlsVerify) {
            String trimmed;
            this.dockerTlsVerify = dockerTlsVerify != null ? "true".equalsIgnoreCase(trimmed = dockerTlsVerify.trim()) || "1".equals(trimmed) : false;
            return this;
        }

        public final DockerClientConfigBuilder withDockerTlsVerify(Boolean dockerTlsVerify) {
            this.dockerTlsVerify = dockerTlsVerify;
            return this;
        }

        public DockerClientConfig build() {
            return new DockerClientConfig(this.dockerHost, this.dockerConfig, this.apiVersion, this.registryUrl, this.registryUsername, this.registryPassword, this.registryEmail, this.dockerCertPath, this.dockerTlsVerify);
        }
    }
}

