/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.config.redis;

import io.vertx.config.spi.ConfigStore;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.JsonObject;
import io.vertx.redis.RedisClient;
import io.vertx.redis.RedisOptions;

public class RedisConfigStore
implements ConfigStore {
    private final RedisClient redis;
    private final String field;

    public RedisConfigStore(Vertx vertx, JsonObject config) {
        this.field = config.getString("key", "configuration");
        this.redis = RedisClient.create((Vertx)vertx, (RedisOptions)new RedisOptions(config));
    }

    public void close(Handler<Void> completionHandler) {
        this.redis.close(ar -> completionHandler.handle(null));
    }

    public void get(Handler<AsyncResult<Buffer>> completionHandler) {
        this.redis.hgetall(this.field, ar -> {
            if (ar.failed()) {
                completionHandler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
            } else {
                completionHandler.handle((Object)ar.map(json -> Buffer.buffer((String)((JsonObject)ar.result()).encode())));
            }
        });
    }
}

