/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.datagram.impl;

import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.impl.ContextInternal;

final class DatagramChannelFutureListener<T>
implements ChannelFutureListener {
    private final Handler<AsyncResult<T>> handler;
    private final T result;
    private final ContextInternal context;

    DatagramChannelFutureListener(T result, Handler<AsyncResult<T>> handler, ContextInternal context) {
        this.handler = handler;
        this.result = result;
        this.context = context;
    }

    public void operationComplete(ChannelFuture future) throws Exception {
        this.context.executeFromIO(v -> this.notifyHandler(future));
    }

    private void notifyHandler(ChannelFuture future) {
        if (future.isSuccess()) {
            this.handler.handle(Future.succeededFuture(this.result));
        } else {
            this.handler.handle(Future.failedFuture(future.cause()));
        }
    }
}

