/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.servicediscovery.backend.zookeeper;

import io.vertx.core.AsyncResult;
import io.vertx.core.CompositeFuture;
import io.vertx.core.Context;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.json.JsonObject;
import io.vertx.servicediscovery.Record;
import io.vertx.servicediscovery.spi.ServiceDiscoveryBackend;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.curator.RetryPolicy;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.framework.api.ACLBackgroundPathAndBytesable;
import org.apache.curator.framework.api.CuratorEvent;
import org.apache.curator.framework.api.DeleteBuilder;
import org.apache.curator.framework.api.ErrorListenerPathAndBytesable;
import org.apache.curator.framework.api.ErrorListenerPathable;
import org.apache.curator.framework.state.ConnectionState;
import org.apache.curator.framework.state.ConnectionStateListener;
import org.apache.curator.retry.ExponentialBackoffRetry;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;

public class ZookeeperBackendService
implements ServiceDiscoveryBackend,
ConnectionStateListener {
    private static final Charset CHARSET = Charset.forName("UTF-8");
    private CuratorFramework client;
    private String basePath;
    private boolean ephemeral;
    private boolean guaranteed;
    private Vertx vertx;
    private ConnectionState connectionState = ConnectionState.LOST;
    private boolean canBeReadOnly;
    private int connectionTimeoutMs;

    public void init(Vertx vertx, JsonObject configuration) {
        this.vertx = vertx;
        String connection = Objects.requireNonNull(configuration.getString("connection"));
        int maxRetries = configuration.getInteger("maxRetries", Integer.valueOf(3));
        int baseGraceBetweenRetries = configuration.getInteger("baseSleepTimeBetweenRetries", Integer.valueOf(1000));
        this.canBeReadOnly = configuration.getBoolean("canBeReadOnly", Boolean.valueOf(false));
        this.connectionTimeoutMs = configuration.getInteger("connectionTimeoutMs", Integer.valueOf(1000));
        this.basePath = configuration.getString("basePath", "/services");
        this.ephemeral = configuration.getBoolean("ephemeral", Boolean.valueOf(false));
        this.guaranteed = configuration.getBoolean("guaranteed", Boolean.valueOf(false));
        this.client = CuratorFrameworkFactory.builder().canBeReadOnly(this.canBeReadOnly).connectString(connection).connectionTimeoutMs(this.connectionTimeoutMs).retryPolicy((RetryPolicy)new ExponentialBackoffRetry(baseGraceBetweenRetries, maxRetries)).build();
        this.client.getConnectionStateListenable().addListener((Object)this);
        this.client.start();
    }

    public void store(Record record, Handler<AsyncResult<Record>> resultHandler) {
        if (record.getRegistration() != null) {
            resultHandler.handle((Object)Future.failedFuture((String)"The record has already been registered"));
            return;
        }
        String uuid = UUID.randomUUID().toString();
        record.setRegistration(uuid);
        String content = record.toJson().encode();
        Context context = Vertx.currentContext();
        this.ensureConnected((Handler<AsyncResult<Void>>)((Handler)x -> {
            if (x.failed()) {
                resultHandler.handle((Object)Future.failedFuture((Throwable)x.cause()));
            } else {
                try {
                    ((ErrorListenerPathAndBytesable)((ACLBackgroundPathAndBytesable)this.client.create().creatingParentsIfNeeded().withMode(this.ephemeral ? CreateMode.EPHEMERAL : CreateMode.PERSISTENT)).inBackground((curatorFramework, curatorEvent) -> this.callback(context, record, resultHandler, curatorEvent))).withUnhandledErrorListener((s, throwable) -> resultHandler.handle((Object)Future.failedFuture((Throwable)throwable))).forPath(this.getPath(record.getRegistration()), content.getBytes(CHARSET));
                }
                catch (Exception e) {
                    resultHandler.handle((Object)Future.failedFuture((Throwable)e));
                }
            }
        }));
    }

    private String getPath(String registration) {
        return this.basePath + "/" + registration;
    }

    private void callback(Context context, Record record, Handler<AsyncResult<Record>> resultHandler, CuratorEvent curatorEvent) {
        this.runOnContextIfPossible(context, () -> {
            if (curatorEvent.getResultCode() == KeeperException.Code.OK.intValue()) {
                resultHandler.handle((Object)Future.succeededFuture((Object)record));
            } else {
                KeeperException.Code code = KeeperException.Code.get((int)curatorEvent.getResultCode());
                resultHandler.handle((Object)Future.failedFuture((Throwable)KeeperException.create((KeeperException.Code)code)));
            }
        });
    }

    public void remove(Record record, Handler<AsyncResult<Record>> resultHandler) {
        Objects.requireNonNull(record.getRegistration(), "No registration id in the record");
        this.remove(record.getRegistration(), resultHandler);
    }

    public void remove(String uuid, Handler<AsyncResult<Record>> resultHandler) {
        Objects.requireNonNull(uuid, "No registration id in the record");
        Context context = Vertx.currentContext();
        this.ensureConnected((Handler<AsyncResult<Void>>)((Handler)x -> {
            if (x.failed()) {
                resultHandler.handle((Object)Future.failedFuture((Throwable)x.cause()));
            } else {
                this.getRecordById(context, uuid, (Handler<Record>)((Handler)record -> {
                    if (record == null) {
                        resultHandler.handle((Object)Future.failedFuture((String)("Unknown registration " + uuid)));
                    } else {
                        try {
                            DeleteBuilder delete = this.client.delete();
                            if (this.guaranteed) {
                                delete.guaranteed();
                            }
                            ((ErrorListenerPathable)delete.deletingChildrenIfNeeded().inBackground((curatorFramework, curatorEvent) -> this.callback(context, (Record)record, resultHandler, curatorEvent))).withUnhandledErrorListener((s, throwable) -> resultHandler.handle((Object)Future.failedFuture((Throwable)throwable))).forPath(this.getPath(uuid));
                        }
                        catch (Exception e) {
                            resultHandler.handle((Object)Future.failedFuture((Throwable)e));
                        }
                    }
                }));
            }
        }));
    }

    private void getRecordById(Context context, String uuid, Handler<Record> handler) {
        this.ensureConnected((Handler<AsyncResult<Void>>)((Handler)x -> {
            if (x.failed()) {
                handler.handle(null);
            } else {
                try {
                    ((ErrorListenerPathable)this.client.getData().inBackground((curatorFramework, curatorEvent) -> this.runOnContextIfPossible(context, () -> {
                        if (curatorEvent.getResultCode() == KeeperException.Code.OK.intValue()) {
                            JsonObject json = new JsonObject(new String(curatorEvent.getData(), CHARSET));
                            handler.handle((Object)new Record(json));
                        } else {
                            handler.handle(null);
                        }
                    }))).forPath(this.getPath(uuid));
                }
                catch (Exception e) {
                    handler.handle(null);
                }
            }
        }));
    }

    private void runOnContextIfPossible(Context context, Runnable runnable) {
        if (context != null) {
            context.runOnContext(v -> runnable.run());
        } else {
            runnable.run();
        }
    }

    public void update(Record record, Handler<AsyncResult<Void>> resultHandler) {
        Objects.requireNonNull(record.getRegistration(), "No registration id in the record");
        Context context = Vertx.currentContext();
        this.ensureConnected((Handler<AsyncResult<Void>>)((Handler)x -> {
            if (x.failed()) {
                resultHandler.handle((Object)Future.failedFuture((Throwable)x.cause()));
            } else {
                try {
                    ((ErrorListenerPathAndBytesable)this.client.setData().inBackground((framework, event) -> this.runOnContextIfPossible(context, () -> {
                        if (event.getResultCode() == KeeperException.Code.OK.intValue()) {
                            resultHandler.handle((Object)Future.succeededFuture());
                        } else {
                            KeeperException.Code code = KeeperException.Code.get((int)event.getResultCode());
                            resultHandler.handle((Object)Future.failedFuture((Throwable)KeeperException.create((KeeperException.Code)code)));
                        }
                    }))).withUnhandledErrorListener((message, e) -> resultHandler.handle((Object)Future.failedFuture((Throwable)e))).forPath(this.getPath(record.getRegistration()), record.toJson().encode().getBytes(CHARSET));
                }
                catch (Exception e2) {
                    resultHandler.handle((Object)Future.failedFuture((Throwable)e2));
                }
            }
        }));
    }

    public void getRecords(Handler<AsyncResult<List<Record>>> resultHandler) {
        Context context = Vertx.currentContext();
        this.ensureConnected((Handler<AsyncResult<Void>>)((Handler)x -> {
            if (x.failed()) {
                resultHandler.handle((Object)Future.failedFuture((Throwable)x.cause()));
            } else {
                try {
                    ((ErrorListenerPathable)this.client.getChildren().inBackground((fmk, event) -> {
                        List children = event.getChildren();
                        ArrayList<Future> futures = new ArrayList<Future>();
                        for (String child : children) {
                            Future future = Future.future();
                            this.getRecord(child, (Handler<AsyncResult<Record>>)future.completer());
                            futures.add(future);
                        }
                        CompositeFuture.all(futures).setHandler(ar -> this.runOnContextIfPossible(context, () -> {
                            if (ar.failed()) {
                                resultHandler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                            } else {
                                ArrayList<Record> records = new ArrayList<Record>();
                                for (Future future : futures) {
                                    records.add((Record)future.result());
                                }
                                resultHandler.handle((Object)Future.succeededFuture(records));
                            }
                        }));
                    })).withUnhandledErrorListener((message, e) -> resultHandler.handle((Object)Future.failedFuture((Throwable)e))).forPath(this.basePath);
                }
                catch (Exception e2) {
                    resultHandler.handle((Object)Future.failedFuture((Throwable)e2));
                }
            }
        }));
    }

    public void getRecord(String uuid, Handler<AsyncResult<Record>> handler) {
        Objects.requireNonNull(uuid);
        Context context = Vertx.currentContext();
        this.ensureConnected((Handler<AsyncResult<Void>>)((Handler)x -> {
            if (x.failed()) {
                handler.handle((Object)Future.failedFuture((Throwable)x.cause()));
            } else {
                try {
                    ((ErrorListenerPathable)this.client.getData().inBackground((fmk, curatorEvent) -> this.runOnContextIfPossible(context, () -> {
                        if (curatorEvent.getResultCode() == KeeperException.Code.OK.intValue()) {
                            JsonObject json = new JsonObject(new String(curatorEvent.getData(), CHARSET));
                            handler.handle((Object)Future.succeededFuture((Object)new Record(json)));
                        } else if (curatorEvent.getResultCode() == KeeperException.Code.NONODE.intValue()) {
                            handler.handle((Object)Future.succeededFuture(null));
                        } else {
                            KeeperException.Code code = KeeperException.Code.get((int)curatorEvent.getResultCode());
                            handler.handle((Object)Future.failedFuture((Throwable)KeeperException.create((KeeperException.Code)code)));
                        }
                    }))).withUnhandledErrorListener((message, e) -> handler.handle((Object)Future.failedFuture((Throwable)e))).forPath(this.getPath(uuid));
                }
                catch (Exception e2) {
                    handler.handle((Object)Future.failedFuture((Throwable)e2));
                }
            }
        }));
    }

    public synchronized void stateChanged(CuratorFramework client, ConnectionState newState) {
        this.connectionState = newState;
    }

    private synchronized void ensureConnected(Handler<AsyncResult<Void>> handler) {
        switch (this.connectionState) {
            case CONNECTED: 
            case RECONNECTED: {
                handler.handle((Object)Future.succeededFuture());
                break;
            }
            case READ_ONLY: {
                if (this.canBeReadOnly) {
                    handler.handle((Object)Future.succeededFuture());
                    break;
                }
            }
            case LOST: 
            case SUSPENDED: {
                this.vertx.executeBlocking(future -> {
                    try {
                        if (this.client.blockUntilConnected(this.connectionTimeoutMs, TimeUnit.MILLISECONDS)) {
                            future.complete();
                        } else {
                            future.fail((Throwable)new TimeoutException());
                        }
                    }
                    catch (Exception e) {
                        future.fail((Throwable)e);
                    }
                }, ar -> {
                    if (ar.failed()) {
                        handler.handle((Object)Future.failedFuture((Throwable)KeeperException.create((KeeperException.Code)KeeperException.Code.CONNECTIONLOSS)));
                    } else {
                        handler.handle((Object)Future.succeededFuture());
                    }
                });
            }
        }
    }
}

