/*
 * Decompiled with CFR 0.152.
 */
package org.pegdown.plugins;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.parboiled.BaseParser;
import org.parboiled.Parboiled;
import org.parboiled.Rule;
import org.pegdown.plugins.BlockPluginParser;
import org.pegdown.plugins.InlinePluginParser;
import org.pegdown.plugins.ToHtmlSerializerPlugin;

public class PegDownPlugins {
    private final Rule[] inlinePluginRules;
    private final Rule[] blockPluginRules;
    private final Character[] specialChars;
    private final List<ToHtmlSerializerPlugin> serializerPlugins;
    public static PegDownPlugins NONE = PegDownPlugins.builder().build();

    private PegDownPlugins(Rule[] inlinePluginRules, Rule[] blockPluginRules) {
        this(inlinePluginRules, blockPluginRules, new Character[0], Collections.emptyList());
    }

    private PegDownPlugins(Rule[] inlinePluginRules, Rule[] blockPluginRules, Character[] specialChars, List<ToHtmlSerializerPlugin> serializerPlugins) {
        this.inlinePluginRules = inlinePluginRules;
        this.blockPluginRules = blockPluginRules;
        this.specialChars = specialChars;
        this.serializerPlugins = serializerPlugins;
    }

    public Rule[] getInlinePluginRules() {
        return this.inlinePluginRules;
    }

    public Rule[] getBlockPluginRules() {
        return this.blockPluginRules;
    }

    public Character[] getSpecialChars() {
        return this.specialChars;
    }

    public List<ToHtmlSerializerPlugin> getHtmlSerializerPlugins() {
        return this.serializerPlugins;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(PegDownPlugins like) {
        return PegDownPlugins.builder().withInlinePluginRules(like.getInlinePluginRules()).withBlockPluginRules(like.getBlockPluginRules()).withHtmlSerializer(like.serializerPlugins.toArray(new ToHtmlSerializerPlugin[0]));
    }

    public static class Builder {
        private final List<Rule> inlinePluginRules = new ArrayList<Rule>();
        private final List<Rule> blockPluginRules = new ArrayList<Rule>();
        private final Set<Character> specialChars = new HashSet<Character>();
        private final List<ToHtmlSerializerPlugin> serializerPlugins = new ArrayList<ToHtmlSerializerPlugin>();

        public Builder withInlinePluginRules(Rule ... inlinePlugins) {
            this.inlinePluginRules.addAll(Arrays.asList(inlinePlugins));
            return this;
        }

        public Builder withBlockPluginRules(Rule ... blockPlugins) {
            this.blockPluginRules.addAll(Arrays.asList(blockPlugins));
            return this;
        }

        public Builder withSpecialChars(Character ... chars) {
            Collections.addAll(this.specialChars, chars);
            return this;
        }

        public Builder withHtmlSerializer(ToHtmlSerializerPlugin ... plugins) {
            Collections.addAll(this.serializerPlugins, plugins);
            return this;
        }

        public Builder withPlugin(Class<? extends BaseParser<Object>> pluginParser, Object ... arguments) {
            if (!InlinePluginParser.class.isAssignableFrom(pluginParser) && !BlockPluginParser.class.isAssignableFrom(pluginParser)) {
                throw new IllegalArgumentException("Parser plugin must implement a parser plugin interface to be useful");
            }
            BaseParser parser = Parboiled.createParser(pluginParser, (Object[])arguments);
            if (parser instanceof InlinePluginParser) {
                this.withInlinePluginRules(((InlinePluginParser)parser).inlinePluginRules());
            }
            if (parser instanceof BlockPluginParser) {
                this.withBlockPluginRules(((BlockPluginParser)parser).blockPluginRules());
            }
            return this;
        }

        public PegDownPlugins build() {
            return new PegDownPlugins(this.inlinePluginRules.toArray(new Rule[0]), this.blockPluginRules.toArray(new Rule[0]), this.specialChars.toArray(new Character[0]), Collections.unmodifiableList(this.serializerPlugins));
        }
    }
}

