/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.codetrans.expression;

import io.vertx.codegen.type.ClassKind;
import io.vertx.codegen.type.TypeInfo;
import io.vertx.codetrans.CodeBuilder;
import io.vertx.codetrans.CodeWriter;
import io.vertx.codetrans.Helper;
import io.vertx.codetrans.MethodSignature;
import io.vertx.codetrans.TypeArg;
import io.vertx.codetrans.expression.ExpressionModel;
import io.vertx.codetrans.expression.NullLiteralModel;
import java.util.Collections;
import java.util.List;

public class JsonArrayLiteralModel
extends ExpressionModel {
    private List<ExpressionModel> values;

    public JsonArrayLiteralModel(CodeBuilder builder) {
        this(builder, Collections.emptyList());
    }

    private JsonArrayLiteralModel(CodeBuilder builder, List<ExpressionModel> values) {
        super(builder);
        this.values = values;
    }

    public List<ExpressionModel> getValues() {
        return this.values;
    }

    @Override
    public ExpressionModel as(TypeInfo type) {
        if (type.getKind() != ClassKind.JSON_ARRAY) {
            throw new UnsupportedOperationException();
        }
        return this;
    }

    @Override
    public ExpressionModel onMethodInvocation(TypeInfo receiverType, MethodSignature method, TypeInfo returnType, List<TypeArg> typeArguments, List<ExpressionModel> argumentModels, List<TypeInfo> argumentTypes) {
        String methodName;
        switch (methodName = method.getName()) {
            case "add": {
                return new JsonArrayLiteralModel(this.builder, Helper.append(this.values, argumentModels.get(0)));
            }
            case "addNull": {
                return new JsonArrayLiteralModel(this.builder, Helper.append(this.values, new NullLiteralModel(this.builder)));
            }
        }
        throw new UnsupportedOperationException("Method " + method + " not yet implemented");
    }

    @Override
    public void render(CodeWriter writer) {
        writer.renderJsonArray(this);
    }
}

