/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.async.client;

import com.mongodb.ClientSessionOptions;
import com.mongodb.assertions.Assertions;
import com.mongodb.async.SingleResultCallback;
import com.mongodb.async.client.MongoClientImpl;
import com.mongodb.connection.ClusterConnectionMode;
import com.mongodb.connection.ClusterDescription;
import com.mongodb.connection.Server;
import com.mongodb.connection.ServerDescription;
import com.mongodb.internal.session.ClientSessionImpl;
import com.mongodb.internal.session.ServerSessionPool;
import com.mongodb.selector.ServerSelector;
import com.mongodb.session.ClientSession;
import java.util.List;

class ClientSessionHelper {
    private final MongoClientImpl mongoClient;
    private final ServerSessionPool serverSessionPool;

    ClientSessionHelper(MongoClientImpl mongoClient, ServerSessionPool serverSessionPool) {
        this.mongoClient = mongoClient;
        this.serverSessionPool = serverSessionPool;
    }

    void withClientSession(ClientSession clientSessionFromOperation, SingleResultCallback<ClientSession> callback) {
        if (clientSessionFromOperation != null) {
            Assertions.isTrue((String)"ClientSession from same MongoClient", (clientSessionFromOperation.getOriginator() == this.mongoClient ? 1 : 0) != 0);
            callback.onResult((Object)clientSessionFromOperation, null);
        } else {
            this.createClientSession(ClientSessionOptions.builder().causallyConsistent(false).build(), callback);
        }
    }

    void createClientSession(final ClientSessionOptions options, final SingleResultCallback<ClientSession> callback) {
        if (this.mongoClient.getSettings().getCredentialList().size() > 1) {
            callback.onResult(null, null);
        } else {
            ClusterDescription clusterDescription = this.mongoClient.getCluster().getCurrentDescription();
            if (!this.getServerDescriptionListToConsiderForSessionSupport(clusterDescription).isEmpty() && clusterDescription.getLogicalSessionTimeoutMinutes() != null) {
                callback.onResult((Object)this.createClientSession(options), null);
            } else {
                this.mongoClient.getCluster().selectServerAsync(new ServerSelector(){

                    public List<ServerDescription> select(ClusterDescription clusterDescription) {
                        return ClientSessionHelper.this.getServerDescriptionListToConsiderForSessionSupport(clusterDescription);
                    }
                }, (SingleResultCallback)new SingleResultCallback<Server>(){

                    public void onResult(Server server, Throwable t) {
                        if (t != null) {
                            callback.onResult(null, null);
                        } else if (server.getDescription().getLogicalSessionTimeoutMinutes() == null) {
                            callback.onResult(null, null);
                        } else {
                            callback.onResult((Object)ClientSessionHelper.this.createClientSession(options), null);
                        }
                    }
                });
            }
        }
    }

    private ClientSessionImpl createClientSession(ClientSessionOptions options) {
        return new ClientSessionImpl(this.serverSessionPool, (Object)this.mongoClient, options);
    }

    private List<ServerDescription> getServerDescriptionListToConsiderForSessionSupport(ClusterDescription clusterDescription) {
        if (clusterDescription.getConnectionMode() == ClusterConnectionMode.SINGLE) {
            return clusterDescription.getAny();
        }
        return clusterDescription.getAnyPrimaryOrSecondary();
    }
}

