/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.lang.js.generator;

import io.vertx.codegen.Case;
import io.vertx.codegen.ClassModel;
import io.vertx.codegen.ConstantInfo;
import io.vertx.codegen.Generator;
import io.vertx.codegen.Helper;
import io.vertx.codegen.MethodInfo;
import io.vertx.codegen.ParamInfo;
import io.vertx.codegen.doc.Tag;
import io.vertx.codegen.doc.Token;
import io.vertx.codegen.type.ClassKind;
import io.vertx.codegen.type.ClassTypeInfo;
import io.vertx.codegen.type.EnumTypeInfo;
import io.vertx.codegen.type.ParameterizedTypeInfo;
import io.vertx.codegen.type.TypeInfo;
import io.vertx.codegen.type.TypeVariableInfo;
import io.vertx.codegen.writer.CodeWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;

public abstract class AbstractJSClassGenerator<M extends ClassModel>
extends Generator<M> {
    protected String renderLinkToHtml(Tag.Link link) {
        ClassTypeInfo rawType = link.getTargetType().getRaw();
        if (rawType.getModule() != null) {
            String label = link.getLabel().trim();
            if (rawType.getKind() == ClassKind.DATA_OBJECT) {
                if (label.length() == 0) {
                    label = rawType.getSimpleName();
                }
                return "<a href=\"../../dataobjects.html#" + rawType.getSimpleName() + "\">" + label + "</a>";
            }
            if (rawType.getKind() == ClassKind.ENUM && ((EnumTypeInfo)rawType).isGen()) {
                if (label.length() == 0) {
                    label = rawType.getSimpleName();
                }
                return "<a href=\"../../enums.html#" + rawType.getSimpleName() + "\">" + label + "</a>";
            }
            if (label.length() > 0) {
                label = "[" + label + "] ";
            }
            Element elt = link.getTargetElement();
            String jsType = rawType.getSimpleName();
            ElementKind kind = elt.getKind();
            if (kind == ElementKind.CLASS || kind == ElementKind.INTERFACE) {
                return label + "{@link " + jsType + "}";
            }
            if (kind == ElementKind.METHOD) {
                return label + "{@link " + jsType + "#" + elt.getSimpleName().toString() + "}";
            }
            System.out.println("Unhandled kind " + (Object)((Object)kind));
        }
        return null;
    }

    protected String getModuleName(ClassTypeInfo type) {
        return type.getModuleName() + "-js/" + Case.CAMEL.to(Case.SNAKE, type.getSimpleName());
    }

    protected String getJSDocType(TypeInfo type) {
        switch (type.getKind()) {
            case STRING: {
                return "string";
            }
            case PRIMITIVE: 
            case BOXED_PRIMITIVE: {
                switch (type.getSimpleName()) {
                    case "boolean": 
                    case "Boolean": {
                        return "boolean";
                    }
                    case "char": 
                    case "Character": {
                        return "string";
                    }
                }
                return "number";
            }
            case JSON_OBJECT: 
            case DATA_OBJECT: 
            case ENUM: 
            case OBJECT: {
                return "Object";
            }
            case JSON_ARRAY: {
                return "Array";
            }
            case API: {
                return type.getRaw().getSimpleName();
            }
            case MAP: {
                return "Object.<string, " + this.getJSDocType(((ParameterizedTypeInfo)type).getArg(1)) + ">";
            }
            case HANDLER: 
            case FUNCTION: {
                return "function";
            }
            case SET: 
            case LIST: {
                return "Array.<" + this.getJSDocType(((ParameterizedTypeInfo)type).getArg(0)) + ">";
            }
        }
        return "todo";
    }

    protected String convParam(M model, MethodInfo method, String argName, boolean overloaded, ParamInfo param) {
        boolean funct;
        StringWriter buffer = new StringWriter();
        CodeWriter writer = new CodeWriter((Writer)buffer);
        String paramName = overloaded ? argName : param.getName();
        ClassKind paramKind = param.getType().getKind();
        boolean bl = funct = paramKind == ClassKind.FUNCTION;
        if (paramKind == ClassKind.HANDLER || funct) {
            ParameterizedTypeInfo type = (ParameterizedTypeInfo)param.getType();
            if (type.getArg(0).getKind() == ClassKind.ASYNC_RESULT) {
                ParameterizedTypeInfo asyncType = (ParameterizedTypeInfo)type.getArg(0);
                if (param.isNullable()) {
                    writer.format("%s == null ? null : ", new Object[]{paramName});
                }
                writer.println("function(ar) {");
                writer.indent();
                if (funct) {
                    writer.println("var jRet;");
                }
                writer.println("if (ar.succeeded()) {");
                writer.indent();
                if (funct) {
                    writer.print("jRet = ");
                }
                writer.print(paramName);
                writer.print("(");
                if ("java.lang.Void".equals(asyncType.getArg(0).getName())) {
                    writer.print("null");
                } else {
                    writer.print(this.convReturn(model, method, asyncType.getArg(0), this.arVal()));
                }
                writer.println(", null);");
                writer.unindent();
                writer.println("} else {");
                writer.indent();
                if (funct) {
                    writer.print("jRet = ");
                }
                writer.print(paramName);
                writer.println("(null, ar.cause());");
                writer.unindent();
                writer.println("}");
                if (funct) {
                    writer.println("return jRet;");
                }
                writer.unindent();
                writer.print("}");
            } else if ("java.lang.Void".equals(type.getArg(0).getName())) {
                writer.print(paramName);
            } else {
                if (param.isNullable()) {
                    writer.print(paramName);
                    writer.print(" == null ? null : ");
                }
                writer.println("function(jVal) {");
                writer.indent();
                if (funct) {
                    writer.print("var jRet = ");
                }
                writer.print(paramName);
                writer.format("(%s);\n", new Object[]{this.convReturn(model, method, type.getArg(0), this.basicVal())});
                if (funct) {
                    writer.format("return %s;\n", new Object[]{this.unwrapToJava(method, param, type.getArg(1), "jRet")});
                }
                writer.unindent();
                writer.print("}");
            }
        } else {
            writer.print(this.unwrapToJava(method, param, param.getType(), paramName));
        }
        return buffer.toString();
    }

    protected abstract String convReturn(M var1, MethodInfo var2, TypeInfo var3, String var4);

    protected void genDoc(M model, CodeWriter writer) {
        writer.println("/**");
        if (model.getIfaceComment() != null) {
            writer.println(Helper.removeTags((String)model.getIfaceComment()));
        }
        writer.println(" @class");
        writer.println("*/");
    }

    protected String unwrapToJava(MethodInfo method, ParamInfo param, TypeInfo unwrappedType, String unwrappedName) {
        StringWriter buffer = new StringWriter();
        PrintWriter writer = new PrintWriter(buffer);
        ClassKind kind = unwrappedType.getKind();
        block0 : switch (kind) {
            case JSON_OBJECT: {
                writer.format("utils.convParamJsonObject(%s)", unwrappedName);
                break;
            }
            case JSON_ARRAY: {
                writer.format("utils.convParamJsonArray(%s)", unwrappedName);
                break;
            }
            case DATA_OBJECT: {
                writer.format("%s  != null ? new %s(new JsonObject(Java.asJSONCompatible(%s))) : null", unwrappedName, unwrappedType.getSimpleName(), unwrappedName);
                break;
            }
            case ENUM: {
                if (param.isNullable()) {
                    writer.format("%s == null ? null : ", unwrappedName);
                }
                writer.format("%s.valueOf(%s)", unwrappedType.getName(), unwrappedName);
                break;
            }
            case OBJECT: {
                if (unwrappedType.isVariable()) {
                    TypeVariableInfo type = (TypeVariableInfo)unwrappedType;
                    if (type.isClassParam()) {
                        writer.format("j_%s.unwrap(%s)", unwrappedType.getName(), unwrappedName);
                        break;
                    }
                    ParamInfo classTypeParam = method.resolveClassTypeParam(type);
                    if (classTypeParam != null) {
                        writer.format("utils.get_jtype(__args[%s]).unwrap(%s)", classTypeParam.getIndex(), unwrappedName);
                        break;
                    }
                    writer.format("utils.convParamTypeUnknown(%s)", unwrappedName);
                    break;
                }
                writer.format("utils.convParamTypeUnknown(%s)", unwrappedName);
                break;
            }
            case THROWABLE: {
                writer.format("utils.convParamThrowable(%s)", unwrappedName);
                break;
            }
            case CLASS_TYPE: {
                writer.format("utils.get_jclass(%s)", unwrappedName);
                break;
            }
            case SET: 
            case LIST: {
                String container = kind == ClassKind.LIST ? "List" : "Set";
                ParameterizedTypeInfo type = (ParameterizedTypeInfo)unwrappedType;
                TypeInfo arg = type.getArg(0);
                String argName = arg.getName();
                ClassKind argKind = arg.getKind();
                if ("java.lang.Long".equals(argName)) {
                    writer.format("utils.convParam%sLong(%s)", container, unwrappedName);
                    break;
                }
                if ("java.lang.Short".equals(argName)) {
                    writer.format("utils.convParam%sShort(%s)", container, unwrappedName);
                    break;
                }
                if ("java.lang.Byte".equals(argName)) {
                    writer.format("utils.convParam%sByte(%s)", container, unwrappedName);
                    break;
                }
                if (argKind == ClassKind.API) {
                    writer.format("utils.convParam%sVertxGen(%s)", container, unwrappedName);
                    break;
                }
                if (argKind == ClassKind.JSON_OBJECT) {
                    writer.format("utils.convParam%sJsonObject(%s)", container, unwrappedName);
                    break;
                }
                if (argKind == ClassKind.JSON_ARRAY) {
                    writer.format("utils.convParam%sJsonArray(%s)", container, unwrappedName);
                    break;
                }
                if (argKind == ClassKind.DATA_OBJECT) {
                    writer.format("utils.convParam%sDataObject(%s, function(json) { return new %s(json); })", container, unwrappedName, arg.getSimpleName());
                    break;
                }
                if (argKind == ClassKind.ENUM) {
                    writer.format("utils.convParam%sEnum(%s, function(val) { return Packages.%s.valueOf(val); })", container, unwrappedName, arg.getName());
                    break;
                }
                if (param.isNullable()) {
                    writer.format("%s == null ? null : ", unwrappedName);
                }
                writer.format("utils.convParam%sBasicOther(%s)", container, unwrappedName);
                break;
            }
            case MAP: {
                ParameterizedTypeInfo type = (ParameterizedTypeInfo)unwrappedType;
                TypeInfo arg = type.getArg(1);
                String argName = arg.getName();
                ClassKind argKind = arg.getKind();
                if ("java.lang.Long".equals(argName)) {
                    writer.format("utils.convParamMapLong(%s)", unwrappedName);
                    break;
                }
                if ("java.lang.Short".equals(argName)) {
                    writer.format("utils.convParamMapShort(%s)", unwrappedName);
                    break;
                }
                if ("java.lang.Byte".equals(argName)) {
                    writer.format("utils.convParamMapByte(%s)", unwrappedName);
                    break;
                }
                if (argKind == ClassKind.API) {
                    writer.format("utils.convParamMapVertxGen(%s)", unwrappedName);
                    break;
                }
                if (argKind == ClassKind.JSON_OBJECT) {
                    writer.format("utils.convParamMapJsonObject(%s)", unwrappedName);
                    break;
                }
                if (argKind == ClassKind.JSON_ARRAY) {
                    writer.format("utils.convParamMapJsonArray(%s)", unwrappedName);
                    break;
                }
                writer.print(unwrappedName);
                break;
            }
            case STRING: 
            case PRIMITIVE: 
            case BOXED_PRIMITIVE: {
                switch (unwrappedType.getName()) {
                    case "java.lang.Byte": {
                        writer.format("utils.convParamByte(%s)", unwrappedName);
                        break block0;
                    }
                    case "java.lang.Short": {
                        writer.format("utils.convParamShort(%s)", unwrappedName);
                        break block0;
                    }
                    case "java.lang.Integer": {
                        writer.format("utils.convParamInteger(%s)", unwrappedName);
                        break block0;
                    }
                    case "java.lang.Long": {
                        writer.format("utils.convParamLong(%s)", unwrappedName);
                        break block0;
                    }
                    case "java.lang.Float": {
                        writer.format("utils.convParamFloat(%s)", unwrappedName);
                        break block0;
                    }
                    case "java.lang.Double": {
                        writer.format("utils.convParamDouble(%s)", unwrappedName);
                        break block0;
                    }
                    case "java.lang.Character": {
                        writer.format("utils.convParamCharacter(%s)", unwrappedName);
                        break block0;
                    }
                }
                writer.print(unwrappedName);
                break;
            }
            default: {
                if (param.isNullable()) {
                    writer.format("%s == null ? null : ", unwrappedName);
                }
                writer.format("%s._jdel", unwrappedName);
            }
        }
        return buffer.toString();
    }

    protected String arVal() {
        return "ar.result()";
    }

    protected String basicVal() {
        return "jVal";
    }

    protected void genConstant(M model, ConstantInfo constant, CodeWriter writer) {
        String templ = "J" + model.getType().getSimpleName() + "." + constant.getName();
        writer.format("%s.%s = %s;\n", new Object[]{model.getType().getSimpleName(), constant.getName(), this.convReturn(model, null, constant.getType(), templ)});
    }

    protected void genMethod(M model, String methodName, boolean genStatic, Predicate<MethodInfo> methodFilter, CodeWriter writer) {
        ClassTypeInfo type = model.getType();
        String simpleName = type.getSimpleName();
        Map methodsByName = model.getMethodMap();
        ArrayList<MethodInfo> methodList = (ArrayList<MethodInfo>)methodsByName.get(methodName);
        if (methodFilter != null) {
            ArrayList<MethodInfo> methodTmpl = methodList;
            methodList = new ArrayList<MethodInfo>();
            for (MethodInfo method : methodTmpl) {
                if (!methodFilter.test(method)) continue;
                methodList.add(method);
            }
        }
        if (methodList.size() > 0) {
            boolean overloaded = methodList.size() > 1;
            MethodInfo method = (MethodInfo)methodList.get(methodList.size() - 1);
            if (genStatic == method.isStaticMethod()) {
                writer.println("/**");
                if (method.getDoc() != null) {
                    Token.toHtml((List)method.getDoc().getTokens(), (String)"", this::renderLinkToHtml, (String)"\n", (PrintWriter)writer);
                }
                writer.println();
                writer.print(" ");
                if (genStatic) {
                    writer.format("@memberof module:%s", new Object[]{this.getModuleName(type)}).println();
                } else {
                    writer.println("@public");
                }
                boolean first = true;
                for (ParamInfo param : method.getParams()) {
                    if (first) {
                        first = false;
                    } else {
                        writer.println();
                    }
                    writer.format(" @param %s {%s} ", new Object[]{param.getName(), this.getJSDocType(param.getType())});
                    if (param.getDescription() == null) continue;
                    Token.toHtml((List)param.getDescription().getTokens(), (String)"", this::renderLinkToHtml, (String)"", (PrintWriter)writer);
                    writer.print(" ");
                }
                writer.println();
                if (method.getReturnType().getKind() != ClassKind.VOID) {
                    writer.format(" @return {%s}", new Object[]{this.getJSDocType(method.getReturnType())});
                    if (method.getReturnDescription() != null) {
                        writer.print(" ");
                        Token.toHtml((List)method.getReturnDescription().getTokens(), (String)"", this::renderLinkToHtml, (String)"", (PrintWriter)writer);
                    }
                    writer.println();
                }
                writer.println(" */");
                writer.format("%s.%s = ", new Object[]{genStatic ? simpleName : "this", methodName});
                if (overloaded) {
                    writer.println(" function() {");
                } else {
                    writer.format(" function(%s) {\n", new Object[]{method.getParams().stream().map(ParamInfo::getName).collect(Collectors.joining(", "))});
                }
                int mcnt = 0;
                writer.indent();
                writer.println("var __args = arguments;");
                for (MethodInfo m : methodList) {
                    writer.print(mcnt++ == 0 ? "if" : "else if");
                    int paramSize = m.getParams().size();
                    writer.format(" (__args.length === %s", new Object[]{paramSize});
                    int cnt = 0;
                    if (paramSize > 0) {
                        writer.print(" && ");
                    }
                    first = true;
                    for (ParamInfo param : m.getParams()) {
                        if (first) {
                            first = false;
                        } else {
                            writer.print(" && ");
                        }
                        switch (param.getType().getKind()) {
                            case PRIMITIVE: 
                            case BOXED_PRIMITIVE: {
                                if (param.isNullable()) {
                                    writer.print("(");
                                }
                                writer.format("typeof __args[%s] ===", new Object[]{cnt});
                                String paramSimpleName = param.getType().getSimpleName();
                                if ("boolean".equalsIgnoreCase(paramSimpleName)) {
                                    writer.print("'boolean'");
                                } else if ("char".equals(paramSimpleName) || "Character".equals(paramSimpleName)) {
                                    writer.print("'string'");
                                } else {
                                    writer.print("'number'");
                                }
                                if (!param.isNullable()) break;
                                writer.format(" || __args[%s] == null)", new Object[]{cnt});
                                break;
                            }
                            case STRING: 
                            case ENUM: {
                                if (param.isNullable()) {
                                    writer.print("(");
                                }
                                writer.format("typeof __args[%s] === 'string'", new Object[]{cnt});
                                if (!param.isNullable()) break;
                                writer.format(" || __args[%s] == null)", new Object[]{cnt});
                                break;
                            }
                            case CLASS_TYPE: {
                                writer.format("typeof __args[%s] === 'function'", new Object[]{cnt});
                                break;
                            }
                            case API: {
                                writer.format("typeof __args[%s] === 'object' && ", new Object[]{cnt});
                                if (param.isNullable()) {
                                    writer.format("(__args[%s] == null || ", new Object[]{cnt});
                                }
                                writer.format("__args[%s]._jdel", new Object[]{cnt});
                                if (!param.isNullable()) break;
                                writer.print(")");
                                break;
                            }
                            case JSON_ARRAY: 
                            case SET: 
                            case LIST: {
                                writer.format("typeof __args[%s] === 'object' && ", new Object[]{cnt});
                                if (param.isNullable()) {
                                    writer.print("(");
                                }
                                writer.format("__args[%s] instanceof Array", new Object[]{cnt});
                                if (!param.isNullable()) break;
                                writer.format(" || __args[%s] == null)", new Object[]{cnt});
                                break;
                            }
                            case HANDLER: {
                                if (param.isNullable()) {
                                    writer.print("(");
                                }
                                writer.format("typeof __args[%s] === 'function'", new Object[]{cnt});
                                if (!param.isNullable()) break;
                                writer.format(" || __args[%s] == null)", new Object[]{cnt});
                                break;
                            }
                            case OBJECT: {
                                if (param.getType().isVariable() && ((TypeVariableInfo)param.getType()).isClassParam()) {
                                    writer.format("j_%s.accept(__args[%s])", new Object[]{param.getType().getName(), cnt});
                                    break;
                                }
                                writer.format("typeof __args[%s] !== 'function'", new Object[]{cnt});
                                break;
                            }
                            case FUNCTION: {
                                writer.format("typeof __args[%s] === 'function'", new Object[]{cnt});
                                break;
                            }
                            case THROWABLE: {
                                writer.format("typeof __args[%s] === 'object'", new Object[]{cnt});
                                break;
                            }
                            default: {
                                if (!param.isNullable()) {
                                    writer.print("(");
                                }
                                writer.format("typeof __args[%s] === 'object'", new Object[]{cnt});
                                if (param.isNullable()) break;
                                writer.format(" && __args[%s] != null)", new Object[]{cnt});
                            }
                        }
                        ++cnt;
                    }
                    writer.println(") {");
                    writer.indent();
                    this.genMethodAdapter(model, m, writer);
                    writer.unindent();
                    writer.print("}");
                }
                writer.unindent();
                writer.println(" else throw new TypeError('function invoked with invalid arguments');");
                writer.println("};");
                writer.println();
            }
        }
    }

    protected abstract void genMethodAdapter(M var1, MethodInfo var2, CodeWriter var3);

    protected void genLicenses(PrintWriter writer) {
        writer.println("/*");
        writer.println(" * Copyright 2014 Red Hat, Inc.");
        writer.println(" *");
        writer.println(" * Red Hat licenses this file to you under the Apache License, version 2.0");
        writer.println(" * (the \"License\"); you may not use this file except in compliance with the");
        writer.println(" * License.  You may obtain a copy of the License at:");
        writer.println(" *");
        writer.println(" * http://www.apache.org/licenses/LICENSE-2.0");
        writer.println(" *");
        writer.println(" * Unless required by applicable law or agreed to in writing, software");
        writer.println(" * distributed under the License is distributed on an \"AS IS\" BASIS, WITHOUT");
        writer.println(" * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the");
        writer.println(" * License for the specific language governing permissions and limitations");
        writer.println(" * under the License.");
        writer.println(" */");
    }
}

