/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.lang.js.generator;

import io.vertx.codegen.ClassModel;
import io.vertx.codegen.ConstantInfo;
import io.vertx.codegen.Helper;
import io.vertx.codegen.MethodInfo;
import io.vertx.codegen.ParamInfo;
import io.vertx.codegen.TypeParamInfo;
import io.vertx.codegen.type.ApiTypeInfo;
import io.vertx.codegen.type.ClassKind;
import io.vertx.codegen.type.ClassTypeInfo;
import io.vertx.codegen.type.ParameterizedTypeInfo;
import io.vertx.codegen.type.TypeInfo;
import io.vertx.codegen.type.TypeVariableInfo;
import io.vertx.codegen.writer.CodeWriter;
import io.vertx.lang.js.generator.AbstractJSClassGenerator;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class JSClassGenerator
extends AbstractJSClassGenerator<ClassModel> {
    JSClassGenerator() {
        this.name = "JavaScript";
        this.kinds = Collections.singleton("class");
    }

    public String filename(ClassModel model) {
        ClassTypeInfo type = model.getType();
        return "resources/" + type.getModuleName() + "-js/" + Helper.convertCamelCaseToUnderscores((String)type.getRaw().getSimpleName()) + ".js";
    }

    public String render(ClassModel model, int index, int size, Map<String, Object> session) {
        ClassTypeInfo type = model.getType();
        String simpleName = type.getSimpleName();
        String ifaceName = Helper.decapitaliseFirstLetter((String)simpleName);
        StringWriter sw = new StringWriter();
        CodeWriter writer = new CodeWriter((Writer)sw);
        this.genLicenses((PrintWriter)writer);
        writer.println();
        writer.format("/** @module %s */\n", new Object[]{this.getModuleName(type)});
        this.genRequire(model, (PrintWriter)writer);
        writer.println();
        this.genDoc(model, writer);
        writer.format("var %s = function(j_val", new Object[]{simpleName});
        for (TypeParamInfo.Class param : model.getTypeParams()) {
            writer.format(", j_arg_%s", new Object[]{param.getIndex()});
        }
        writer.println(") {");
        writer.println();
        writer.indent();
        writer.format("var j_%s = j_val;\n", new Object[]{ifaceName});
        writer.println("var that = this;");
        writer.unindent();
        for (TypeParamInfo.Class param : model.getTypeParams()) {
            writer.format("  var j_%s = typeof j_arg_%s !== 'undefined' ? j_arg_%s : utils.unknown_jtype;", new Object[]{param.getName(), param.getIndex(), param.getIndex()});
        }
        writer.indent();
        for (TypeInfo superType : model.getSuperTypes()) {
            writer.print(superType.getRaw().getSimpleName());
            writer.print(".call(this, j_val");
            if (superType instanceof ParameterizedTypeInfo && ((ApiTypeInfo)superType.getRaw()).isConcrete()) {
                for (TypeInfo arg : ((ParameterizedTypeInfo)superType).getArgs()) {
                    if (arg.getKind() == ClassKind.API) {
                        writer.format(", %s._jtype", new Object[]{arg.getSimpleName()});
                        continue;
                    }
                    if (arg.isVariable()) {
                        writer.format(", j_%s", new Object[]{arg.getName()});
                        continue;
                    }
                    writer.print(", undefined");
                }
            }
            writer.append((CharSequence)");\n");
        }
        writer.println();
        for (String methodName : model.getMethodMap().keySet()) {
            this.genMethod(model, methodName, false, null, writer);
        }
        writer.append((CharSequence)"// A reference to the underlying Java delegate\n").append((CharSequence)"// NOTE! This is an internal API and must not be used in user code.\n").append((CharSequence)"// If you rely on this property your code is likely to break if we change it / remove it without warning.\n").format("this._jdel = j_%s;\n", new Object[]{ifaceName});
        writer.unindent().append((CharSequence)"};\n");
        writer.println();
        writer.format("%s._jclass = utils.getJavaClass(\"%s\");\n", new Object[]{simpleName, type.getRaw().getName()});
        writer.format("%s._jtype = {", new Object[]{simpleName}).indent().append((CharSequence)"accept: function(obj) {\n").indent().format("return %s._jclass.isInstance(obj._jdel);\n", new Object[]{simpleName}).unindent().append((CharSequence)"},").append((CharSequence)"wrap: function(jdel) {\n").indent().format("var obj = Object.create(%s.prototype, {});\n", new Object[]{simpleName}).format("%s.apply(obj, arguments);\n", new Object[]{simpleName}).append((CharSequence)"return obj;\n").unindent().append((CharSequence)"},\n").append((CharSequence)"unwrap: function(obj) {\n").indent().append((CharSequence)"return obj._jdel;\n").unindent().append((CharSequence)"}\n").unindent().append((CharSequence)"};\n");
        writer.format("%s._create = function(jdel) {", new Object[]{simpleName}).indent().format("var obj = Object.create(%s.prototype, {});\n", new Object[]{simpleName}).format("%s.apply(obj, arguments);\n", new Object[]{simpleName}).append((CharSequence)"return obj;\n").unindent().append((CharSequence)"}\n");
        for (String methodName : model.getMethodMap().keySet()) {
            this.genMethod(model, methodName, true, null, writer);
        }
        for (ConstantInfo constant : model.getConstants()) {
            this.genConstant(model, constant, writer);
        }
        writer.format("module.exports = %s;", new Object[]{simpleName});
        return sw.toString();
    }

    @Override
    protected void genMethodAdapter(ClassModel model, MethodInfo method, CodeWriter writer) {
        if (method.getReturnType().getKind() != ClassKind.VOID) {
            if (method.isFluent()) {
                writer.format("%s ;\n", new Object[]{this.genMethodCall(model, method)});
                writer.format("return %s;\n", new Object[]{method.isStaticMethod() ? model.getType().getSimpleName() : "that"});
            } else if (method.isCacheReturn()) {
                writer.format("if (that.cached%s == null) {\n", new Object[]{method.getName()}).indent().format("that.cached%s = %s;\n", new Object[]{method.getName(), this.convReturn(model, method, method.getReturnType(), this.genMethodCall(model, method))}).unindent().append((CharSequence)"}\n").format("return that.cached%s;\n", new Object[]{method.getName()});
            } else {
                writer.format("return %s ;\n", new Object[]{this.convReturn(model, method, method.getReturnType(), this.genMethodCall(model, method))});
            }
        } else {
            writer.format("%s;\n", new Object[]{this.genMethodCall(model, method)});
        }
    }

    private String genMethodCall(ClassModel model, MethodInfo method) {
        StringWriter sw = new StringWriter();
        PrintWriter writer = new PrintWriter(sw);
        String simpleName = model.getType().getSimpleName();
        String ifaceName = Helper.decapitaliseFirstLetter((String)simpleName);
        if (method.isStaticMethod()) {
            writer.format("J%s", simpleName);
        } else {
            writer.format("j_%s", ifaceName);
        }
        writer.format("[\"%s(", method.getName());
        boolean first = true;
        for (ParamInfo param : method.getParams()) {
            if (first) {
                first = false;
            } else {
                writer.print(",");
            }
            if (param.getType().isParameterized()) {
                writer.print(param.getType().getRaw().getName());
                continue;
            }
            if (param.getType().isVariable()) {
                writer.print("java.lang.Object");
                continue;
            }
            writer.print(param.getType().getName());
        }
        writer.print(")\"](");
        int pcnt = 0;
        first = true;
        for (ParamInfo param : method.getParams()) {
            if (first) {
                first = false;
            } else {
                writer.print(", ");
            }
            boolean overloaded = ((List)model.getMethodMap().get(method.getName())).size() > 1;
            writer.print(this.convParam(model, method, "__args[" + pcnt++ + "]", overloaded, param));
        }
        writer.print(")");
        return sw.toString();
    }

    @Override
    protected String convReturn(ClassModel model, MethodInfo method, TypeInfo returnType, String templ) {
        ClassKind kind = returnType.getKind();
        if (kind == ClassKind.LIST || kind == ClassKind.SET) {
            TypeInfo elementType = ((ParameterizedTypeInfo)returnType).getArg(0);
            ClassKind elementKind = elementType.getKind();
            if (elementKind.json) {
                return String.format("utils.convReturnListSetJson(%s)", templ);
            }
            if (elementKind == ClassKind.DATA_OBJECT) {
                return String.format("utils.convReturnListSetDataObject(%s)", templ);
            }
            if (elementKind == ClassKind.ENUM) {
                return String.format("utils.convReturnListSetEnum(%s)", templ);
            }
            if (elementKind == ClassKind.API) {
                return String.format("utils.convReturnListSetVertxGen(%s, %s)", templ, elementType.getRaw().getSimpleName());
            }
            if ("java.lang.Long".equals(elementType.getName())) {
                return String.format("utils.convReturnListSetLong(%s)", templ);
            }
            if (kind == ClassKind.LIST) {
                return templ;
            }
            return String.format("utils.convReturnSet(%s)", templ);
        }
        if (kind == ClassKind.MAP) {
            return String.format("utils.convReturnMap(%s)", templ);
        }
        if (kind.json) {
            return String.format("utils.convReturnJson(%s)", templ);
        }
        if (kind.basic) {
            if ("java.lang.Long".equals(returnType.getName())) {
                return String.format("utils.convReturnLong(%s)", templ);
            }
            return templ;
        }
        if (kind == ClassKind.API) {
            StringWriter buffer = new StringWriter();
            PrintWriter writer = new PrintWriter(buffer);
            writer.format("utils.convReturnVertxGen(%s, %s", returnType.getRaw().getSimpleName(), templ);
            if (returnType.isParameterized()) {
                for (TypeInfo arg : ((ParameterizedTypeInfo)returnType).getArgs()) {
                    ClassKind argKind = arg.getKind();
                    if (argKind == ClassKind.API) {
                        writer.format(", %s._jtype", arg.getSimpleName());
                        continue;
                    }
                    if (argKind == ClassKind.ENUM) {
                        writer.format(", utils.enum_jtype(%s)", arg.getName());
                        continue;
                    }
                    if (argKind == ClassKind.OBJECT) {
                        ParamInfo classTypeParam;
                        ParamInfo paramInfo = classTypeParam = method != null ? method.resolveClassTypeParam((TypeVariableInfo)arg) : null;
                        if (classTypeParam != null) {
                            writer.format(", utils.get_jtype(__args[%s])", classTypeParam.getIndex());
                            continue;
                        }
                        writer.print(", undefined");
                        continue;
                    }
                    writer.print(", undefined");
                }
            }
            writer.print(")");
            return buffer.toString();
        }
        if (kind == ClassKind.ENUM) {
            return String.format("utils.convReturnEnum(%s)", templ);
        }
        if (kind == ClassKind.DATA_OBJECT) {
            return String.format("utils.convReturnDataObject(%s)", templ);
        }
        if (kind == ClassKind.THROWABLE) {
            return String.format("utils.convReturnThrowable(%s)", templ);
        }
        if (kind == ClassKind.HANDLER) {
            ParameterizedTypeInfo type = (ParameterizedTypeInfo)returnType;
            if (type.getArg(0).getKind() == ClassKind.ASYNC_RESULT) {
                return String.format("utils.convReturnHandlerAsyncResult(%s, function(result) { return %s; })", templ, this.convParam(model, method, null, false, new ParamInfo(0, "result", null, ((ParameterizedTypeInfo)type.getArg(0)).getArg(0))));
            }
            return String.format("utils.convReturnHandler(%s, function(result) { return %s; })", templ, this.convParam(model, method, null, false, new ParamInfo(0, "result", null, type.getArg(0))));
        }
        if (returnType.isVariable() && method != null && method.resolveClassTypeParam((TypeVariableInfo)returnType) != null) {
            ParamInfo classTypeParam = method.resolveClassTypeParam((TypeVariableInfo)returnType);
            return String.format("utils.get_jtype(__args[%s]).wrap(%s)", classTypeParam.getIndex(), templ);
        }
        String wrapper = "utils.convReturnTypeUnknown";
        ClassTypeInfo type = model.getType();
        for (TypeParamInfo.Class param : type.getParams()) {
            if (!param.getName().equals(returnType.getName())) continue;
            wrapper = "j_" + param.getName() + ".wrap";
        }
        return String.format("%s(%s)", wrapper, templ);
    }

    private void genRequire(ClassModel model, PrintWriter writer) {
        ClassTypeInfo type = model.getType();
        writer.println("var utils = require('vertx-js/util/utils');");
        for (ClassTypeInfo referencedType : model.getReferencedTypes()) {
            writer.format("var %s = require('%s');\n", referencedType.getSimpleName(), this.getModuleName(referencedType));
        }
        writer.println();
        writer.println("var io = Packages.io;");
        writer.println("var JsonObject = io.vertx.core.json.JsonObject;");
        writer.format("var J%s = Java.type('%s');\n", type.getSimpleName(), type.getName());
        for (ClassTypeInfo dataObjectType : model.getReferencedDataObjectTypes()) {
            writer.format("var %s = Java.type('%s');\n", dataObjectType.getSimpleName(), dataObjectType.getName());
        }
    }
}

