/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.servicediscovery.consul;

import io.vertx.core.CompositeFuture;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.json.JsonObject;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import io.vertx.ext.consul.CheckStatus;
import io.vertx.ext.consul.ConsulClient;
import io.vertx.ext.consul.ConsulClientOptions;
import io.vertx.ext.consul.Service;
import io.vertx.ext.consul.ServiceEntry;
import io.vertx.ext.consul.ServiceEntryList;
import io.vertx.ext.consul.ServiceList;
import io.vertx.servicediscovery.Record;
import io.vertx.servicediscovery.consul.ImportedConsulService;
import io.vertx.servicediscovery.impl.ServiceTypes;
import io.vertx.servicediscovery.spi.ServiceImporter;
import io.vertx.servicediscovery.spi.ServicePublisher;
import io.vertx.servicediscovery.types.HttpLocation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;

public class ConsulServiceImporter
implements ServiceImporter {
    private ServicePublisher publisher;
    private ConsulClient client;
    private static final Logger LOGGER = LoggerFactory.getLogger(ConsulServiceImporter.class);
    private final List<ImportedConsulService> imports = new ArrayList<ImportedConsulService>();
    private long scanTask = -1L;
    private Vertx vertx;
    private String upThreshold;

    public void start(Vertx vertx, ServicePublisher publisher, JsonObject configuration, Future<Void> completion) {
        this.vertx = vertx;
        this.publisher = publisher;
        this.upThreshold = configuration.getString("up_threshold", "passing");
        ConsulClientOptions opts = new ConsulClientOptions().setHost(configuration.getString("host", "localhost")).setPort(configuration.getInteger("port", Integer.valueOf(8500)).intValue()).setDc(configuration.getString("dc")).setAclToken(configuration.getString("acl_token"));
        this.client = ConsulClient.create((Vertx)vertx, (ConsulClientOptions)opts);
        Future imports = Future.future();
        this.retrieveServicesFromConsul((Future<List<ImportedConsulService>>)imports);
        imports.setHandler(ar -> {
            if (ar.succeeded()) {
                Integer period = configuration.getInteger("scan-period", Integer.valueOf(2000));
                if (period != 0) {
                    this.scanTask = vertx.setPeriodic((long)period.intValue(), l -> {
                        Future future = Future.future();
                        future.setHandler(ar2 -> {
                            if (ar2.failed()) {
                                LOGGER.warn((Object)"Consul importation has failed", ar.cause());
                            }
                        });
                        this.retrieveServicesFromConsul((Future<List<ImportedConsulService>>)future);
                    });
                }
                completion.complete();
            } else {
                completion.fail(ar.cause());
            }
        });
    }

    private Handler<Throwable> getErrorHandler(Future future) {
        return t -> {
            if (future != null) {
                if (!future.isComplete()) {
                    future.fail(t);
                }
            } else {
                LOGGER.error(t);
            }
        };
    }

    private void retrieveServicesFromConsul(Future<List<ImportedConsulService>> completed) {
        this.client.catalogServices(ar -> {
            if (ar.succeeded()) {
                this.retrieveIndividualServices((ServiceList)ar.result(), completed);
            } else {
                completed.fail(ar.cause());
            }
        });
    }

    private boolean isCheckOK(CheckStatus checkStatus) {
        if (this.upThreshold.equals("passing")) {
            return checkStatus.equals((Object)CheckStatus.PASSING);
        }
        if (this.upThreshold.equals("warning")) {
            return checkStatus.equals((Object)CheckStatus.WARNING) || checkStatus.equals((Object)CheckStatus.PASSING);
        }
        return true;
    }

    private void retrieveIndividualServices(ServiceList list, Future<List<ImportedConsulService>> completed) {
        ArrayList futures = new ArrayList();
        list.getList().forEach(service -> {
            Future future = Future.future();
            this.client.healthServiceNodes(service.getName(), false, ar -> {
                if (ar.succeeded()) {
                    this.importService(((ServiceEntryList)ar.result()).getList(), (Future<List<ImportedConsulService>>)future);
                } else {
                    completed.fail(ar.cause());
                }
            });
            futures.add(future);
        });
        CompositeFuture.all(futures).setHandler(ar -> {
            if (ar.failed()) {
                LOGGER.error((Object)"Fail to retrieve the services from consul", ar.cause());
            } else {
                List<ImportedConsulService> services = futures.stream().map(future -> (List)future.result()).flatMap(Collection::stream).collect(Collectors.toList());
                List retrievedIds = services.stream().map(ImportedConsulService::id).collect(Collectors.toList());
                ConsulServiceImporter consulServiceImporter = this;
                synchronized (consulServiceImporter) {
                    List existingIds = this.imports.stream().map(ImportedConsulService::id).collect(Collectors.toList());
                    LOGGER.trace((Object)("Imported services: " + existingIds + ", Retrieved services form Consul: " + retrievedIds));
                    services.forEach(svc -> {
                        String id = svc.id();
                        if (!existingIds.contains(id)) {
                            LOGGER.info((Object)("Imported service: " + id));
                            this.imports.add((ImportedConsulService)svc);
                        }
                    });
                    ArrayList toRemove = new ArrayList();
                    this.imports.forEach(svc -> {
                        if (!retrievedIds.contains(svc.id())) {
                            LOGGER.info((Object)("Unregistering " + svc.id()));
                            toRemove.add(svc);
                            svc.unregister(this.publisher, null);
                        }
                    });
                    this.imports.removeAll(toRemove);
                }
            }
            if (ar.succeeded()) {
                completed.complete();
            } else {
                completed.fail(ar.cause());
            }
        });
    }

    private void importService(List<ServiceEntry> list, Future<List<ImportedConsulService>> future) {
        if (list.isEmpty()) {
            future.fail("no service with the given name");
        } else {
            List serviceEntries = list.stream().filter(serviceEntry -> serviceEntry.getChecks().stream().allMatch(check -> this.isCheckOK(check.getStatus()))).collect(Collectors.toList());
            ArrayList<ImportedConsulService> importedServices = new ArrayList<ImportedConsulService>();
            ArrayList<Future> registrations = new ArrayList<Future>();
            for (int i = 0; i < serviceEntries.size(); ++i) {
                Future registration = Future.future();
                ServiceEntry consulService = (ServiceEntry)serviceEntries.get(i);
                String id = consulService.getService().getId();
                String name = consulService.getService().getName();
                Record record = this.createRecord(consulService.getService());
                ImportedConsulService imported = this.getImportedServiceById(id);
                if (imported != null) {
                    importedServices.add(imported);
                    registration.complete();
                } else {
                    LOGGER.info((Object)("Importing service " + record.getName() + " (" + id + ") from consul"));
                    ImportedConsulService service = new ImportedConsulService(name, id, record);
                    service.register(this.publisher, (Future<ImportedConsulService>)Future.future().setHandler(res -> {
                        if (res.succeeded()) {
                            importedServices.add((ImportedConsulService)res.result());
                            registration.complete();
                        } else {
                            registration.fail(res.cause());
                        }
                    }));
                }
                registrations.add(registration);
            }
            CompositeFuture.all(registrations).setHandler(ar -> {
                if (ar.succeeded()) {
                    future.complete((Object)importedServices);
                } else {
                    future.fail(ar.cause());
                }
            });
        }
    }

    private Record createRecord(Service service) {
        String address = service.getAddress();
        int port = service.getPort();
        JsonObject metadata = service.toJson();
        if (service.getTags() != null) {
            service.getTags().forEach(tag -> metadata.put(tag, Boolean.valueOf(true)));
        }
        Record record = new Record().setName(service.getName()).setMetadata(metadata);
        record.setType("unknown");
        ServiceTypes.all().forEachRemaining(type -> {
            if (metadata.getBoolean(type.name(), Boolean.valueOf(false)).booleanValue()) {
                record.setType(type.name());
            }
        });
        JsonObject location = new JsonObject();
        location.put("host", address);
        location.put("port", Integer.valueOf(port));
        if (record.getType().equals("http-endpoint")) {
            if (metadata.getBoolean("ssl", Boolean.valueOf(false)).booleanValue()) {
                location.put("ssl", Boolean.valueOf(true));
            }
            location = new HttpLocation(location).toJson();
        }
        record.setLocation(location);
        return record;
    }

    private synchronized ImportedConsulService getImportedServiceById(String id) {
        for (ImportedConsulService svc : this.imports) {
            if (!svc.id().equals(id)) continue;
            return svc;
        }
        return null;
    }

    public synchronized void close(Handler<Void> completionHandler) {
        if (this.scanTask != -1L) {
            this.vertx.cancelTimer(this.scanTask);
        }
        ArrayList list = new ArrayList();
        this.imports.forEach(imported -> {
            Future fut = Future.future();
            fut.setHandler(ar -> {
                LOGGER.info((Object)("Unregistering " + imported.name()));
                if (ar.succeeded()) {
                    list.add(Future.succeededFuture());
                } else {
                    list.add(Future.failedFuture((Throwable)ar.cause()));
                }
            });
            imported.unregister(this.publisher, (Future<Void>)fut);
        });
        CompositeFuture.all(list).setHandler(ar -> {
            this.clearImportedServices();
            if (ar.succeeded()) {
                LOGGER.info((Object)("Successfully closed the service importer " + this));
            } else {
                LOGGER.error((Object)("A failure has been caught while stopping " + this), ar.cause());
            }
            if (completionHandler != null) {
                completionHandler.handle(null);
            }
        });
    }

    private synchronized void clearImportedServices() {
        this.imports.clear();
    }
}

