/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.eclipse.aether.internal.impl.slf4j;

import javax.inject.Inject;
import javax.inject.Named;
import org.eclipse.sisu.Nullable;
import shaded.org.eclipse.aether.spi.locator.Service;
import shaded.org.eclipse.aether.spi.locator.ServiceLocator;
import shaded.org.eclipse.aether.spi.log.Logger;
import shaded.org.eclipse.aether.spi.log.LoggerFactory;
import shaded.org.slf4j.ILoggerFactory;
import shaded.org.slf4j.spi.LocationAwareLogger;

@Named(value="slf4j")
public class Slf4jLoggerFactory
implements LoggerFactory,
Service {
    private static final boolean AVAILABLE;
    private ILoggerFactory factory;

    public static boolean isSlf4jAvailable() {
        return AVAILABLE;
    }

    public Slf4jLoggerFactory() {
    }

    @Inject
    Slf4jLoggerFactory(@Nullable ILoggerFactory factory) {
        this.setLoggerFactory(factory);
    }

    public void initService(ServiceLocator locator) {
        this.setLoggerFactory(locator.getService(ILoggerFactory.class));
    }

    public Slf4jLoggerFactory setLoggerFactory(ILoggerFactory factory) {
        this.factory = factory;
        return this;
    }

    public Logger getLogger(String name) {
        shaded.org.slf4j.Logger logger = this.getFactory().getLogger(name);
        if (logger instanceof LocationAwareLogger) {
            return new Slf4jLoggerEx((LocationAwareLogger)logger);
        }
        return new Slf4jLogger(logger);
    }

    private ILoggerFactory getFactory() {
        if (this.factory == null) {
            this.factory = shaded.org.slf4j.LoggerFactory.getILoggerFactory();
        }
        return this.factory;
    }

    static {
        boolean available;
        try {
            Slf4jLoggerFactory.class.getClassLoader().loadClass("shaded.org.slf4j.ILoggerFactory");
            available = true;
        }
        catch (Exception e) {
            available = false;
        }
        catch (LinkageError e) {
            available = false;
        }
        AVAILABLE = available;
    }

    private static final class Slf4jLoggerEx
    implements Logger {
        private static final String FQCN = Slf4jLoggerEx.class.getName();
        private final LocationAwareLogger logger;

        public Slf4jLoggerEx(LocationAwareLogger logger) {
            this.logger = logger;
        }

        public boolean isDebugEnabled() {
            return this.logger.isDebugEnabled();
        }

        public void debug(String msg) {
            this.logger.log(null, FQCN, 10, msg, null, null);
        }

        public void debug(String msg, Throwable error) {
            this.logger.log(null, FQCN, 10, msg, null, error);
        }

        public boolean isWarnEnabled() {
            return this.logger.isWarnEnabled();
        }

        public void warn(String msg) {
            this.logger.log(null, FQCN, 30, msg, null, null);
        }

        public void warn(String msg, Throwable error) {
            this.logger.log(null, FQCN, 30, msg, null, error);
        }
    }

    private static final class Slf4jLogger
    implements Logger {
        private final shaded.org.slf4j.Logger logger;

        public Slf4jLogger(shaded.org.slf4j.Logger logger) {
            this.logger = logger;
        }

        public boolean isDebugEnabled() {
            return this.logger.isDebugEnabled();
        }

        public void debug(String msg) {
            this.logger.debug(msg);
        }

        public void debug(String msg, Throwable error) {
            this.logger.debug(msg, error);
        }

        public boolean isWarnEnabled() {
            return this.logger.isWarnEnabled();
        }

        public void warn(String msg) {
            this.logger.warn(msg);
        }

        public void warn(String msg, Throwable error) {
            this.logger.warn(msg, error);
        }
    }
}

