/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.redis.op;

import io.vertx.codegen.annotations.DataObject;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;

@DataObject
public class ScanOptions {
    public static final ScanOptions NONE = new ScanOptions();
    private String pattern;
    private Integer count;

    public ScanOptions() {
    }

    public ScanOptions(ScanOptions copy) {
        this.pattern = copy.pattern;
        this.count = copy.count;
    }

    public ScanOptions(JsonObject obj) {
        this.pattern = obj.getString("pattern");
        this.count = obj.getInteger("count");
    }

    public JsonObject toJson() {
        JsonObject result = new JsonObject();
        if (this.count != null) {
            result.put("count", this.count);
        } else if (this.pattern != null) {
            result.put("pattern", this.pattern);
        }
        return result;
    }

    public ScanOptions setCount(int count) {
        this.count = count;
        return this;
    }

    public ScanOptions setMatch(String pattern) {
        this.pattern = pattern;
        return this;
    }

    public JsonArray toJsonArray() {
        JsonArray result = new JsonArray();
        if (this.pattern != null) {
            result.add("MATCH");
            result.add(this.pattern);
        }
        if (this.count != null) {
            result.add("COUNT");
            result.add(this.count);
        }
        return result;
    }
}

