/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.rxjava.cassandra;

import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.Statement;
import io.vertx.cassandra.CassandraClientOptions;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.rx.java.SingleOnSubscribeAdapter;
import io.vertx.rxjava.cassandra.CassandraRowStream;
import io.vertx.rxjava.cassandra.ResultSet;
import java.util.List;
import rx.Single;

@RxGen(value=io.vertx.cassandra.CassandraClient.class)
public class CassandraClient {
    public static final TypeArg<CassandraClient> __TYPE_ARG = new TypeArg(obj -> new CassandraClient((io.vertx.cassandra.CassandraClient)obj), CassandraClient::getDelegate);
    private final io.vertx.cassandra.CassandraClient delegate;
    public static final String DEFAULT_POOL_NAME = "DEFAULT_POOL";

    public String toString() {
        return this.delegate.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CassandraClient that = (CassandraClient)o;
        return this.delegate.equals(that.delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public CassandraClient(io.vertx.cassandra.CassandraClient delegate) {
        this.delegate = delegate;
    }

    public io.vertx.cassandra.CassandraClient getDelegate() {
        return this.delegate;
    }

    public static CassandraClient createNonShared(io.vertx.rxjava.core.Vertx vertx) {
        CassandraClient ret = CassandraClient.newInstance(io.vertx.cassandra.CassandraClient.createNonShared((Vertx)vertx.getDelegate()));
        return ret;
    }

    public static CassandraClient createNonShared(io.vertx.rxjava.core.Vertx vertx, CassandraClientOptions cassandraClientOptions) {
        CassandraClient ret = CassandraClient.newInstance(io.vertx.cassandra.CassandraClient.createNonShared((Vertx)vertx.getDelegate(), (CassandraClientOptions)cassandraClientOptions));
        return ret;
    }

    public static CassandraClient createShared(io.vertx.rxjava.core.Vertx vertx) {
        CassandraClient ret = CassandraClient.newInstance(io.vertx.cassandra.CassandraClient.createShared((Vertx)vertx.getDelegate()));
        return ret;
    }

    public static CassandraClient createShared(io.vertx.rxjava.core.Vertx vertx, String datasourceName) {
        CassandraClient ret = CassandraClient.newInstance(io.vertx.cassandra.CassandraClient.createShared((Vertx)vertx.getDelegate(), (String)datasourceName));
        return ret;
    }

    public static CassandraClient createShared(io.vertx.rxjava.core.Vertx vertx, CassandraClientOptions cassandraClientOptions) {
        CassandraClient ret = CassandraClient.newInstance(io.vertx.cassandra.CassandraClient.createShared((Vertx)vertx.getDelegate(), (CassandraClientOptions)cassandraClientOptions));
        return ret;
    }

    public static CassandraClient createShared(io.vertx.rxjava.core.Vertx vertx, String datasourceName, CassandraClientOptions cassandraClientOptions) {
        CassandraClient ret = CassandraClient.newInstance(io.vertx.cassandra.CassandraClient.createShared((Vertx)vertx.getDelegate(), (String)datasourceName, (CassandraClientOptions)cassandraClientOptions));
        return ret;
    }

    public CassandraClient connect() {
        this.delegate.connect();
        return this;
    }

    public boolean isConnected() {
        boolean ret = this.delegate.isConnected();
        return ret;
    }

    public CassandraClient connect(Handler<AsyncResult<Void>> connectHandler) {
        this.delegate.connect(connectHandler);
        return this;
    }

    public Single<Void> rxConnect() {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.connect((Handler<AsyncResult<Void>>)fut)));
    }

    public CassandraClient connect(String keyspace, Handler<AsyncResult<Void>> connectHandler) {
        this.delegate.connect(keyspace, connectHandler);
        return this;
    }

    public Single<Void> rxConnect(String keyspace) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.connect(keyspace, (Handler<AsyncResult<Void>>)fut)));
    }

    public CassandraClient execute(String query, final Handler<AsyncResult<ResultSet>> resultHandler) {
        this.delegate.execute(query, (Handler)new Handler<AsyncResult<io.vertx.cassandra.ResultSet>>(){

            public void handle(AsyncResult<io.vertx.cassandra.ResultSet> ar) {
                if (ar.succeeded()) {
                    resultHandler.handle((Object)Future.succeededFuture((Object)ResultSet.newInstance((io.vertx.cassandra.ResultSet)ar.result())));
                } else {
                    resultHandler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
        return this;
    }

    public Single<ResultSet> rxExecute(String query) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.execute(query, (Handler<AsyncResult<ResultSet>>)fut)));
    }

    public CassandraClient queryStream(String sql, final Handler<AsyncResult<CassandraRowStream>> rowStreamHandler) {
        this.delegate.queryStream(sql, (Handler)new Handler<AsyncResult<io.vertx.cassandra.CassandraRowStream>>(){

            public void handle(AsyncResult<io.vertx.cassandra.CassandraRowStream> ar) {
                if (ar.succeeded()) {
                    rowStreamHandler.handle((Object)Future.succeededFuture((Object)CassandraRowStream.newInstance((io.vertx.cassandra.CassandraRowStream)ar.result())));
                } else {
                    rowStreamHandler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
        return this;
    }

    public Single<CassandraRowStream> rxQueryStream(String sql) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.queryStream(sql, (Handler<AsyncResult<CassandraRowStream>>)fut)));
    }

    public CassandraClient disconnect() {
        this.delegate.disconnect();
        return this;
    }

    public CassandraClient disconnect(Handler<AsyncResult<Void>> disconnectHandler) {
        this.delegate.disconnect(disconnectHandler);
        return this;
    }

    public Single<Void> rxDisconnect() {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.disconnect((Handler<AsyncResult<Void>>)fut)));
    }

    public CassandraClient executeWithFullFetch(String query, Handler<AsyncResult<List<Row>>> resultHandler) {
        this.delegate.executeWithFullFetch(query, resultHandler);
        return this;
    }

    public Single<List<Row>> rxExecuteWithFullFetch(String query) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.executeWithFullFetch(query, (Handler<AsyncResult<List<Row>>>)fut)));
    }

    public CassandraClient executeWithFullFetch(Statement statement, Handler<AsyncResult<List<Row>>> resultHandler) {
        this.delegate.executeWithFullFetch(statement, resultHandler);
        return this;
    }

    public Single<List<Row>> rxExecuteWithFullFetch(Statement statement) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.executeWithFullFetch(statement, (Handler<AsyncResult<List<Row>>>)fut)));
    }

    public CassandraClient execute(Statement statement, final Handler<AsyncResult<ResultSet>> resultHandler) {
        this.delegate.execute(statement, (Handler)new Handler<AsyncResult<io.vertx.cassandra.ResultSet>>(){

            public void handle(AsyncResult<io.vertx.cassandra.ResultSet> ar) {
                if (ar.succeeded()) {
                    resultHandler.handle((Object)Future.succeededFuture((Object)ResultSet.newInstance((io.vertx.cassandra.ResultSet)ar.result())));
                } else {
                    resultHandler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
        return this;
    }

    public Single<ResultSet> rxExecute(Statement statement) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.execute(statement, (Handler<AsyncResult<ResultSet>>)fut)));
    }

    public CassandraClient prepare(String query, Handler<AsyncResult<PreparedStatement>> resultHandler) {
        this.delegate.prepare(query, resultHandler);
        return this;
    }

    public Single<PreparedStatement> rxPrepare(String query) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.prepare(query, (Handler<AsyncResult<PreparedStatement>>)fut)));
    }

    public CassandraClient queryStream(Statement statement, final Handler<AsyncResult<CassandraRowStream>> rowStreamHandler) {
        this.delegate.queryStream(statement, (Handler)new Handler<AsyncResult<io.vertx.cassandra.CassandraRowStream>>(){

            public void handle(AsyncResult<io.vertx.cassandra.CassandraRowStream> ar) {
                if (ar.succeeded()) {
                    rowStreamHandler.handle((Object)Future.succeededFuture((Object)CassandraRowStream.newInstance((io.vertx.cassandra.CassandraRowStream)ar.result())));
                } else {
                    rowStreamHandler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
        return this;
    }

    public Single<CassandraRowStream> rxQueryStream(Statement statement) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.queryStream(statement, (Handler<AsyncResult<CassandraRowStream>>)fut)));
    }

    public static CassandraClient newInstance(io.vertx.cassandra.CassandraClient arg) {
        return arg != null ? new CassandraClient(arg) : null;
    }
}

